/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.scoping;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.Import;
import com.regnosys.rosetta.rosetta.ParametrizedRosettaType;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalEnum;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseGuard;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.scoping.AliasAwareImportNormalizer;
import com.regnosys.rosetta.scoping.ReversedSimpleScope;
import com.regnosys.rosetta.types.ExpectedTypeProvider;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.DeepFeatureCallUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    public static final String LIB_NAMESPACE = "com.rosetta.model";
    private static Logger LOGGER = LoggerFactory.getLogger(RosettaScopeProvider.class);
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private ExpectedTypeProvider expectedTypeProvider;
    @Inject
    @Extension
    private RosettaEcoreUtil _rosettaEcoreUtil;
    @Inject
    @Extension
    private RosettaFunctionExtensions _rosettaFunctionExtensions;
    @Inject
    @Extension
    private DeepFeatureCallUtil _deepFeatureCallUtil;
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;

    public IScope getScope(EObject context, EReference reference) {
        try {
            boolean _matched = false;
            if (Objects.equal((Object)reference, (Object)RosettaPackage.Literals.TYPE_CALL_ARGUMENT__PARAMETER)) {
                _matched = true;
                if (context instanceof TypeCall) {
                    RosettaType type = ((TypeCall)context).getType();
                    if (type instanceof ParametrizedRosettaType) {
                        return Scopes.scopeFor(((ParametrizedRosettaType)((Object)type)).getParameters());
                    }
                    return IScope.NULLSCOPE;
                }
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.ROSETTA_FEATURE_CALL__FEATURE)) {
                _matched = true;
                if (context instanceof RosettaFeatureCall) {
                    return this.createExtendedFeatureScope(((RosettaFeatureCall)context).getReceiver(), this.typeProvider.getRMetaAnnotatedType(((RosettaFeatureCall)context).getReceiver()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.ROSETTA_DEEP_FEATURE_CALL__FEATURE)) {
                _matched = true;
                if (context instanceof RosettaDeepFeatureCall) {
                    return this.createDeepFeatureScope(this.typeProvider.getRMetaAnnotatedType(((RosettaDeepFeatureCall)context).getReceiver()).getRType());
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.CHOICE_OPERATION__ATTRIBUTES)) {
                _matched = true;
                if (context instanceof ChoiceOperation) {
                    return this.createExtendedFeatureScope(((ChoiceOperation)context).getArgument(), RMetaAnnotatedType.withNoMeta(this.typeProvider.getRMetaAnnotatedType(((ChoiceOperation)context).getArgument()).getRType()));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_ATTRIBUTE_REFERENCE__ATTRIBUTE)) {
                _matched = true;
                if (context instanceof RosettaAttributeReference) {
                    return this.createExtendedFeatureScope(((RosettaAttributeReference)context).getReceiver(), RMetaAnnotatedType.withNoMeta(this.typeProvider.getRTypeOfAttributeReference(((RosettaAttributeReference)context).getReceiver())));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__KEY)) {
                _matched = true;
                if (context instanceof ConstructorKeyValuePair) {
                    EObject _eContainer = ((ConstructorKeyValuePair)context).eContainer();
                    RosettaConstructorExpression constructor = (RosettaConstructorExpression)_eContainer;
                    return Scopes.scopeFor(this._rosettaEcoreUtil.allFeatures(this.typeProvider.getRMetaAnnotatedType(constructor).getRType(), context));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.OPERATION__ASSIGN_ROOT)) {
                _matched = true;
                if (context instanceof Operation) {
                    ArrayList outAndAliases = CollectionLiterals.newArrayList();
                    Attribute out = this._rosettaFunctionExtensions.getOutput(((Operation)context).getFunction());
                    if (out != null) {
                        outAndAliases.add(out);
                    }
                    outAndAliases.addAll(((Operation)context).getFunction().getShortcuts());
                    return Scopes.scopeFor((Iterable)outAndAliases);
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.SEGMENT__ATTRIBUTE)) {
                _matched = true;
                boolean _matched_1 = false;
                if (context instanceof Operation) {
                    _matched_1 = true;
                    RMetaAnnotatedType receiverType = this.typeProvider.getRTypeOfSymbol(((Operation)context).getAssignRoot());
                    return Scopes.scopeFor(this._rosettaEcoreUtil.allFeatures(receiverType.getRType(), context));
                }
                if (!_matched_1 && context instanceof Segment) {
                    boolean _isResolved;
                    _matched_1 = true;
                    Segment prev = ((Segment)context).getPrev();
                    if (prev != null && (_isResolved = this._rosettaEcoreUtil.isResolved(prev.getAttribute()))) {
                        RMetaAnnotatedType receiverType = this.typeProvider.getRTypeOfSymbol(prev.getAttribute());
                        return Scopes.scopeFor(this._rosettaEcoreUtil.allFeatures(receiverType.getRType(), context));
                    }
                    EObject _eContainer_1 = ((Segment)context).eContainer();
                    if (_eContainer_1 instanceof Operation) {
                        return this.getScope(((Segment)context).eContainer(), reference);
                    }
                    return this.defaultScope(context, reference);
                }
                return this.defaultScope(context, reference);
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.ROSETTA_SYMBOL_REFERENCE__SYMBOL)) {
                InlineFunction inline;
                RType expectedType;
                _matched = true;
                if (context instanceof Operation) {
                    Attribute _output;
                    boolean _tripleNotEquals;
                    boolean _not;
                    Function function = ((Operation)context).getFunction();
                    ArrayList inputsAndOutputs = CollectionLiterals.newArrayList();
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(function.getInputs());
                    boolean bl = _not = !_isNullOrEmpty;
                    if (_not) {
                        inputsAndOutputs.addAll(function.getInputs());
                    }
                    boolean bl2 = _tripleNotEquals = (_output = function.getOutput()) != null;
                    if (_tripleNotEquals) {
                        inputsAndOutputs.add(function.getOutput());
                    }
                    return Scopes.scopeFor((Iterable)inputsAndOutputs);
                }
                Iterable implicitFeatures = this.typeProvider.findFeaturesOfImplicitVariable(context);
                RMetaAnnotatedType _expectedTypeFromContainer = this.expectedTypeProvider.getExpectedTypeFromContainer(context);
                RType _rType = null;
                if (_expectedTypeFromContainer != null) {
                    _rType = _expectedTypeFromContainer.getRType();
                }
                if ((expectedType = _rType) instanceof REnumType) {
                    Iterable _plus;
                    List<RosettaEnumValue> _allEnumValues = ((REnumType)expectedType).getAllEnumValues();
                    implicitFeatures = _plus = Iterables.concat(implicitFeatures, _allEnumValues);
                }
                if ((inline = (InlineFunction)EcoreUtil2.getContainerOfType((EObject)context, InlineFunction.class)) != null) {
                    IScope ps = this.getSymbolParentScope(context, reference, IScope.NULLSCOPE);
                    return ReversedSimpleScope.scopeFor(implicitFeatures, ps);
                }
                Function container = (Function)EcoreUtil2.getContainerOfType((EObject)context, Function.class);
                if (container != null) {
                    Predicate _function = descr -> {
                        EClass _eClass = descr.getEClass();
                        return _eClass != SimplePackage.Literals.DATA;
                    };
                    IScope ps_1 = this.filteredScope(this.getSymbolParentScope(context, reference, IScope.NULLSCOPE), (Predicate<IEObjectDescription>)_function);
                    return ReversedSimpleScope.scopeFor(implicitFeatures, ps_1);
                }
                IScope ps_2 = this.getSymbolParentScope(context, reference, this.defaultScope(context, reference));
                return ReversedSimpleScope.scopeFor(implicitFeatures, ps_2);
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_ENUM_VALUE_REFERENCE__VALUE)) {
                _matched = true;
                if (context instanceof RosettaEnumValueReference) {
                    return Scopes.scopeFor(this._rObjectFactory.buildREnumType(((RosettaEnumValueReference)context).getEnumeration()).getAllEnumValues());
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_REGULAR_ATTRIBUTE__ATTRIBUTE_REF)) {
                EObject _eContainer_1;
                RosettaType classRef;
                _matched = true;
                if (context instanceof RosettaExternalRegularAttribute && (classRef = ((RosettaExternalClass)(_eContainer_1 = ((RosettaExternalRegularAttribute)context).eContainer())).getTypeRef()) instanceof Data) {
                    Functions.Function1 _function_1 = it -> it.getEObject();
                    return Scopes.scopeFor((Iterable)Iterables.filter((Iterable)IterableExtensions.map(this._rObjectFactory.buildRDataType((Data)classRef).getAllAttributes(), (Functions.Function1)_function_1), Attribute.class));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_ENUM_VALUE__ENUM_REF)) {
                EObject _eContainer_2;
                RosettaType enumRef;
                _matched = true;
                if (context instanceof RosettaExternalEnumValue && (enumRef = ((RosettaExternalEnum)(_eContainer_2 = ((RosettaExternalEnumValue)context).eContainer())).getTypeRef()) instanceof RosettaEnumeration) {
                    return Scopes.scopeFor(this._rObjectFactory.buildREnumType((RosettaEnumeration)enumRef).getAllEnumValues());
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.ANNOTATION_REF__ATTRIBUTE)) {
                _matched = true;
                if (context instanceof AnnotationRef) {
                    Annotation annoRef = ((AnnotationRef)context).getAnnotation();
                    return Scopes.scopeFor(annoRef.getAttributes());
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)SimplePackage.Literals.FUNCTION_DISPATCH__ATTRIBUTE)) {
                _matched = true;
                if (context instanceof FunctionDispatch) {
                    return Scopes.scopeFor(this._rosettaFunctionExtensions.getInputs((Function)context));
                }
                return IScope.NULLSCOPE;
            }
            if (!_matched && Objects.equal((Object)reference, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE__SUPER_SOURCES)) {
                _matched = true;
                Predicate _function_2 = it -> {
                    EClass _eClass = it.getEClass();
                    return Objects.equal((Object)_eClass, (Object)RosettaPackage.Literals.ROSETTA_EXTERNAL_RULE_SOURCE);
                };
                return this.filteredScope(this.defaultScope(context, reference), (Predicate<IEObjectDescription>)_function_2);
            }
            if (!_matched && Objects.equal((Object)reference, (Object)ExpressionPackage.Literals.SWITCH_CASE_GUARD__SYMBOL_GUARD)) {
                _matched = true;
                if (context instanceof SwitchCaseGuard) {
                    RType argumentType = this.typeProvider.getRMetaAnnotatedType(((SwitchCaseGuard)context).getCase().getSwitchOperation().getArgument()).getRType();
                    if (argumentType instanceof REnumType) {
                        return Scopes.scopeFor(((REnumType)argumentType).getAllEnumValues());
                    }
                    if (argumentType instanceof RChoiceType) {
                        Functions.Function1 _function_3 = it -> it.getEObject();
                        return Scopes.scopeFor((Iterable)ListExtensions.map(((RChoiceType)argumentType).getAllOptions(), (Functions.Function1)_function_3));
                    }
                }
                return IScope.NULLSCOPE;
            }
            return this.defaultScope(context, reference);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                LOGGER.error("Error scoping rosetta", (Throwable)e);
                return IScope.NULLSCOPE;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        ImportNormalizer _createImportedNamespaceResolver = this.createImportedNamespaceResolver("com.rosetta.model.*", ignoreCase);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ImportNormalizer[]{_createImportedNamespaceResolver}));
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        List _xifexpression = null;
        if (context instanceof RosettaModel) {
            ArrayList imports = CollectionLiterals.newArrayList();
            Consumer<Import> _function = it -> {
                ImportNormalizer resolver = this.createImportedNamespaceResolver(it.getImportedNamespace(), it.getNamespaceAlias(), ignoreCase);
                if (resolver != null) {
                    imports.add(resolver);
                }
            };
            ((RosettaModel)context).getImports().forEach(_function);
            imports.add(this.doCreateImportNormalizer(this.getQualifiedNameConverter().toQualifiedName(((RosettaModel)context).getName()), true, ignoreCase));
            return imports;
        }
        _xifexpression = CollectionLiterals.emptyList();
        return _xifexpression;
    }

    private ImportNormalizer createImportedNamespaceResolver(String namespace, String namespaceAlias, boolean ignoreCase) {
        boolean _isEmpty = Strings.isEmpty((String)namespace);
        if (_isEmpty) {
            return null;
        }
        QualifiedName importedNamespace = this.getQualifiedNameConverter().toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.isEmpty()) {
            return null;
        }
        QualifiedName _xifexpression = null;
        _xifexpression = namespaceAlias == null ? null : this.getQualifiedNameConverter().toQualifiedName(namespaceAlias);
        QualifiedName qualifiedAlias = _xifexpression;
        boolean _xifexpression_1 = false;
        _xifexpression_1 = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase(this.getWildCard()) : importedNamespace.getLastSegment().equals(this.getWildCard());
        boolean hasWildCard = _xifexpression_1;
        if (hasWildCard) {
            boolean _lessEqualsThan;
            int _segmentCount = importedNamespace.getSegmentCount();
            boolean bl = _lessEqualsThan = _segmentCount <= 1;
            if (_lessEqualsThan) {
                return null;
            }
            return this.doCreateImportNormalizer(importedNamespace.skipLast(1), qualifiedAlias, true, ignoreCase);
        }
        return this.doCreateImportNormalizer(importedNamespace, qualifiedAlias, false, ignoreCase);
    }

    private ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, QualifiedName namespaceAlias, boolean wildcard, boolean ignoreCase) {
        if (namespaceAlias == null) {
            return this.doCreateImportNormalizer(importedNamespace, wildcard, ignoreCase);
        }
        return new AliasAwareImportNormalizer(importedNamespace, namespaceAlias, wildcard, ignoreCase);
    }

    private IScope defaultScope(EObject object, EReference reference) {
        Predicate _function = it -> {
            EClass _eClass = it.getEClass();
            return _eClass != SimplePackage.Literals.FUNCTION_DISPATCH;
        };
        return this.filteredScope(super.getScope(object, reference), (Predicate<IEObjectDescription>)_function);
    }

    private IScope getSymbolParentScope(EObject object, EReference reference, IScope outer) {
        Predicate _function;
        boolean _tripleEquals;
        IScope _xblockexpression = null;
        EObject _eContainer = object.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            return this.defaultScope(object, reference);
        }
        IScope parentScope = this.getSymbolParentScope(object.eContainer(), reference, outer);
        IScope _switchResult = null;
        boolean _matched = false;
        if (object instanceof InlineFunction) {
            _matched = true;
            return Scopes.scopeFor(((InlineFunction)object).getParameters(), (IScope)parentScope);
        }
        if (!_matched && object instanceof Function) {
            _matched = true;
            ArrayList features = CollectionLiterals.newArrayList();
            features.addAll(this._rosettaFunctionExtensions.getInputs((Function)object));
            Attribute out = this._rosettaFunctionExtensions.getOutput((Function)object);
            if (out != null) {
                features.add(this._rosettaFunctionExtensions.getOutput((Function)object));
            }
            features.addAll(((Function)object).getShortcuts());
            return Scopes.scopeFor((Iterable)features, (IScope)parentScope);
        }
        if (!_matched && object instanceof ShortcutDeclaration) {
            _matched = true;
            _function = descr -> {
                String _name;
                String _string = descr.getQualifiedName().toString();
                return !Objects.equal((Object)_string, (Object)(_name = ((ShortcutDeclaration)object).getName()));
            };
            _switchResult = this.filteredScope(parentScope, (Predicate<IEObjectDescription>)_function);
        }
        if (!_matched && object instanceof RosettaTypeAlias) {
            _matched = true;
            _switchResult = Scopes.scopeFor((Iterable)((RosettaTypeAlias)object).getParameters(), (IScope)parentScope);
        }
        if (!_matched && object instanceof Condition) {
            _matched = true;
            _function = descr -> ((Condition)object).isPostCondition() || descr.getEObjectOrProxy().eContainingFeature() != SimplePackage.Literals.FUNCTION__OUTPUT;
            _switchResult = this.filteredScope(parentScope, (Predicate<IEObjectDescription>)_function);
        }
        if (!_matched && object instanceof RosettaModel) {
            _matched = true;
            _function = descr -> Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EClass[]{SimplePackage.Literals.DATA, RosettaPackage.Literals.ROSETTA_ENUMERATION, SimplePackage.Literals.FUNCTION, RosettaPackage.Literals.ROSETTA_EXTERNAL_FUNCTION, RosettaPackage.Literals.ROSETTA_RULE})).contains(descr.getEClass());
            _switchResult = this.filteredScope(this.defaultScope(object, reference), (Predicate<IEObjectDescription>)_function);
        }
        if (!_matched) {
            _switchResult = parentScope;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private IScope filteredScope(IScope scope, Predicate<IEObjectDescription> filter) {
        return new FilteringScope(scope, filter);
    }

    private IScope createExtendedFeatureScope(EObject receiver, RMetaAnnotatedType metaReceiverType) {
        RType receiverType = metaReceiverType.getRType();
        if (!(!(receiverType instanceof REnumType) || receiver instanceof RosettaSymbolReference && ((RosettaSymbolReference)receiver).getSymbol() instanceof RosettaEnumeration)) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(this._rosettaEcoreUtil.allFeatures(metaReceiverType, receiver));
    }

    private IScope createDeepFeatureScope(RType receiverType) {
        RType _xifexpression = null;
        _xifexpression = receiverType instanceof RChoiceType ? ((RChoiceType)receiverType).asRDataType() : receiverType;
        RType t = _xifexpression;
        if (t instanceof RDataType) {
            Functions.Function1 _function = it -> {
                Attribute _eObject = it.getEObject();
                return _eObject != null;
            };
            Functions.Function1 _function_1 = it -> it.getEObject();
            return Scopes.scopeFor((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this._deepFeatureCallUtil.findDeepFeatures((RDataType)t), (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
        return IScope.NULLSCOPE;
    }
}

