/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.resource;

import com.google.inject.Singleton;
import com.regnosys.rosetta.resource.AttributeDescription;
import com.regnosys.rosetta.resource.RosettaModelDescription;
import com.regnosys.rosetta.resource.RuleDescription;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class RosettaResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (eObject instanceof RosettaModel) {
            RosettaModel model = (RosettaModel)eObject;
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            acceptor.accept((Object)new RosettaModelDescription(qualifiedName, model));
            return true;
        }
        if (eObject instanceof Attribute) {
            Attribute attr = (Attribute)eObject;
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)attr);
            String typeCall = this.serialize(attr.getTypeCall());
            String cardinality = this.serialize(attr.getCard());
            acceptor.accept((Object)new AttributeDescription(qualifiedName, attr, typeCall, cardinality));
            return false;
        }
        if (eObject instanceof RosettaRule) {
            RosettaRule rule = (RosettaRule)eObject;
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)rule);
            String input = this.serialize(rule.getInput());
            String expression = this.serialize(rule.getExpression());
            acceptor.accept((Object)new RuleDescription(qualifiedName, rule, input, expression));
            return false;
        }
        return super.createEObjectDescriptions(eObject, acceptor);
    }

    private String serialize(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node != null) {
            return node.getText();
        }
        return null;
    }
}

