/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.interpreter;

import com.regnosys.rosetta.interpreter.RosettaInterpreterException;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RosettaInterpreterContext {
    private final Map<String, RosettaValue> variables;

    private RosettaInterpreterContext(Map<String, RosettaValue> variables) {
        this.variables = variables;
    }

    public RosettaInterpreterContext() {
        this(Collections.emptyMap());
    }

    public static RosettaInterpreterContext ofSymbolMap(Map<RosettaSymbol, RosettaValue> variables) {
        return new RosettaInterpreterContext(variables.entrySet().stream().collect(Collectors.toMap(e -> ((RosettaSymbol)e.getKey()).getName(), Map.Entry::getValue)));
    }

    public static RosettaInterpreterContext of(Map<String, RosettaValue> variables) {
        return new RosettaInterpreterContext(new HashMap<String, RosettaValue>(variables));
    }

    public RosettaValue getVariableValue(RosettaSymbol symbol) {
        return this.getVariableValue(symbol.getName());
    }

    public RosettaValue getVariableValue(String symbol) {
        RosettaValue result = this.variables.get(symbol);
        if (result == null) {
            throw new RosettaInterpreterException("No value defined for variable `" + symbol + "`.");
        }
        return result;
    }

    public void setVariableValue(RosettaSymbol symbol, RosettaValue value) {
        this.setVariableValue(symbol.getName(), value);
    }

    public void setVariableValue(String symbol, RosettaValue value) {
        if (this.variables.put(symbol, value) != null) {
            throw new RosettaInterpreterException("There already is a value defined for variable `" + symbol + "`.");
        }
    }

    public String toString() {
        return "{" + this.variables.entrySet().stream().map(e -> (String)e.getKey() + " -> " + e.getValue()).collect(Collectors.joining(", ")) + "}";
    }
}

