/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.util;

import com.google.common.html.HtmlEscapers;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaSegmentRef;
import com.regnosys.rosetta.rosetta.simple.References;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class ModelGeneratorUtil {
    public static CharSequence javadoc(RosettaNamed named) {
        StringConcatenation _builder = new StringConcatenation();
        String _javadoc = ModelGeneratorUtil.javadoc(named, null);
        _builder.append(_javadoc);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private static String javadoc(RosettaNamed named, String version) {
        String _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = named instanceof RosettaDefinable ? ((RosettaDefinable)((Object)named)).getDefinition() : "";
        String definition = _xifexpression;
        EList<RosettaDocReference> _xifexpression_1 = null;
        _xifexpression_1 = named instanceof References ? ((References)((Object)named)).getReferences() : CollectionLiterals.emptyList();
        EList<RosettaDocReference> docRef = _xifexpression_1;
        _xblockexpression = ModelGeneratorUtil.javadoc(definition, docRef, version);
        return _xblockexpression;
    }

    public static String javadoc(String definition, List<RosettaDocReference> docRef, String version) {
        String _xifexpression = null;
        if (definition == null && docRef.isEmpty() && version == null) {
            _xifexpression = null;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            CharSequence _javadocDefinition = ModelGeneratorUtil.javadocDefinition(definition);
            _builder.append((Object)_javadocDefinition);
            _builder.newLineIfNotEmpty();
            CharSequence _javadocVersion = ModelGeneratorUtil.javadocVersion(version);
            _builder.append((Object)_javadocVersion);
            _builder.newLineIfNotEmpty();
            CharSequence _javadocDocRef = ModelGeneratorUtil.javadocDocRef(docRef);
            _builder.append((Object)_javadocDocRef);
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    public static CharSequence emptyJavadocWithVersion(String version) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @version ");
        _builder.append(version, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence escape(String definition) {
        StringConcatenation _builder = new StringConcatenation();
        if (definition != null && !definition.isEmpty()) {
            String _escape = HtmlEscapers.htmlEscaper().escape(definition);
            _builder.append(_escape);
        }
        return _builder;
    }

    private static CharSequence javadocDefinition(String definition) {
        StringConcatenation _builder = new StringConcatenation();
        if (definition != null && !definition.isEmpty()) {
            _builder.append(" * ");
            String _escape = HtmlEscapers.htmlEscaper().escape(definition);
            _builder.append(_escape);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private static CharSequence javadocVersion(String version) {
        StringConcatenation _builder = new StringConcatenation();
        if (version != null && !version.isEmpty()) {
            _builder.append(" * @version ");
            _builder.append(version);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private static CharSequence javadocDocRef(List<RosettaDocReference> references) {
        StringConcatenation _builder = new StringConcatenation();
        if (references != null && !references.isEmpty()) {
            for (RosettaDocReference reference : references) {
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Body ");
                String _name = reference.getDocReference().getBody().getName();
                _builder.append(_name, " ");
                _builder.newLineIfNotEmpty();
                EList<RosettaCorpus> _corpusList = reference.getDocReference().getCorpusList();
                for (RosettaCorpus mandate : _corpusList) {
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    _builder.append(" * Corpus ");
                    String _corpusType = mandate.getCorpusType();
                    _builder.append(_corpusType);
                    _builder.append(" ");
                    String _name_1 = mandate.getName();
                    _builder.append(_name_1);
                    _builder.append(" ");
                    String _displayName = mandate.getDisplayName();
                    boolean bl = _tripleNotEquals = _displayName != null;
                    if (_tripleNotEquals) {
                        String _escape = HtmlEscapers.htmlEscaper().escape(mandate.getDisplayName());
                        _builder.append(_escape);
                    }
                    _builder.append(" ");
                    String _definition = mandate.getDefinition();
                    boolean bl2 = _tripleNotEquals_1 = _definition != null;
                    if (_tripleNotEquals_1) {
                        _builder.append("\"");
                        String _escape_1 = HtmlEscapers.htmlEscaper().escape(mandate.getDefinition());
                        _builder.append(_escape_1);
                        _builder.append("\"");
                    }
                    _builder.append(" ");
                }
                _builder.newLineIfNotEmpty();
                EList<RosettaSegmentRef> _segments = reference.getDocReference().getSegments();
                for (RosettaSegmentRef segment : _segments) {
                    _builder.append(" * ");
                    String _name_2 = segment.getSegment().getName();
                    _builder.append(_name_2);
                    _builder.append(" \"");
                    String _escape_2 = HtmlEscapers.htmlEscaper().escape(segment.getSegmentRef());
                    _builder.append(_escape_2);
                    _builder.append("\"");
                }
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Provision ");
                String _provision = reference.getProvision();
                _builder.append(_provision, " ");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
            }
        }
        return _builder;
    }
}

