/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RJavaEnum;
import com.regnosys.rosetta.generator.java.types.RJavaFieldWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.RJavaReferenceWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaWithMetaValue;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.regnosys.rosetta.utils.RosettaTypeSwitch;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.lib.reports.Tabulator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import com.rosetta.util.types.generated.GeneratedJavaClassService;
import com.rosetta.util.types.generated.GeneratedJavaGenericTypeDeclaration;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;

public class JavaTypeTranslator
extends RosettaTypeSwitch<JavaType, Void> {
    @Inject
    private RosettaJavaPackages packages;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private GeneratedJavaClassService generatedJavaClassService;
    @Inject
    private JavaTypeUtil typeUtil;
    @Inject
    private ModelIdProvider modelIdProvider;

    @Inject
    public JavaTypeTranslator(RBuiltinTypeService builtins) {
        super(builtins);
    }

    @Deprecated
    public boolean isRosettaModelObject(RAttribute attr) {
        RMetaAnnotatedType rMetaAnnotatedType = attr.getRMetaAnnotatedType();
        return this.isValueRosettaModelObject(attr) || rMetaAnnotatedType.hasMeta();
    }

    @Deprecated
    public boolean isValueRosettaModelObject(RAttribute attr) {
        RType t = attr.getRMetaAnnotatedType().getRType();
        return t instanceof RDataType || t instanceof RChoiceType;
    }

    public boolean isRosettaModelObject(JavaType type) {
        return this.typeUtil.getItemType(type).isSubtypeOf(this.typeUtil.ROSETTA_MODEL_OBJECT);
    }

    public boolean isValueRosettaModelObject(JavaType type) {
        JavaType itemType = this.typeUtil.getItemType(type);
        if (itemType instanceof RJavaWithMetaValue) {
            return this.isValueRosettaModelObject((RJavaWithMetaValue)itemType);
        }
        return itemType.isSubtypeOf(this.typeUtil.ROSETTA_MODEL_OBJECT);
    }

    public boolean isValueRosettaModelObject(RJavaWithMetaValue t) {
        return t.getValueType().isSubtypeOf(this.typeUtil.ROSETTA_MODEL_OBJECT);
    }

    public JavaParameterizedType<List<?>> toPolymorphicList(JavaReferenceType t) {
        return this.typeUtil.wrapExtends(this.typeUtil.LIST, (JavaType)t);
    }

    public JavaClass<? extends RosettaFunction> toFunctionJavaClass(RFunction func) {
        switch (func.getOrigin()) {
            case FUNCTION: {
                return this.generatedJavaClassService.toJavaFunction(func.getSymbolId());
            }
            case REPORT: {
                return this.generatedJavaClassService.toJavaReportFunction(func.getReportId());
            }
            case RULE: {
                return this.generatedJavaClassService.toJavaRule(func.getSymbolId());
            }
        }
        throw new IllegalStateException("Unknown origin of RFunction: " + func.getOrigin());
    }

    public JavaClass<RosettaFunction> toFunctionJavaClass(Function func) {
        return this.generatedJavaClassService.toJavaFunction(this.modelIdProvider.getSymbolId(func));
    }

    public JavaClass<RosettaFunction> toFunctionJavaClass(RosettaExternalFunction func) {
        return new GeneratedJavaClass(this.packages.defaultLibFunctions(), func.getName(), RosettaFunction.class);
    }

    public JavaClass<ReportFunction<?, ?>> toReportFunctionJavaClass(RosettaReport report) {
        return this.generatedJavaClassService.toJavaReportFunction(this.modelIdProvider.getReportId(report));
    }

    public JavaClass<Tabulator<?>> toReportTabulatorJavaClass(RosettaReport report) {
        return this.generatedJavaClassService.toJavaReportTabulator(this.modelIdProvider.getReportId(report));
    }

    public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data type, Optional<RosettaExternalRuleSource> ruleSource) {
        ModelSymbolId typeId = this.modelIdProvider.getSymbolId(type);
        Optional containingRuleSource = ruleSource.flatMap(rs -> this.findContainingSuperRuleSource(type, (RosettaExternalRuleSource)rs));
        if (containingRuleSource.isEmpty()) {
            DottedPath packageName = typeId.getNamespace().child("reports");
            String simpleName = typeId.getName() + "TypeTabulator";
            return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
        }
        ModelSymbolId sourceId = this.modelIdProvider.getSymbolId((RosettaExternalRuleSource)containingRuleSource.get());
        DottedPath packageName = sourceId.getNamespace().child("reports");
        String simpleName = typeId.getName() + sourceId.getName() + "TypeTabulator";
        return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
    }

    private Optional<RosettaExternalRuleSource> findContainingSuperRuleSource(Data type, RosettaExternalRuleSource ruleSource) {
        if (ruleSource.getExternalClasses().stream().filter(c -> c.getData().equals(type)).findAny().isPresent()) {
            return Optional.of(ruleSource);
        }
        return Optional.ofNullable(ruleSource.getSuperRuleSource()).flatMap(s -> this.findContainingSuperRuleSource(type, (RosettaExternalRuleSource)s));
    }

    @Deprecated
    public JavaClass<Tabulator<?>> toProjectionTabulatorJavaClass(Function projection) {
        return this.generatedJavaClassService.toJavaProjectionTabulator(this.modelIdProvider.getSymbolId(projection));
    }

    @Deprecated
    public JavaClass<Tabulator<?>> toProjectionTabulatorJavaClass(Data type, Function projection) {
        ModelSymbolId typeId = this.modelIdProvider.getSymbolId(type);
        ModelSymbolId projectionId = this.modelIdProvider.getSymbolId(projection);
        DottedPath packageName = projectionId.getNamespace().child("projections");
        String simpleName = typeId.getName() + projection.getName() + "TypeTabulator";
        return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
    }

    public JavaClass<Tabulator<?>> toTabulatorJavaClass(Function function) {
        return this.generatedJavaClassService.toJavaFunctionTabulator(this.modelIdProvider.getSymbolId(function));
    }

    public JavaClass<Tabulator<?>> toTabulatorJavaClass(Data type, Function function) {
        ModelSymbolId typeId = this.modelIdProvider.getSymbolId(type);
        ModelSymbolId projectionId = this.modelIdProvider.getSymbolId(function);
        DottedPath packageName = projectionId.getNamespace().child("tabulator");
        String simpleName = typeId.getName() + function.getName() + "TypeTabulator";
        return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
    }

    public JavaClass<Tabulator<?>> toTabulatorJavaClass(RDataType type) {
        ModelSymbolId typeId = type.getSymbolId();
        DottedPath packageName = typeId.getNamespace().child("tabulator");
        String simpleName = typeId.getName() + "TypeTabulator";
        return new GeneratedJavaClass(packageName, simpleName, new TypeReference<Tabulator<?>>(){});
    }

    public JavaClass<?> toDeepPathUtilJavaClass(RDataType choiceType) {
        ModelSymbolId typeId = this.modelIdProvider.getSymbolId(choiceType.getEObject());
        DottedPath packageName = typeId.getNamespace().child("util");
        String simpleName = typeId.getName() + "DeepPathUtil";
        return new GeneratedJavaClass(packageName, simpleName, Object.class);
    }

    public JavaClass<?> toItemJavaType(RAttribute attr) {
        return this.toJavaReferenceType(attr.getRMetaAnnotatedType().getRType());
    }

    public JavaClass<?> toMetaItemJavaType(RAttribute attr) {
        return this.toJavaReferenceType(attr.getRMetaAnnotatedType());
    }

    public JavaClass<?> toForcedMetaItemJavaType(RAttribute attr) {
        JavaClass<?> metaItemJavaType = this.toMetaItemJavaType(attr);
        if (!attr.getRMetaAnnotatedType().hasMeta()) {
            RType rType = this.typeSystem.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
            DottedPath namespace = this.metaField(rType.getNamespace());
            return new RJavaFieldWithMeta((JavaReferenceType)metaItemJavaType, namespace, this.typeUtil);
        }
        return metaItemJavaType;
    }

    public JavaClass<?> toMetaJavaType(RAttribute attr) {
        JavaClass<?> itemType = this.toMetaItemJavaType(attr);
        if (attr.isMulti()) {
            if (this.isRosettaModelObject(attr)) {
                return this.toPolymorphicList((JavaReferenceType)itemType);
            }
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)itemType);
        }
        return itemType;
    }

    public JavaClass<?> toJavaType(RAttribute attr) {
        JavaClass<?> itemType = this.toItemJavaType(attr);
        if (attr.isMulti()) {
            if (this.isRosettaModelObject(attr)) {
                return this.toPolymorphicList((JavaReferenceType)itemType);
            }
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)itemType);
        }
        return itemType;
    }

    public JavaClass<?> operationToReferenceWithMetaType(Operation op) {
        Attribute attr;
        if (op.getPath() == null) {
            attr = (Attribute)op.getAssignRoot();
        } else {
            EList<Segment> segments = op.pathAsSegmentList();
            attr = ((Segment)segments.get(segments.size() - 1)).getAttribute();
        }
        return this.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol(attr));
    }

    public JavaReferenceType operationToJavaType(ROperation op) {
        RAttribute attr;
        if (op.getPathTail().isEmpty()) {
            attr = (RAttribute)op.getPathHead();
        } else {
            List<RAttribute> segments = op.getPathTail();
            attr = segments.get(segments.size() - 1);
        }
        return this.toJavaType(attr);
    }

    public JavaClass<?> operationToReferenceWithMetaType(ROperation op) {
        RAttribute attr;
        if (op.getPathTail().isEmpty()) {
            attr = (RAttribute)op.getPathHead();
        } else {
            List<RAttribute> segments = op.getPathTail();
            attr = segments.get(segments.size() - 1);
        }
        return this.toJavaReferenceType(attr.getRMetaAnnotatedType());
    }

    private String getTypeDebugInfo(RType type) {
        return type.toString() + " (" + type.getClass().getSimpleName() + ")";
    }

    private String getTypeDebugInfo(RMetaAnnotatedType type) {
        return type.toString() + " (" + type.getClass().getSimpleName() + ")";
    }

    public JavaClass<?> toJavaReferenceType(RMetaAnnotatedType type) {
        JavaType jt = this.toJavaType(type);
        if (jt instanceof JavaPrimitiveType) {
            return ((JavaPrimitiveType)jt).toReferenceType();
        }
        if (jt instanceof JavaClass) {
            return (JavaClass)jt;
        }
        throw new UnsupportedOperationException("Cannot convert type " + this.getTypeDebugInfo(type) + " to a Java reference type.");
    }

    public JavaClass<?> toJavaReferenceType(RType type) {
        JavaType jt = this.toJavaType(type);
        if (jt instanceof JavaPrimitiveType) {
            return ((JavaPrimitiveType)jt).toReferenceType();
        }
        if (jt instanceof JavaClass) {
            return (JavaClass)jt;
        }
        throw new UnsupportedOperationException("Cannot convert type " + this.getTypeDebugInfo(type) + " to a Java reference type.");
    }

    public JavaPojoInterface toJavaReferenceType(RDataType type) {
        return this.toJavaType(type);
    }

    public RJavaEnum toJavaReferenceType(REnumType type) {
        return this.toJavaType(type);
    }

    public JavaClass<?> toJavaReferenceType(Optional<RType> type) {
        if (type.isPresent()) {
            return this.toJavaReferenceType(type.orElseThrow());
        }
        return this.typeUtil.OBJECT;
    }

    public JavaType toJavaType(RMetaAnnotatedType type) {
        JavaClass<?> javaType = this.toJavaReferenceType(type.getRType());
        if (type.hasMeta()) {
            RType rType = this.typeSystem.stripFromTypeAliases(type.getRType());
            DottedPath namespace = this.metaField(rType.getNamespace());
            return this.hasReferenceOrAddressMetadata(type) ? new RJavaReferenceWithMeta((JavaReferenceType)javaType, namespace, this.typeUtil) : new RJavaFieldWithMeta((JavaReferenceType)javaType, namespace, this.typeUtil);
        }
        return javaType;
    }

    private JavaType toJavaType(RType type) {
        return (JavaType)this.doSwitch(type, null);
    }

    public JavaPojoInterface toJavaType(RDataType type) {
        return this.caseDataType(type, null);
    }

    public RJavaEnum toJavaType(REnumType type) {
        return this.caseEnumType(type, null);
    }

    public JavaType toJavaType(Optional<RType> type) {
        return (JavaType)type.map(t -> this.toJavaType((RType)t)).orElse((JavaType)this.typeUtil.OBJECT);
    }

    public JavaClass<?> toPolymorphicListOrSingleJavaType(RMetaAnnotatedType type, boolean isMany) {
        if (isMany) {
            return this.toPolymorphicList((JavaReferenceType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toPolymorphicListOrSingleJavaType(RType type, boolean isMany) {
        if (isMany) {
            return this.toPolymorphicList((JavaReferenceType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toListOrSingleJavaType(RMetaAnnotatedType type, boolean isMany) {
        if (isMany) {
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toListOrSingleJavaType(RType type, boolean isMany) {
        if (isMany) {
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toImplType(JavaClass<?> type) {
        return new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "Impl", Object.class);
    }

    public JavaClass<?> toBuilderType(JavaClass<?> type) {
        if (type.equals((Object)JavaClass.from(RosettaModelObject.class))) {
            return JavaClass.from(RosettaModelObjectBuilder.class);
        }
        GeneratedJavaClass base = new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "Builder", Object.class);
        if (type instanceof JavaParameterizedType) {
            return JavaParameterizedType.from((JavaGenericTypeDeclaration)new GeneratedJavaGenericTypeDeclaration(base, new String[]{"T"}), (List)((JavaParameterizedType)type).getArguments());
        }
        return base;
    }

    public JavaClass<?> toBuilderImplType(JavaClass<?> type) {
        return new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "BuilderImpl", Object.class);
    }

    public JavaClass<?> toValidatorClass(JavaPojoInterface t) {
        return new GeneratedJavaClass(this.validation(t.getPackageName()), t.getSimpleName() + "Validator", Object.class);
    }

    public JavaClass<?> toTypeFormatValidatorClass(JavaPojoInterface t) {
        return new GeneratedJavaClass(this.validation(t.getPackageName()), t.getSimpleName() + "TypeFormatValidator", Object.class);
    }

    public JavaClass<?> toOnlyExistsValidatorClass(JavaPojoInterface t) {
        return new GeneratedJavaClass(this.existsValidation(t.getPackageName()), t.getSimpleName() + "OnlyExistsValidator", Object.class);
    }

    private DottedPath metaField(DottedPath p) {
        return p.child("metafields");
    }

    private DottedPath validation(DottedPath p) {
        return p.child("validation");
    }

    public DottedPath existsValidation(DottedPath p) {
        return this.validation(p).child("exists");
    }

    @Override
    protected JavaPojoInterface caseDataType(RDataType type, Void context) {
        return new RJavaPojoInterface(type, this.typeSystem, this, this.typeUtil);
    }

    @Override
    protected JavaPojoInterface caseChoiceType(RChoiceType type, Void context) {
        return this.caseDataType(type.asRDataType(), context);
    }

    @Override
    protected RJavaEnum caseEnumType(REnumType type, Void context) {
        return new RJavaEnum(type);
    }

    @Override
    protected JavaType caseAliasType(RAliasType type, Void context) {
        return this.toJavaType(type.getRefersTo());
    }

    @Override
    protected JavaType caseNumberType(RNumberType type, Void context) {
        if (!type.isInteger()) {
            return JavaClass.from(BigDecimal.class);
        }
        int digits = type.getDigits().orElse(9);
        if (digits <= 9) {
            return JavaPrimitiveType.INT;
        }
        if (digits <= 18) {
            return JavaPrimitiveType.LONG;
        }
        return JavaClass.from(BigInteger.class);
    }

    @Override
    protected JavaClass<String> caseStringType(RStringType type, Void context) {
        return this.typeUtil.STRING;
    }

    @Override
    protected JavaPrimitiveType caseBooleanType(RBasicType type, Void context) {
        return JavaPrimitiveType.BOOLEAN;
    }

    @Override
    protected JavaClass<LocalTime> caseTimeType(RBasicType type, Void context) {
        return this.typeUtil.LOCAL_TIME;
    }

    @Override
    protected JavaClass<Void> caseNothingType(RBasicType type, Void context) {
        return this.typeUtil.VOID;
    }

    @Override
    protected JavaClass<Object> caseAnyType(RBasicType type, Void context) {
        return this.typeUtil.OBJECT;
    }

    @Override
    protected JavaClass<Date> caseDateType(RDateType type, Void context) {
        return this.typeUtil.DATE;
    }

    @Override
    protected JavaClass<LocalDateTime> caseDateTimeType(RDateTimeType type, Void context) {
        return this.typeUtil.LOCAL_DATE_TIME;
    }

    @Override
    protected JavaClass<ZonedDateTime> caseZonedDateTimeType(RZonedDateTimeType type, Void context) {
        return this.typeUtil.ZONED_DATE_TIME;
    }

    private boolean hasReferenceOrAddressMetadata(RMetaAnnotatedType rMetaAnnotatedType) {
        return rMetaAnnotatedType.getMetaAttributes().stream().anyMatch(a -> a.getName().equals("reference") || a.getName().equals("address"));
    }
}

