/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.util.types.JavaType;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class JavaPojoProperty {
    private final String name;
    private final String runeName;
    private final String compatibilityName;
    private final JavaType type;
    private final String javadoc;
    private final JavaPojoProperty parentProperty;
    private final AttributeMeta meta;
    private final boolean hasLocation;

    public JavaPojoProperty(String name, String runeName, String compatibilityName, JavaType type, String javadoc, AttributeMeta meta, boolean hasLocation) {
        this(name, runeName, compatibilityName, type, javadoc, meta, hasLocation, null);
    }

    private JavaPojoProperty(String name, String runeName, String compatibilityName, JavaType type, String javadoc, AttributeMeta meta, boolean hasLocation, JavaPojoProperty parentProperty) {
        this.name = name;
        this.runeName = runeName;
        this.compatibilityName = compatibilityName;
        this.type = type;
        this.javadoc = javadoc;
        this.meta = meta;
        this.hasLocation = hasLocation;
        this.parentProperty = parentProperty;
    }

    public JavaPojoProperty specialize(String compatibilityName, JavaType newType, String newJavadoc, AttributeMeta newMeta, boolean newHasLocation) {
        return new JavaPojoProperty(this.name, this.runeName, compatibilityName, newType, newJavadoc, newMeta, newHasLocation, this);
    }

    public boolean isCompatibleWithParent() {
        return this.parentProperty == null || this.type.isSubtypeOf(this.parentProperty.type);
    }

    public String getName() {
        return this.name;
    }

    public String getRuneName() {
        return this.runeName;
    }

    public String getGetterName() {
        return "get" + StringUtils.capitalize((String)this.compatibilityName);
    }

    public String getGetOrCreateName() {
        return "getOrCreate" + StringUtils.capitalize((String)this.compatibilityName);
    }

    public JavaType getType() {
        return this.type;
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    public AttributeMeta getMeta() {
        return this.meta;
    }

    public boolean hasLocation() {
        return this.hasLocation;
    }

    public JavaPojoProperty getParentProperty() {
        return this.parentProperty;
    }

    public JavaExpression applyGetter(final JavaExpression expr) {
        return JavaExpression.from(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)expr);
                target.append((Object)Character.valueOf('.'));
                target.append((Object)JavaPojoProperty.this.getGetterName());
                target.append((Object)"()");
            }
        }, this.type);
    }

    public String toString() {
        return JavaPojoProperty.class.getSimpleName() + "[" + this.type.getSimpleName() + " " + this.getGetterName() + "()]";
    }

    public int hashCode() {
        return Objects.hash(this.compatibilityName, this.hasLocation, this.javadoc, this.meta, this.name, this.runeName, this.parentProperty, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaPojoProperty other = (JavaPojoProperty)obj;
        return Objects.equals(this.compatibilityName, other.compatibilityName) && this.hasLocation == other.hasLocation && Objects.equals(this.javadoc, other.javadoc) && this.meta == other.meta && Objects.equals(this.name, other.name) && Objects.equals(this.runeName, other.runeName) && Objects.equals(this.parentProperty, other.parentProperty) && Objects.equals(this.type, other.type);
    }
}

