/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ValidatorsGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    @Extension
    private RBuiltinTypeService _rBuiltinTypeService;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, RDataType type, String version) {
        JavaPojoInterface javaType = this._javaTypeTranslator.toJavaReferenceType(type);
        Collection<RAttribute> attrs = type.getAllAttributes();
        String _withForwardSlashes = this._javaTypeTranslator.toValidatorClass(javaType).getCanonicalName().withForwardSlashes();
        String _plus = _withForwardSlashes + ".java";
        fsa.generateFile(_plus, (CharSequence)this.generateClass(root, javaType, attrs, version));
        String _withForwardSlashes_1 = this._javaTypeTranslator.toTypeFormatValidatorClass(javaType).getCanonicalName().withForwardSlashes();
        String _plus_1 = _withForwardSlashes_1 + ".java";
        fsa.generateFile(_plus_1, (CharSequence)this.generateTypeFormatValidator(root, javaType, attrs, version));
        String _withForwardSlashes_2 = this._javaTypeTranslator.toOnlyExistsValidatorClass(javaType).getCanonicalName().withForwardSlashes();
        String _plus_2 = _withForwardSlashes_2 + ".java";
        fsa.generateFile(_plus_2, (CharSequence)this.generateOnlyExistsValidator(root, javaType, attrs, version));
    }

    private String generateClass(RosettaJavaPackages.RootPackage root, JavaPojoInterface javaType, Iterable<RAttribute> attributes, String version) {
        String _xblockexpression = null;
        DottedPath _typeValidation = root.typeValidation();
        JavaScope scope = new JavaScope(_typeValidation);
        _xblockexpression = this._importManagerExtension.buildClass(root.typeValidation(), this.classBody(javaType, version, attributes), scope);
        return _xblockexpression;
    }

    private String generateTypeFormatValidator(RosettaJavaPackages.RootPackage root, JavaPojoInterface javaType, Iterable<RAttribute> attributes, String version) {
        String _xblockexpression = null;
        DottedPath _typeValidation = root.typeValidation();
        JavaScope scope = new JavaScope(_typeValidation);
        _xblockexpression = this._importManagerExtension.buildClass(root.typeValidation(), this.typeFormatClassBody(javaType, version, attributes), scope);
        return _xblockexpression;
    }

    private String generateOnlyExistsValidator(RosettaJavaPackages.RootPackage root, JavaPojoInterface javaType, Iterable<RAttribute> attributes, String version) {
        String _xblockexpression = null;
        DottedPath _existsValidation = root.existsValidation();
        JavaScope scope = new JavaScope(_existsValidation);
        _xblockexpression = this._importManagerExtension.buildClass(root.existsValidation(), this.onlyExistsClassBody(javaType, version, attributes), scope);
        return _xblockexpression;
    }

    private StringConcatenationClient classBody(final JavaPojoInterface javaType, String version, final Iterable<RAttribute> attributes) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                JavaClass<?> _validatorClass = ValidatorsGenerator.this._javaTypeTranslator.toValidatorClass(javaType);
                _builder.append(_validatorClass);
                _builder.append((Object)" implements ");
                _builder.append(Validator.class);
                _builder.append((Object)"<");
                _builder.append((Object)javaType);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ComparisonResult.class, "\t");
                _builder.append((Object)"> getComparisonResults(");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Lists.class, "\t\t");
                _builder.append((Object)".<");
                _builder.append(ComparisonResult.class, "\t\t");
                _builder.append((Object)">newArrayList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> ValidatorsGenerator.this.checkCardinality(javaType, (RAttribute)it);
                Functions.Function1 _function_1 = it -> it != null;
                Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)attributes, (Functions.Function1)_function), (Functions.Function1)_function_1);
                boolean _hasElements = false;
                for (StringConcatenationClient attrCheck : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t\t\t");
                    }
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)attrCheck, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> validate(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"String error = getComparisonResults(o)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".stream()");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".filter(res -> !res.get())");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".map(res -> res.getError())");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".collect(");
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "joining");
                _builder.append((Object)_method, "\t\t\t");
                _builder.append((Object)"(\"; \"));");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!");
                Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                _builder.append((Object)_method_1, "\t\t");
                _builder.append((Object)"(error)) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                Method _method_2 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_2, "\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t");
                _builder.append((Object)"\", path, \"\", error);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                Method _method_3 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method_3, "\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_3 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return getComparisonResults(o)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".stream()");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".map(res -> {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"if (!");
                Method _method_4 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                _builder.append((Object)_method_4, "\t\t\t\t");
                _builder.append((Object)"(res.getError())) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_5 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_5, "\t\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_4 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_4, "\t\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_5 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_5, "\t\t\t\t\t");
                _builder.append((Object)"\", path, \"\", res.getError());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_6 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method_6, "\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_6 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_6, "\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_7 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_7, "\t\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"})");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".collect(");
                Method _method_7 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
                _builder.append((Object)_method_7, "\t\t\t");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient typeFormatClassBody(final JavaPojoInterface javaType, String version, final Iterable<RAttribute> attributes) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                JavaClass<?> _typeFormatValidatorClass = ValidatorsGenerator.this._javaTypeTranslator.toTypeFormatValidatorClass(javaType);
                _builder.append(_typeFormatValidatorClass);
                _builder.append((Object)" implements ");
                _builder.append(Validator.class);
                _builder.append((Object)"<");
                _builder.append((Object)javaType);
                _builder.append((Object)"> {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ComparisonResult.class, "\t");
                _builder.append((Object)"> getComparisonResults(");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Lists.class, "\t\t");
                _builder.append((Object)".<");
                _builder.append(ComparisonResult.class, "\t\t");
                _builder.append((Object)">newArrayList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> ValidatorsGenerator.this.checkTypeFormat(javaType, (RAttribute)it);
                Functions.Function1 _function_1 = it -> it != null;
                Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)attributes, (Functions.Function1)_function), (Functions.Function1)_function_1);
                boolean _hasElements = false;
                for (StringConcatenationClient attrCheck : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t\t\t");
                    }
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)attrCheck, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> validate(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"String error = getComparisonResults(o)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".stream()");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".filter(res -> !res.get())");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".map(res -> res.getError())");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".collect(");
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "joining");
                _builder.append((Object)_method, "\t\t\t");
                _builder.append((Object)"(\"; \"));");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!");
                Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                _builder.append((Object)_method_1, "\t\t");
                _builder.append((Object)"(error)) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                Method _method_2 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_2, "\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
                _builder.append((Object)".TYPE_FORMAT, \"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t");
                _builder.append((Object)"\", path, \"\", error);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                Method _method_3 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method_3, "\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t");
                _builder.append((Object)".TYPE_FORMAT, \"");
                String _rosettaName_3 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return getComparisonResults(o)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".stream()");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".map(res -> {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"if (!");
                Method _method_4 = ValidatorsGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                _builder.append((Object)_method_4, "\t\t\t\t");
                _builder.append((Object)"(res.getError())) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_5 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_5, "\t\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_4 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_4, "\t\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
                _builder.append((Object)".TYPE_FORMAT, \"");
                String _rosettaName_5 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_5, "\t\t\t\t\t");
                _builder.append((Object)"\", path, \"\", res.getError());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_6 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method_6, "\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_6 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_6, "\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
                _builder.append((Object)".TYPE_FORMAT, \"");
                String _rosettaName_7 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_7, "\t\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"})");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".collect(");
                Method _method_7 = ValidatorsGenerator.this._importManagerExtension.method(Collectors.class, "toList");
                _builder.append((Object)_method_7, "\t\t\t");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient onlyExistsClassBody(final JavaPojoInterface javaType, String version, final Iterable<RAttribute> attributes) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class ");
                JavaClass<?> _onlyExistsValidatorClass = ValidatorsGenerator.this._javaTypeTranslator.toOnlyExistsValidatorClass(javaType);
                _builder.append(_onlyExistsValidatorClass);
                _builder.append((Object)" implements ");
                _builder.append(ValidatorWithArg.class);
                _builder.append((Object)"<");
                _builder.append((Object)javaType);
                _builder.append((Object)", ");
                _builder.append(Set.class);
                _builder.append((Object)"<String>> {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"/* Casting is required to ensure types are output to ensure recompilation in Rosetta */");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public <T2 extends ");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> ");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<");
                _builder.append((Object)javaType, "\t");
                _builder.append((Object)"> validate(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, T2 o, ");
                _builder.append(Set.class, "\t");
                _builder.append((Object)"<String> fields) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(Map.class, "\t\t");
                _builder.append((Object)"<String, Boolean> fieldExistenceMap = ");
                _builder.append(ImmutableMap.class, "\t\t");
                _builder.append((Object)".<String, Boolean>builder()");
                _builder.newLineIfNotEmpty();
                for (RAttribute attr : attributes) {
                    _builder.append((Object)"\t\t\t\t");
                    JavaPojoProperty prop = javaType.findProperty(attr.getName());
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t");
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"o");
                        }
                    };
                    JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)".put(\"");
                    String _name = prop.getName();
                    _builder.append((Object)_name, "\t\t\t\t");
                    _builder.append((Object)"\", ");
                    _builder.append(ExistenceChecker.class, "\t\t\t\t");
                    _builder.append((Object)".isSet((");
                    JavaType _type = prop.getType();
                    _builder.append((Object)_type, "\t\t\t\t");
                    _builder.append((Object)") ");
                    _builder.append((Object)propCode, "\t\t\t\t");
                    _builder.append((Object)"))");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".build();");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Find the fields that are set");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(Set.class, "\t\t");
                _builder.append((Object)"<String> setFields = fieldExistenceMap.entrySet().stream()");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".filter(Map.Entry::getValue)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".map(Map.Entry::getKey)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)".collect(");
                _builder.append(Collectors.class, "\t\t\t\t");
                _builder.append((Object)".toSet());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (setFields.equals(fields)) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return ");
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method, "\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = javaType.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t");
                _builder.append((Object)".ONLY_EXISTS, \"");
                String _rosettaName_1 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_1, "\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t");
                _builder.append((Object)".ONLY_EXISTS, \"");
                String _rosettaName_3 = javaType.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t");
                _builder.append((Object)"\", path, \"\",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"String.format(\"[%s] should only be set.  Set fields: %s\", fields, setFields));");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient checkCardinality(JavaPojoInterface javaType, final RAttribute attr) {
        StringConcatenationClient _xifexpression = null;
        RCardinality _cardinality = attr.getCardinality();
        boolean _equals = Objects.equal((Object)_cardinality, (Object)RCardinality.UNBOUNDED);
        if (_equals) {
            _xifexpression = null;
        } else {
            StringConcatenationClient _client_1;
            StringConcatenationClient _xblockexpression = null;
            final JavaPojoProperty prop = javaType.findProperty(attr.getName());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"o");
                }
            };
            final JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
            _xifexpression = _xblockexpression = (_client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _isMulti = attr.isMulti();
                    if (_isMulti) {
                        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkCardinality");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", (");
                        JavaType _type = prop.getType();
                        _builder.append((Object)_type);
                        _builder.append((Object)") ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)" == null ? 0 : ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)".size(), ");
                        int _min = attr.getCardinality().getMin();
                        _builder.append((Object)_min);
                        _builder.append((Object)", ");
                        Integer _orElse = attr.getCardinality().getMax().orElse(0);
                        _builder.append((Object)_orElse);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Method _method_1 = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkCardinality");
                        _builder.append((Object)_method_1);
                        _builder.append((Object)"(\"");
                        String _name_1 = attr.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)"\", (");
                        JavaType _type_1 = prop.getType();
                        _builder.append((Object)_type_1);
                        _builder.append((Object)") ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)" != null ? 1 : 0, ");
                        int _min_1 = attr.getCardinality().getMin();
                        _builder.append((Object)_min_1);
                        _builder.append((Object)", ");
                        Integer _orElse_1 = attr.getCardinality().getMax().orElse(0);
                        _builder.append((Object)_orElse_1);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                }
            });
        }
        return _xifexpression;
    }

    private StringConcatenationClient checkTypeFormat(final JavaPojoInterface javaType, final RAttribute attr) {
        RType t = this._typeSystem.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
        if (t instanceof RStringType) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)t, (Object)this._rBuiltinTypeService.UNCONSTRAINED_STRING);
            if (_notEquals) {
                final int min = ((RStringType)t).getInterval().getMinBound();
                final StringConcatenationClient max = this.optional(((RStringType)t).getInterval().getMax());
                final StringConcatenationClient pattern = this.optionalPattern(((RStringType)t).getPattern());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkString");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", ");
                        StringConcatenationClient _attributeValue = ValidatorsGenerator.this.getAttributeValue(javaType, attr);
                        _builder.append((Object)_attributeValue);
                        _builder.append((Object)", ");
                        _builder.append((Object)min);
                        _builder.append((Object)", ");
                        _builder.append((Object)max);
                        _builder.append((Object)", ");
                        _builder.append((Object)pattern);
                        _builder.append((Object)")");
                    }
                };
                return _client;
            }
        } else if (t instanceof RNumberType) {
            boolean _notEquals_1;
            boolean bl = _notEquals_1 = !Objects.equal((Object)t, (Object)this._rBuiltinTypeService.UNCONSTRAINED_NUMBER);
            if (_notEquals_1) {
                final StringConcatenationClient digits = this.optional(((RNumberType)t).getDigits());
                final StringConcatenationClient fractionalDigits = this.optional(((RNumberType)t).getFractionalDigits());
                final StringConcatenationClient min_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMin());
                final StringConcatenationClient max_1 = this.optionalBigDecimal(((RNumberType)t).getInterval().getMax());
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        Method _method = ValidatorsGenerator.this._importManagerExtension.method(ExpressionOperators.class, "checkNumber");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", ");
                        StringConcatenationClient _attributeValue = ValidatorsGenerator.this.getAttributeValue(javaType, attr);
                        _builder.append((Object)_attributeValue);
                        _builder.append((Object)", ");
                        _builder.append((Object)digits);
                        _builder.append((Object)", ");
                        _builder.append((Object)fractionalDigits);
                        _builder.append((Object)", ");
                        _builder.append((Object)min_1);
                        _builder.append((Object)", ");
                        _builder.append((Object)max_1);
                        _builder.append((Object)")");
                    }
                };
                return _client_1;
            }
        }
        return null;
    }

    private StringConcatenationClient getAttributeValue(JavaPojoInterface javaType, RAttribute attr) {
        boolean _not;
        StringConcatenationClient _xblockexpression = null;
        JavaPojoProperty prop = javaType.findProperty(attr.getName());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"o");
            }
        };
        final JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
        StringConcatenationClient _xifexpression = null;
        boolean _hasMeta = attr.getRMetaAnnotatedType().hasMeta();
        boolean bl = _not = !_hasMeta;
        if (_not) {
            StringConcatenationClient _client_1;
            _xifexpression = _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)propCode);
                }
            };
        } else {
            StringConcatenationClient _xblockexpression_1 = null;
            JavaType jt = prop.getType();
            StringConcatenationClient _xifexpression_1 = null;
            boolean _isList = this._javaTypeUtil.isList(jt);
            if (_isList) {
                StringConcatenationClient _client_2;
                StringConcatenationClient _xblockexpression_2 = null;
                final JavaType itemType = this._javaTypeUtil.getItemType(jt);
                _xifexpression_1 = _xblockexpression_2 = (_client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)propCode);
                        _builder.append((Object)".stream().map(");
                        _builder.append((Object)itemType);
                        _builder.append((Object)"::getValue).collect(");
                        _builder.append(Collectors.class);
                        _builder.append((Object)".toList())");
                    }
                });
            } else {
                StringConcatenationClient _client_2;
                _xifexpression_1 = _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)propCode);
                        _builder.append((Object)".getValue()");
                    }
                };
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private StringConcatenationClient optional(final Optional<?> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(");
                Object _get = v.get();
                _builder.append(_get);
                _builder.append((Object)")");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient optionalPattern(final Optional<Pattern> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(");
                _builder.append(Pattern.class);
                _builder.append((Object)".compile(\"");
                String _escapeJava = StringEscapeUtils.escapeJava((String)((Pattern)v.get()).toString());
                _builder.append((Object)_escapeJava);
                _builder.append((Object)"\"))");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }

    private StringConcatenationClient optionalBigDecimal(final Optional<BigDecimal> v) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient _xifexpression = null;
        boolean _isPresent = v.isPresent();
        _xifexpression = _isPresent ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "of");
                _builder.append((Object)_method);
                _builder.append((Object)"(new ");
                _builder.append(BigDecimal.class);
                _builder.append((Object)"(\"");
                String _escapeJava = StringEscapeUtils.escapeJava((String)((BigDecimal)v.get()).toString());
                _builder.append((Object)_escapeJava);
                _builder.append((Object)"\"))");
            }
        }) : (_client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Method _method = ValidatorsGenerator.this._importManagerExtension.method(Optional.class, "empty");
                _builder.append((Object)_method);
                _builder.append((Object)"()");
            }
        });
        return _xifexpression;
    }
}

