/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.regnosys.rosetta.formatting2.IFormattedResourceAcceptor;
import com.regnosys.rosetta.formatting2.ResourceFormatterService;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XtextResourceFormatter
implements ResourceFormatterService {
    private static Logger LOGGER = LoggerFactory.getLogger(XtextResourceFormatter.class);
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private Provider<IFormatter2> iFormatter2Provider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;

    @Override
    public void formatCollection(Collection<Resource> resources, ITypedPreferenceValues preferenceValues, IFormattedResourceAcceptor acceptor) {
        resources.stream().forEach(resource -> {
            if (resource instanceof XtextResource) {
                this.formatXtextResource((XtextResource)resource, preferenceValues, acceptor);
            } else {
                LOGGER.debug("Resource is not of type XtextResource and will be skipped: " + resource.getURI());
            }
        });
    }

    @Override
    public void formatXtextResource(XtextResource resource, ITypedPreferenceValues preferenceValues, IFormattedResourceAcceptor acceptor) {
        ArrayList replacements;
        if (!resource.getAllContents().hasNext()) {
            LOGGER.info("Resource " + resource.getURI() + " is empty.");
            return;
        }
        LOGGER.info("Formatting file at location " + resource.getURI());
        FormatterRequest req = (FormatterRequest)this.formatterRequestProvider.get();
        req.setPreferences(preferenceValues);
        IFormatter2 formatter = (IFormatter2)this.iFormatter2Provider.get();
        ITextRegionAccess regionAccess = this.regionBuilder.forNodeModel(resource).create();
        req.setTextRegionAccess(regionAccess);
        try {
            replacements = formatter.format(req);
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in " + resource.getURI() + ": " + e.getMessage(), (Throwable)e);
            replacements = new ArrayList();
        }
        ITextRegionRewriter regionRewriter = regionAccess.getRewriter();
        String formattedString = regionRewriter.renderToString(regionAccess.regionForDocument(), (Iterable)replacements);
        acceptor.accept((Resource)resource, formattedString);
    }
}

