/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.regnosys.rosetta.formatting2.FormattingMode;
import com.regnosys.rosetta.formatting2.RosettaFormatterPreferenceKeys;
import com.regnosys.rosetta.formatting2.TrimmedMaxLineWidthDocument;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.ISubFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.util.ITextRegion;

public class FormattingUtil {
    public ITextRegionExtensions getTextRegionExt(IFormattableDocument doc) {
        return doc.getRequest().getTextRegionAccess().getExtensions();
    }

    public void formatInlineOrMultiline(IFormattableDocument document, EObject object, Consumer<IFormattableDocument> inlineFormatter, Consumer<IFormattableDocument> multilineFormatter) {
        this.formatInlineOrMultiline(document, object, FormattingMode.NORMAL, inlineFormatter, multilineFormatter);
    }

    public void formatInlineOrMultiline(IFormattableDocument document, EObject object, FormattingMode mode, Consumer<IFormattableDocument> inlineFormatter, Consumer<IFormattableDocument> multilineFormatter) {
        int maxLineWidth = (Integer)this.getPreference(document, (TypedPreferenceKey)RosettaFormatterPreferenceKeys.maxLineWidth);
        this.formatInlineOrMultiline(document, object, mode, maxLineWidth, inlineFormatter, multilineFormatter);
    }

    public void formatInlineOrMultiline(IFormattableDocument document, EObject object, FormattingMode mode, int maxLineWidth, Consumer<IFormattableDocument> inlineFormatter, Consumer<IFormattableDocument> multilineFormatter) {
        IEObjectRegion objRegion = this.getTextRegionExt(document).regionForEObject(object);
        ITextSegment formattableRegion = objRegion.merge((ITextRegion)objRegion.getNextHiddenRegion());
        this.formatInlineOrMultiline(document, (ITextSegment)objRegion, formattableRegion, mode, maxLineWidth, inlineFormatter, multilineFormatter);
    }

    public void formatInlineOrMultiline(IFormattableDocument document, ITextSegment astRegion, ITextSegment formattableRegion, FormattingMode mode, Consumer<IFormattableDocument> inlineFormatter, Consumer<IFormattableDocument> multilineFormatter) {
        int maxLineWidth = (Integer)this.getPreference(document, (TypedPreferenceKey)RosettaFormatterPreferenceKeys.maxLineWidth);
        this.formatInlineOrMultiline(document, astRegion, formattableRegion, mode, maxLineWidth, inlineFormatter, multilineFormatter);
    }

    public void formatInlineOrMultiline(IFormattableDocument document, ITextSegment astRegion, ITextSegment formattableRegion, FormattingMode mode, int maxLineWidth, Consumer<IFormattableDocument> inlineFormatter, Consumer<IFormattableDocument> multilineFormatter) {
        if (mode.equals((Object)FormattingMode.NORMAL)) {
            document.formatConditionally(formattableRegion.getOffset(), formattableRegion.getLength(), new ISubFormatter[]{doc -> {
                IFormattableSubDocument singleLineDoc = this.requireTrimmedFitsInLine((IFormattableDocument)doc, astRegion, formattableRegion, maxLineWidth);
                inlineFormatter.accept((IFormattableDocument)singleLineDoc);
            }, doc -> multilineFormatter.accept((IFormattableDocument)doc)});
        } else if (mode.equals((Object)FormattingMode.SINGLE_LINE)) {
            inlineFormatter.accept(document);
        } else if (mode.equals((Object)FormattingMode.CHAIN)) {
            multilineFormatter.accept(document);
        }
    }

    public IFormattableSubDocument requireTrimmedFitsInLine(IFormattableDocument document, ITextSegment astRegion, ITextSegment formattableRegion, int maxLineWidth) {
        TrimmedMaxLineWidthDocument subdoc = new TrimmedMaxLineWidthDocument(astRegion, formattableRegion, document, maxLineWidth);
        document.addReplacer((ITextReplacer)subdoc);
        return subdoc;
    }

    public void indentInner(EObject obj, IFormattableDocument document) {
        IHiddenRegion firstHiddenRegion = this.getTextRegionExt(document).previousHiddenRegion(obj).getNextHiddenRegion();
        this.indentInner(obj, firstHiddenRegion, document);
    }

    public void indentInner(EObject obj, IHiddenRegion indentationStart, IFormattableDocument document) {
        IHiddenRegion nextHiddenRegion = this.getTextRegionExt(document).nextHiddenRegion(obj);
        document.set(indentationStart, nextHiddenRegion, IHiddenRegionFormatter::indent);
    }

    public void formatAllUntil(IFormattableDocument document, IHiddenRegion start, IHiddenRegion end, Consumer<IHiddenRegionFormatter> formatter) {
        while (!start.equals(end)) {
            document.set(start, f -> formatter.accept((IHiddenRegionFormatter)f));
            start = start.getNextHiddenRegion();
        }
    }

    public void singleSpacesUntil(IFormattableDocument document, IHiddenRegion start, IHiddenRegion end) {
        this.formatAllUntil(document, start, end, f -> f.oneSpace());
    }

    public <T> T getPreference(IFormattableDocument document, TypedPreferenceKey<T> key) {
        return (T)document.getRequest().getPreferences().getPreference(key);
    }
}

