/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.regnosys.rosetta.formatting2.RosettaFormatterPreferenceKeys;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public class FormattingOptionsAdaptor {
    public static String PREFERENCE_INDENTATION_KEY = "indentation";
    public static String PREFERENCE_MAX_LINE_WIDTH_KEY = "maxLineWidth";
    public static String PREFERENCE_CONDITIONAL_MAX_LINE_WIDTH_KEY = "conditionalMaxLineWidth";
    private static final String DEFAULT_FORMATTING_OPTIONS_PATH = "default-formatting-options.json";

    public ITypedPreferenceValues createPreferences(FormattingOptions options) {
        Number maxLineWidth;
        MapBasedPreferenceValues preferences = new MapBasedPreferenceValues();
        String indent = "\t";
        if (options != null && options.isInsertSpaces()) {
            indent = Strings.padEnd((String)"", (int)options.getTabSize(), (char)' ');
        }
        preferences.put(PREFERENCE_INDENTATION_KEY, indent);
        if (options == null) {
            return preferences;
        }
        Number conditionalMaxLineWidth = options.getNumber(PREFERENCE_CONDITIONAL_MAX_LINE_WIDTH_KEY);
        if (conditionalMaxLineWidth != null) {
            preferences.put((TypedPreferenceKey)RosettaFormatterPreferenceKeys.conditionalMaxLineWidth, (Object)conditionalMaxLineWidth.intValue());
        }
        if ((maxLineWidth = options.getNumber(PREFERENCE_MAX_LINE_WIDTH_KEY)) != null) {
            preferences.put((TypedPreferenceKey)RosettaFormatterPreferenceKeys.maxLineWidth, (Object)maxLineWidth.intValue());
            if (conditionalMaxLineWidth == null) {
                int defaultConditionalMaxLineWidth = RosettaFormatterPreferenceKeys.conditionalMaxLineWidth.toValue(RosettaFormatterPreferenceKeys.conditionalMaxLineWidth.getDefaultValue());
                int defaultMaxLineWidth = RosettaFormatterPreferenceKeys.maxLineWidth.toValue(RosettaFormatterPreferenceKeys.maxLineWidth.getDefaultValue());
                double defaultRatio = (double)defaultConditionalMaxLineWidth / (double)defaultMaxLineWidth;
                preferences.put((TypedPreferenceKey)RosettaFormatterPreferenceKeys.conditionalMaxLineWidth, (Object)((int)(maxLineWidth.doubleValue() * defaultRatio)));
            }
        }
        return preferences;
    }

    public FormattingOptions readFormattingOptions(String optionsPath) throws IOException {
        InputStream resourceStream = optionsPath == null ? ResourceLoader.class.getClassLoader().getResourceAsStream(DEFAULT_FORMATTING_OPTIONS_PATH) : new FileInputStream(optionsPath);
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = null;
        map = (Map)objectMapper.readValue(resourceStream, Map.class);
        FormattingOptions formattingOptions = new FormattingOptions();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                formattingOptions.putString(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                formattingOptions.putNumber(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                formattingOptions.putBoolean(key, (Boolean)value);
                continue;
            }
            throw new IllegalArgumentException("Unsupported value type for key: " + key);
        }
        return formattingOptions;
    }
}

