/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.lib.labelprovider;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LabelNode {
    private final Map<List<String>, String> labels = new HashMap<List<String>, String>();
    private final Map<String, LabelNode> outgoingEdges = new HashMap<String, LabelNode>();

    public void addLabel(List<String> path, String label) {
        this.labels.put(path, label);
    }

    public void addOutgoingEdge(String pathElement, LabelNode connectedNode) {
        this.outgoingEdges.put(pathElement, connectedNode);
    }

    public String findLabelByTraversingGraph(LinkedList<String> inputPath) {
        if (inputPath.isEmpty()) {
            return null;
        }
        String labelFromNode = this.getLabelFromCurrentNode(inputPath);
        if (labelFromNode != null) {
            return labelFromNode;
        }
        String consumedInput = inputPath.poll();
        LabelNode nextNode = this.findNextNode(consumedInput);
        if (nextNode == null) {
            return null;
        }
        return nextNode.findLabelByTraversingGraph(inputPath);
    }

    private LabelNode findNextNode(String consumedInput) {
        return this.outgoingEdges.get(consumedInput);
    }

    private String getLabelFromCurrentNode(List<String> path) {
        return this.labels.get(path);
    }
}

