/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeDeclaration;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.JavaTypeVisitor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public abstract class JavaParameterizedType<T>
extends JavaClass<T> {
    public static <T> JavaParameterizedType<T> from(TypeReference<T> typeRef, List<JavaTypeArgument> arguments) {
        Type t = typeRef.getType();
        if (t instanceof ParameterizedType) {
            return JavaParameterizedType.from(JavaGenericTypeDeclaration.from(JavaParameterizedType.extractRawClass(t)), arguments);
        }
        throw new IllegalArgumentException("Type " + t + " is not a parameterized type.");
    }

    public static <T> JavaParameterizedType<T> from(TypeReference<T> typeRef, JavaTypeArgument ... arguments) {
        return JavaParameterizedType.from(typeRef, Arrays.asList(arguments));
    }

    public static <T> JavaParameterizedType<T> from(Class<T> rawType, ParameterizedType t, Map<TypeVariable<?>, JavaTypeVariable> context) {
        return JavaParameterizedType.from(JavaGenericTypeDeclaration.from(rawType), Arrays.stream(t.getActualTypeArguments()).map(ta -> JavaTypeArgument.from(ta, context)).collect(Collectors.toList()));
    }

    public static <T> JavaParameterizedType<T> from(JavaGenericTypeDeclaration<? super T> typeDeclaration, JavaTypeArgument ... arguments) {
        return JavaParameterizedType.from(typeDeclaration, Arrays.asList(arguments));
    }

    public static <T> JavaParameterizedType<T> from(JavaGenericTypeDeclaration<? super T> typeDeclaration, List<JavaTypeArgument> arguments) {
        return new JavaParameterizedTypeImpl<T>(typeDeclaration, arguments);
    }

    public static <U> Class<U> extractRawClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            return JavaParameterizedType.extractRawClass(((GenericArrayType)t).getGenericComponentType());
        }
        if (t instanceof ParameterizedType) {
            return JavaParameterizedType.extractRawClass(((ParameterizedType)t).getRawType());
        }
        throw new IllegalArgumentException("Cannot use a type reference to " + t + ". No raw class found.");
    }

    public abstract JavaGenericTypeDeclaration<? super T> getGenericTypeDeclaration();

    public abstract List<JavaTypeArgument> getArguments();

    @Override
    public boolean isSubtypeOf(JavaType other) {
        if (this.equals(other) || other.equals(OBJECT)) {
            return true;
        }
        if (other instanceof JavaParameterizedType) {
            return ((JavaParameterizedType)other).isSupertypeOf(this);
        }
        if (other instanceof JavaClass) {
            return this.getGenericTypeDeclaration().getBaseType().isSubtypeOf(other);
        }
        return false;
    }

    public boolean isSupertypeOf(JavaClass<?> other) {
        if (this.equals(other)) {
            return true;
        }
        JavaGenericTypeDeclaration typeDeclaration = this.getGenericTypeDeclaration();
        if (other.extendsDeclaration(typeDeclaration)) {
            JavaClass currentSuper = other;
            JavaClass<T> nextSuper = currentSuper.getSuperclass();
            while (nextSuper.extendsDeclaration(typeDeclaration)) {
                currentSuper = nextSuper;
                nextSuper = currentSuper.getSuperclass();
            }
            Optional<JavaClass> nextInterface = currentSuper.getInterfaces().stream().filter(i -> i.extendsDeclaration(typeDeclaration)).findAny();
            while (nextInterface.isPresent()) {
                currentSuper = nextInterface.get();
                nextInterface = currentSuper.getInterfaces().stream().filter(i -> i.extendsDeclaration(typeDeclaration)).findAny();
            }
            Map<JavaTypeVariable, JavaTypeArgument> substitution = ((JavaParameterizedType)currentSuper).getTypeVariableSubstitution();
            int paramCount = this.getGenericTypeDeclaration().getParameters().size();
            for (int i2 = 0; i2 < paramCount; ++i2) {
                JavaTypeArgument otherArgument;
                JavaTypeArgument argument = this.getArguments().get(i2);
                if (argument.contains(otherArgument = substitution.get(this.getGenericTypeDeclaration().getParameters().get(i2)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<JavaTypeVariable, JavaTypeArgument> getTypeVariableSubstitution() {
        HashMap<JavaTypeVariable, JavaTypeArgument> substitution = new HashMap<JavaTypeVariable, JavaTypeArgument>();
        this.addTypeVariableSubstitution(substitution);
        return substitution;
    }

    public void addTypeVariableSubstitution(Map<JavaTypeVariable, JavaTypeArgument> substitution) {
        JavaGenericTypeDeclaration<T> declaration = this.getGenericTypeDeclaration();
        for (int i = 0; i < declaration.getParameters().size(); ++i) {
            JavaTypeVariable parameter = declaration.getParameters().get(i);
            JavaTypeArgument argument = this.getArguments().get(i);
            if (substitution.containsKey(argument)) {
                argument = substitution.get(argument);
            }
            substitution.put(parameter, argument);
        }
    }

    @Override
    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        return this.getGenericTypeDeclaration().extendsDeclaration(other);
    }

    @Override
    public JavaTypeDeclaration<? super T> getSuperclassDeclaration() {
        return this.getGenericTypeDeclaration().getSuperclassDeclaration();
    }

    @Override
    public JavaClass<? super T> getSuperclass() {
        return this.getGenericTypeDeclaration().getSuperclass().applySubstitution(this.getTypeVariableSubstitution());
    }

    @Override
    public List<? extends JavaTypeDeclaration<?>> getInterfaceDeclarations() {
        return this.getGenericTypeDeclaration().getInterfaceDeclarations();
    }

    @Override
    public List<JavaClass<?>> getInterfaces() {
        return this.getGenericTypeDeclaration().getInterfaces().stream().map(i -> i.applySubstitution(this.getTypeVariableSubstitution())).collect(Collectors.toList());
    }

    @Override
    public JavaParameterizedType<T> applySubstitution(Map<JavaTypeVariable, JavaTypeArgument> substitution) {
        List<JavaTypeArgument> newArguments = this.getArguments().stream().map(arg -> (JavaTypeArgument)substitution.get(arg)).collect(Collectors.toList());
        return new JavaParameterizedTypeImpl<T>(this.getGenericTypeDeclaration(), newArguments);
    }

    @Override
    public Class<? extends T> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        return this.getGenericTypeDeclaration().loadClass(classLoader);
    }

    @Override
    public boolean isFinal() {
        return this.getGenericTypeDeclaration().isFinal();
    }

    @Override
    public String getSimpleName() {
        return this.getGenericTypeDeclaration().getBaseType().getSimpleName();
    }

    @Override
    public DottedPath getPackageName() {
        return this.getGenericTypeDeclaration().getBaseType().getPackageName();
    }

    @Override
    public String toString() {
        return this.getSimpleName() + "<" + this.getArguments().stream().map(Object::toString).collect(Collectors.joining(", ")) + ">";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getGenericTypeDeclaration(), this.getArguments());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaParameterizedType other = (JavaParameterizedType)object;
        return Objects.equals(this.getGenericTypeDeclaration(), other.getGenericTypeDeclaration()) && Objects.equals(this.getArguments(), other.getArguments());
    }

    @Override
    public void accept(JavaTypeVisitor visitor) {
        visitor.visitType(this);
    }

    protected static class JavaParameterizedTypeImpl<T>
    extends JavaParameterizedType<T> {
        private final JavaGenericTypeDeclaration<? super T> genericTypeDeclaration;
        private final List<JavaTypeArgument> arguments;

        public JavaParameterizedTypeImpl(JavaGenericTypeDeclaration<? super T> genericTypeDeclaration, List<JavaTypeArgument> arguments) {
            Validate.isTrue((genericTypeDeclaration.getParameters().size() == arguments.size() ? 1 : 0) != 0);
            this.genericTypeDeclaration = genericTypeDeclaration;
            this.arguments = arguments;
        }

        @Override
        public JavaGenericTypeDeclaration<? super T> getGenericTypeDeclaration() {
            return this.genericTypeDeclaration;
        }

        @Override
        public List<JavaTypeArgument> getArguments() {
            return this.arguments;
        }
    }
}

