/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.validation;

import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.CardinalityValidationData;
import com.rosetta.model.lib.validation.ElementValidationResult;
import com.rosetta.model.lib.validation.NumberValidationData;
import com.rosetta.model.lib.validation.StringValidationData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ValidationUtil {
    public static ElementValidationResult checkCardinality(String msgPrefix, int actual, int min, int max, RosettaPath path) {
        CardinalityValidationData cardinalityValidationData = new CardinalityValidationData(min, max, actual);
        String failureMessage = "";
        if (actual < min) {
            if (actual == 0) {
                failureMessage = "'" + msgPrefix + "' is a required field but does not exist.";
                return ElementValidationResult.failure(null, failureMessage, cardinalityValidationData);
            }
            failureMessage = "Minimum of " + min + " '" + msgPrefix + "' is expected but found " + actual + ".";
            return ElementValidationResult.failure(null, failureMessage, cardinalityValidationData);
        }
        if (max > 0 && actual > max) {
            failureMessage = "Maximum of " + max + " '" + msgPrefix + "' are expected but found " + actual + ".";
            return ElementValidationResult.failure(path, failureMessage, cardinalityValidationData);
        }
        return ElementValidationResult.success(path);
    }

    public static ElementValidationResult checkString(String msgPrefix, String value, int minLength, Optional<Integer> maxLength, Optional<Pattern> pattern, RosettaPath path) {
        Pattern p;
        Matcher match;
        if (value == null) {
            return ElementValidationResult.success(path);
        }
        StringValidationData stringValidationData = new StringValidationData(minLength, maxLength, pattern, value);
        ArrayList<String> failures = new ArrayList<String>();
        if (value.length() < minLength) {
            failures.add("Field '" + msgPrefix + "' requires a value with minimum length of " + minLength + " characters but value '" + value + "' has length of " + value.length() + " characters.");
        }
        if (maxLength.isPresent()) {
            int m = maxLength.get();
            if (value.length() > m) {
                failures.add("Field '" + msgPrefix + "' must have a value with maximum length of " + m + " characters but value '" + value + "' has length of " + value.length() + " characters.");
            }
        }
        if (pattern.isPresent() && !(match = (p = pattern.get()).matcher(value)).matches()) {
            failures.add("Field '" + msgPrefix + "' with value '" + value + "' does not match the pattern /" + p.toString() + "/.");
        }
        if (failures.isEmpty()) {
            return ElementValidationResult.success(path);
        }
        return ElementValidationResult.failure(path, failures.stream().collect(Collectors.joining(" ")), stringValidationData);
    }

    public static ElementValidationResult checkNumber(String msgPrefix, BigDecimal value, Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max, RosettaPath path) {
        BigDecimal m;
        int actual;
        BigDecimal normalized;
        if (value == null) {
            return ElementValidationResult.success(path);
        }
        NumberValidationData numValData = new NumberValidationData(min, max, digits.isPresent() ? digits : Optional.of(0), fractionalDigits.isPresent() ? fractionalDigits : Optional.of(0), value);
        ArrayList<String> failures = new ArrayList<String>();
        if (digits.isPresent()) {
            int d = digits.get();
            normalized = value.stripTrailingZeros();
            actual = normalized.precision();
            if (normalized.scale() >= normalized.precision()) {
                actual = normalized.scale() + 1;
            }
            if (normalized.scale() < 0) {
                actual -= normalized.scale();
            }
            if (actual > d) {
                failures.add("Expected a maximum of " + d + " digits for '" + msgPrefix + "', but the number " + value + " has " + actual + ".");
            }
        }
        if (fractionalDigits.isPresent()) {
            int f = fractionalDigits.get();
            normalized = value.stripTrailingZeros();
            actual = normalized.scale();
            if (normalized.scale() < 0) {
                actual = 0;
            }
            if (actual > f) {
                failures.add("Expected a maximum of " + f + " fractional digits for '" + msgPrefix + "', but the number " + value + " has " + actual + ".");
            }
        }
        if (min.isPresent() && value.compareTo(m = min.get()) < 0) {
            failures.add("Expected a number greater than or equal to " + m.toPlainString() + " for '" + msgPrefix + "', but found " + value + ".");
        }
        if (max.isPresent() && value.compareTo(m = max.get()) > 0) {
            failures.add("Expected a number less than or equal to " + m.toPlainString() + " for '" + msgPrefix + "', but found " + value + ".");
        }
        if (failures.isEmpty()) {
            return ElementValidationResult.success(path);
        }
        return ElementValidationResult.failure(path, failures.stream().collect(Collectors.joining(" ")), numValData);
    }

    public static ElementValidationResult checkNumber(String msgPrefix, Integer value, Optional<Integer> digits, Optional<BigDecimal> min, Optional<BigDecimal> max, RosettaPath path) {
        BigDecimal m;
        if (value == null) {
            return ElementValidationResult.success(path);
        }
        BigDecimal valuasDecimal = BigDecimal.valueOf(value.intValue());
        NumberValidationData numValData = new NumberValidationData(min, max, digits.isPresent() ? digits : Optional.of(0), Optional.of(0), valuasDecimal);
        ArrayList<String> failures = new ArrayList<String>();
        if (digits.isPresent()) {
            int d = digits.get();
            BigDecimal normalized = valuasDecimal.stripTrailingZeros();
            int actual = normalized.precision();
            if (normalized.scale() >= normalized.precision()) {
                actual = normalized.scale() + 1;
            }
            if (normalized.scale() < 0) {
                actual -= normalized.scale();
            }
            if (actual > d) {
                failures.add("Expected a maximum of " + d + " digits for '" + msgPrefix + "', but the number " + value + " has " + actual + ".");
            }
        }
        if (min.isPresent() && valuasDecimal.compareTo(m = min.get()) < 0) {
            failures.add("Expected a number greater than or equal to " + m.toPlainString() + " for '" + msgPrefix + "', but found " + value + ".");
        }
        if (max.isPresent() && valuasDecimal.compareTo(m = max.get()) > 0) {
            failures.add("Expected a number less than or equal to " + m.toPlainString() + " for '" + msgPrefix + "', but found " + value + ".");
        }
        if (failures.isEmpty()) {
            return ElementValidationResult.success(path);
        }
        return ElementValidationResult.failure(path, failures.stream().collect(Collectors.joining(" ")), numValData);
    }
}

