/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.regnosys.rosetta.common.transform.FunctionNameHelper;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.testing.pipeline.PipelineNode;
import com.regnosys.testing.pipeline.PipelineTree;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PipelineModelBuilder {
    private final FunctionNameHelper helper;

    @Inject
    public PipelineModelBuilder(FunctionNameHelper helper) {
        this.helper = helper;
    }

    public List<PipelineModel> createPipelineModels(PipelineTree pipelineTree) {
        return pipelineTree.getNodeList().stream().map(modelBuilder -> this.build((PipelineNode)modelBuilder, pipelineTree.getPipelineTreeConfig())).collect(Collectors.toList());
    }

    protected PipelineModel build(PipelineNode modelBuilder, PipelineTreeConfig config) {
        String inputType = this.helper.getInputType(modelBuilder.getFunction());
        String outputType = this.helper.getOutputType(modelBuilder.getFunction());
        String inputSerialisationConfigPath = (String)config.getXmlConfigMap().get((Object)this.helper.getInputClass(modelBuilder.getFunction()));
        String outputSerialisationConfigPath = (String)config.getXmlConfigMap().get(this.helper.getFuncMethod(modelBuilder.getFunction()).getReturnType());
        PipelineModel.Serialisation.Format inputSerialisationFormat = Optional.ofNullable(config.getInputSerialisationFormatMap()).map(formatMap -> (PipelineModel.Serialisation.Format)formatMap.get((Object)this.helper.getInputClass(modelBuilder.getFunction()))).orElse(null);
        PipelineModel.Serialisation.Format outputSerialisationFormat = Optional.ofNullable(config.getOutputSerialisationFormatMap()).map(formatMap -> (PipelineModel.Serialisation.Format)formatMap.get(this.helper.getFuncMethod(modelBuilder.getFunction()).getReturnType())).orElse(null);
        String name = this.helper.getName(modelBuilder.getFunction());
        PipelineModel.Serialisation inputSerialisation = TestPackUtils.getSerialisation((PipelineModel.Serialisation.Format)inputSerialisationFormat, (String)inputSerialisationConfigPath);
        PipelineModel.Serialisation outputSerialisation = TestPackUtils.getSerialisation((PipelineModel.Serialisation.Format)outputSerialisationFormat, (String)outputSerialisationConfigPath);
        String pipelineId = modelBuilder.id(config.isStrictUniqueIds());
        String upstreamPipelineId = modelBuilder.upstreamId(config.isStrictUniqueIds());
        String modelId = config.getModelId();
        String prefixedPipelineName = StringUtils.isEmpty((CharSequence)modelId) ? name : String.format("%s %s", modelId, name);
        return new PipelineModel(pipelineId, prefixedPipelineName, new PipelineModel.Transform(modelBuilder.getTransformType(), modelBuilder.getFunction().getName(), inputType, outputType), upstreamPipelineId, inputSerialisation, outputSerialisation, modelId);
    }
}

