/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ReferenceResolverProcessStep;
import com.regnosys.rosetta.common.postprocess.PathCountProcessor;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.regnosys.testing.pipeline.PipelineFunctionResult;
import com.regnosys.testing.pipeline.PipelineFunctionRunner;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.PostProcessor;
import com.rosetta.model.lib.process.Processor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Function;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PipelineFunctionRunnerImpl<IN extends RosettaModelObject>
implements PipelineFunctionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineFunctionRunnerImpl.class);
    private final TransformType transformType;
    private final Function<IN, RosettaModelObject> function;
    private final Class<IN> inputType;
    private final RosettaTypeValidator typeValidator;
    private final ReferenceConfig referenceConfig;
    private final ObjectMapper inputObjectMapper;
    private final ObjectWriter outputObjectWriter;
    private final PostProcessor postProcessor;
    private final Validator xsdValidator;

    public PipelineFunctionRunnerImpl(TransformType transformType, Function<IN, RosettaModelObject> function, Class<IN> inputType, RosettaTypeValidator typeValidator, ReferenceConfig referenceConfig, ObjectMapper inputObjectMapper, ObjectWriter outputObjectWriter, PostProcessor postProcessor, Validator xsdValidator) {
        this.transformType = transformType;
        this.function = function;
        this.inputType = inputType;
        this.typeValidator = typeValidator;
        this.referenceConfig = referenceConfig;
        this.inputObjectMapper = inputObjectMapper;
        this.outputObjectWriter = outputObjectWriter;
        this.postProcessor = postProcessor;
        this.xsdValidator = xsdValidator;
    }

    @Override
    public PipelineFunctionResult run(Path inputPath) {
        Integer inputPathCount = null;
        Integer outputPathCount = null;
        String serialisedOutput = "";
        ValidationReport validationReport = null;
        Integer actualValidationFailures = null;
        Boolean schemaValidationFailure = null;
        try {
            RosettaModelObject resolvedInput;
            RosettaModelObject output;
            URL inputFileUrl = inputPath.toUri().toURL();
            String inputContent = this.readString(inputFileUrl);
            if (inputContent == null || "".equals(inputContent)) {
                TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(inputPathCount, outputPathCount, actualValidationFailures, schemaValidationFailure, Boolean.valueOf(false));
                return new PipelineFunctionResult(serialisedOutput, validationReport, assertions);
            }
            RosettaModelObject input = (RosettaModelObject)this.inputObjectMapper.readValue(inputContent, this.inputType);
            if (this.transformType == TransformType.TRANSLATE) {
                inputPathCount = this.getPathCount(input);
            }
            if ((output = this.function.apply(resolvedInput = this.resolveReferences(input))) == null) {
                TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(inputPathCount, outputPathCount, actualValidationFailures, schemaValidationFailure, Boolean.valueOf(false));
                return new PipelineFunctionResult(serialisedOutput, validationReport, assertions);
            }
            RosettaModelObject postProcessedOutput = this.postProcess(output);
            serialisedOutput = this.outputObjectWriter.writeValueAsString((Object)postProcessedOutput);
            if (this.transformType == TransformType.TRANSLATE) {
                outputPathCount = this.getPathCount(postProcessedOutput);
            }
            validationReport = this.typeValidator.runProcessStep(postProcessedOutput.getType(), postProcessedOutput);
            validationReport.logReport();
            actualValidationFailures = validationReport.validationFailures().size();
            schemaValidationFailure = this.isSchemaValidationFailure(serialisedOutput);
            TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(inputPathCount, outputPathCount, actualValidationFailures, schemaValidationFailure, Boolean.valueOf(false));
            return new PipelineFunctionResult(serialisedOutput, validationReport, assertions);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred running transform", (Throwable)e);
            TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(inputPathCount, outputPathCount, actualValidationFailures, schemaValidationFailure, Boolean.valueOf(true));
            return new PipelineFunctionResult("", validationReport, assertions);
        }
    }

    private int getPathCount(RosettaModelObject o) {
        PathCountProcessor processor = new PathCountProcessor();
        o.process((RosettaPath)new RosettaPath.NullPath(), (Processor)processor);
        return processor.report().getCollectedPaths().size();
    }

    private <X extends RosettaModelObject> X postProcess(X output) {
        RosettaModelObjectBuilder outputBuilder = output.toBuilder();
        this.postProcessor.postProcess(outputBuilder.getType(), outputBuilder);
        return (X)outputBuilder.build();
    }

    private <T extends RosettaModelObject> T resolveReferences(T o) {
        RosettaModelObjectBuilder builder = o.toBuilder();
        new ReferenceResolverProcessStep(this.referenceConfig).runProcessStep(o.getType(), (RosettaModelObject)builder);
        return (T)builder.build();
    }

    private Boolean isSchemaValidationFailure(String xml) {
        Boolean bl;
        if (this.xsdValidator == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            this.xsdValidator.validate(new StreamSource(inputStream));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException e) {
                LOGGER.error("Schema validation failed: {}", (Object)e.getMessage());
                return false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return bl;
    }

    private String readString(URL u) {
        String string;
        block8: {
            Reader src = UrlUtils.openURL((URL)u);
            try {
                string = IOUtils.toString((Reader)src);
                if (src == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Failed to read url %s", u), e);
                }
            }
            src.close();
        }
        return string;
    }
}

