/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.transgest.ModelLoader;
import com.regnosys.testing.RosettaTestingInjectorProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedModelElementFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnusedModelElementFinder.class);
    private final Set<String> listOfTypes = new HashSet<String>();
    private final Set<String> listOfUsedTypes = new HashSet<String>();
    private final Set<String> listOfOrphanedTypes = new HashSet<String>();
    private final Set<String> listOfDeprecatedTypes = new HashSet<String>();
    private final List<RosettaModel> models;

    public UnusedModelElementFinder(List<RosettaModel> models) {
        this.models = models;
    }

    public static void main(String[] args) {
        Injector injector = new RosettaTestingInjectorProvider().getInjector();
        ModelLoader loader = (ModelLoader)injector.getInstance(ModelLoader.class);
        List models = loader.loadRosettaModels(ClassPathUtils.findRosettaFilePaths().stream().map(UrlUtils::toUrl));
        new UnusedModelElementFinder(models).run();
    }

    public void run() {
        this.generateTypesList();
        LOGGER.trace("{} Types found in Model ", (Object)this.listOfTypes.size());
        LOGGER.trace("{} Types are used within Model", (Object)this.listOfUsedTypes.size());
        this.listOfOrphanedTypes.addAll(this.listOfTypes);
        this.listOfOrphanedTypes.removeAll(this.listOfUsedTypes);
        LOGGER.trace("out of which {} are now orphaned types as listed below:", (Object)this.listOfOrphanedTypes.size());
    }

    private String getQualifiedName(RosettaType type) {
        return type.getModel().getName() + "." + type.getName();
    }

    private void generateTypesList() {
        for (RosettaModel model : this.models) {
            LOGGER.trace("Processing namespace {}, containing {} model elements", (Object)model.getName(), (Object)model.getElements().size());
            model.getElements().stream().filter(Data.class::isInstance).map(Data.class::cast).forEach(dataType -> {
                LOGGER.trace(" Processing data type: {}", (Object)this.getQualifiedName((RosettaType)dataType));
                this.listOfTypes.add(this.getQualifiedName((RosettaType)dataType));
                if (null != dataType.getSuperType()) {
                    this.listOfUsedTypes.add(this.getQualifiedName((RosettaType)dataType.getSuperType()));
                }
                TreeIterator eObjectTreeIterator = dataType.eAllContents();
                this.updateUsedTypes((TreeIterator<EObject>)eObjectTreeIterator);
                this.updateDeprecatedTypes((Data)dataType);
            });
            model.getElements().stream().filter(RosettaEnumeration.class::isInstance).map(RosettaEnumeration.class::cast).forEach(enumeration -> {
                LOGGER.trace("Processing enumeration type {}", (Object)this.getQualifiedName((RosettaType)enumeration));
                this.listOfTypes.add(this.getQualifiedName((RosettaType)enumeration));
            });
            model.getElements().stream().filter(Function.class::isInstance).map(Function.class::cast).forEach(function -> {
                LOGGER.trace(" Processing function types {}.{}", (Object)function.getModel().getName(), (Object)function.getName());
                TreeIterator eObjectTreeIterator = function.eAllContents();
                this.updateUsedTypes((TreeIterator<EObject>)eObjectTreeIterator);
            });
        }
    }

    private void updateDeprecatedTypes(Data dataType) {
        EList annotations = dataType.getAnnotations();
        annotations.forEach(annotationRef -> {
            if (annotationRef.getAnnotation().getName().equals("deprecated")) {
                this.listOfDeprecatedTypes.add(this.getQualifiedName((RosettaType)dataType));
            }
        });
    }

    private void updateUsedTypes(TreeIterator<EObject> eObjectTreeIterator) {
        ArrayList elements = Lists.newArrayList(eObjectTreeIterator);
        elements.stream().filter(TypeCall.class::isInstance).map(TypeCall.class::cast).forEach(typeCall -> this.listOfUsedTypes.add(this.getQualifiedName(typeCall.getType())));
    }

    public Set<String> getListOfTypes() {
        return this.listOfTypes;
    }

    public Set<String> getListOfUsedTypes() {
        return this.listOfUsedTypes;
    }

    public Set<String> getListOfOrphanedTypes() {
        return this.listOfOrphanedTypes;
    }

    public Set<String> getListOfDeprecatedTypes() {
        return this.listOfDeprecatedTypes;
    }
}

