/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.testpack;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Injector;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.testing.testpack.TestPackFunctionRunner;
import com.regnosys.testing.testpack.TestPackFunctionRunnerImpl;
import com.regnosys.testing.testpack.TestPackFunctionRunnerProvider;
import com.rosetta.model.lib.RosettaModelObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class TestPackFunctionRunnerProviderImpl
implements TestPackFunctionRunnerProvider {
    private static final ObjectMapper JSON_OBJECT_MAPPER = RosettaObjectMapper.getNewRosettaObjectMapper();
    private static final ObjectWriter JSON_OBJECT_WRITER = JSON_OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).writerWithDefaultPrettyPrinter();
    @Inject
    RosettaTypeValidator typeValidator;
    @Inject
    ReferenceConfig referenceConfig;

    @Override
    public TestPackFunctionRunner create(PipelineModel.Transform transform, PipelineModel.Serialisation inputSerialisation, PipelineModel.Serialisation outputSerialisation, ImmutableMap<Class<?>, String> schemaMap, Injector injector) {
        Class<? extends RosettaModelObject> inputType = this.toClass(transform.getInputType());
        Class<? extends RosettaModelObject> outputType = this.toClass(transform.getOutputType());
        ObjectMapper inputObjectMapper = Optional.ofNullable(inputSerialisation).flatMap(TestPackUtils::getObjectMapper).orElse(JSON_OBJECT_MAPPER);
        ObjectWriter outputObjectWriter = Optional.ofNullable(outputSerialisation).flatMap(TestPackUtils::getObjectWriter).orElse(JSON_OBJECT_WRITER);
        Validator xsdValidator = Optional.ofNullable(schemaMap).map(sm -> this.getXsdValidator(outputType, (ImmutableMap<Class<?>, String>)sm)).orElse(null);
        return this.createTestPackFunctionRunner(this.toClass(transform.getFunction()), inputType, injector, inputObjectMapper, outputObjectWriter, xsdValidator);
    }

    private <IN extends RosettaModelObject> TestPackFunctionRunner createTestPackFunctionRunner(Class<?> functionType, Class<IN> inputType, Injector injector, ObjectMapper inputObjectMapper, ObjectWriter outputObjectWriter, Validator xsdValidator) {
        Function<IN, RosettaModelObject> transformFunction = this.getTransformFunction(functionType, inputType, injector);
        return new TestPackFunctionRunnerImpl<IN>(transformFunction, inputType, this.typeValidator, this.referenceConfig, inputObjectMapper, outputObjectWriter, xsdValidator);
    }

    private Class<? extends RosettaModelObject> toClass(String name) {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private <IN extends RosettaModelObject> Function<IN, RosettaModelObject> getTransformFunction(Class<?> functionType, Class<IN> inputType, Injector injector) {
        Method evaluateMethod;
        Object functionInstance = injector.getInstance(functionType);
        try {
            evaluateMethod = functionInstance.getClass().getMethod("evaluate", inputType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Evaluate method with input type %s not found", inputType.getName()), e);
        }
        return resolvedInput -> {
            try {
                return (RosettaModelObject)evaluateMethod.invoke(functionInstance, resolvedInput);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to invoke evaluate method", e);
            }
        };
    }

    private Validator getXsdValidator(Class<?> functionType, ImmutableMap<Class<?>, String> outputSchemaMap) {
        URL schemaUrl = Optional.ofNullable((String)outputSchemaMap.get(functionType)).map(Resources::getResource).orElse(null);
        if (schemaUrl == null) {
            return null;
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            Schema schema = schemaFactory.newSchema(schemaUrl);
            return schema.newValidator();
        }
        catch (SAXException e) {
            throw new RuntimeException(String.format("Failed to create schema validator for %s", schemaUrl), e);
        }
    }
}

