/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.testpack;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ReferenceResolverProcessStep;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.rosetta.common.util.Pair;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.regnosys.testing.testpack.TestPackFunctionRunner;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Function;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TestPackFunctionRunnerImpl<IN extends RosettaModelObject>
implements TestPackFunctionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPackFunctionRunnerImpl.class);
    public static final Path ROSETTA_SOURCE_PATH = Path.of("rosetta-source/src/main/resources/", new String[0]);
    private final Function<IN, RosettaModelObject> function;
    private final Class<IN> inputType;
    private final RosettaTypeValidator typeValidator;
    private final ReferenceConfig referenceConfig;
    private final ObjectMapper inputObjectMapper;
    private final ObjectWriter outputObjectWriter;
    private final Validator xsdValidator;

    public TestPackFunctionRunnerImpl(Function<IN, RosettaModelObject> function, Class<IN> inputType, RosettaTypeValidator typeValidator, ReferenceConfig referenceConfig, ObjectMapper inputObjectMapper, ObjectWriter outputObjectWriter, Validator xsdValidator) {
        this.function = function;
        this.inputType = inputType;
        this.typeValidator = typeValidator;
        this.referenceConfig = referenceConfig;
        this.inputObjectMapper = inputObjectMapper;
        this.outputObjectWriter = outputObjectWriter;
        this.xsdValidator = xsdValidator;
    }

    @Override
    public Pair<String, TestPackModel.SampleModel.Assertions> run(Path inputPath) {
        String serialisedOutput;
        RosettaModelObject output;
        try {
            Path inputPathFromRepositoryRoot = inputPath.isAbsolute() ? inputPath : ROSETTA_SOURCE_PATH.resolve(inputPath);
            URL inputFileUrl = inputPathFromRepositoryRoot.toUri().toURL();
            RosettaModelObject input = (RosettaModelObject)TestPackUtils.readFile((URL)inputFileUrl, (ObjectMapper)this.inputObjectMapper, this.inputType);
            output = this.function.apply(this.resolveReferences(input));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to load input path {}", (Object)inputPath, (Object)e);
            return Pair.of((Object)"", (Object)new TestPackModel.SampleModel.Assertions(null, null, Boolean.valueOf(true)));
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred running sample creation", (Throwable)e);
            return Pair.of((Object)"", (Object)new TestPackModel.SampleModel.Assertions(null, null, Boolean.valueOf(true)));
        }
        try {
            serialisedOutput = this.outputObjectWriter.writeValueAsString((Object)output);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialise function output", e);
        }
        ValidationReport validationReport = this.typeValidator.runProcessStep(output.getType(), output);
        validationReport.logReport();
        int actualValidationFailures = validationReport.validationFailures().size();
        Boolean schemaValidationFailure = this.isSchemaValidationFailure(serialisedOutput);
        TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(Integer.valueOf(actualValidationFailures), schemaValidationFailure, Boolean.valueOf(false));
        return Pair.of((Object)serialisedOutput, (Object)assertions);
    }

    private <T extends RosettaModelObject> T resolveReferences(T o) {
        RosettaModelObjectBuilder builder = o.toBuilder();
        new ReferenceResolverProcessStep(this.referenceConfig).runProcessStep(o.getType(), (RosettaModelObject)builder);
        return (T)builder.build();
    }

    private Boolean isSchemaValidationFailure(String xml) {
        Boolean bl;
        if (this.xsdValidator == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            this.xsdValidator.validate(new StreamSource(inputStream));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException e) {
                LOGGER.error("Schema validation failed: {}", (Object)e.getMessage());
                return false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return bl;
    }
}

