/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing;

import com.google.common.collect.ImmutableList;
import com.regnosys.rosetta.common.util.Pair;
import com.regnosys.testing.ValidationReport;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class RosettaFileNameValidator {
    private static final List<String> VALID_SUFFIX = ImmutableList.of((Object)"func", (Object)"rule", (Object)"enum", (Object)"type", (Object)"synonym", (Object)"desc");
    private final String modelShortName;
    private final Path pathToRosettaFiles;
    private final Optional<Path> parentModelExclusionFile;

    public RosettaFileNameValidator(String modelShortName, Path pathToRosettaFiles, @Nullable Path parentModelExclusionFile) {
        this.modelShortName = modelShortName;
        this.pathToRosettaFiles = pathToRosettaFiles;
        this.parentModelExclusionFile = Optional.ofNullable(parentModelExclusionFile);
    }

    public ValidationReport validateFileNamesMatchNamespace() throws IOException {
        Set<String> parentModelFileNames = this.getParentModelFileNames();
        List<String> errors = Files.walk(this.pathToRosettaFiles, new FileVisitOption[0]).filter(x -> x.getFileName().toString().endsWith(".rosetta")).filter(x -> !parentModelFileNames.contains(x.getFileName().toString())).map(this::extractNamespace).map(rosettaFileToNamespace -> this.ensureFileNameSuffix(this.modelShortName, (String)rosettaFileToNamespace.left(), (String)rosettaFileToNamespace.right())).flatMap(Collection::stream).collect(Collectors.toList());
        ValidationReport validationReport = new ValidationReport(true, errors);
        if (!errors.isEmpty()) {
            validationReport = new ValidationReport(false, errors);
        }
        return validationReport;
    }

    private Set<String> getParentModelFileNames() throws IOException {
        if (this.parentModelExclusionFile.isPresent()) {
            return Files.walk(this.parentModelExclusionFile.get(), new FileVisitOption[0]).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private List<String> ensureFileNameSuffix(String modelShortName, String rosettaFileName, String rosettaNamespace) {
        ArrayList<String> validationResults = new ArrayList<String>();
        String name = rosettaFileName.substring(0, rosettaFileName.indexOf(".rosetta"));
        String[] parts = name.split("-");
        if (parts.length == 1) {
            validationResults.add("\n No suffix for file '" + rosettaFileName + "' with namespace '" + rosettaNamespace + "'. Should be one of " + VALID_SUFFIX + ". ");
        } else {
            String suffix = parts[parts.length - 1];
            if (!VALID_SUFFIX.contains(suffix)) {
                validationResults.add("\n Suffix for file '" + rosettaFileName + "' with namespace '" + rosettaNamespace + "'. Should be one of " + VALID_SUFFIX + ". ");
            }
        }
        String fileWithoutSuffix = modelShortName + "." + String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, parts.length - 1));
        if (null == rosettaNamespace) {
            validationResults.add("\n File name '" + rosettaFileName + "' is not in line with namespace '" + rosettaNamespace + "'. Namespace should be '" + fileWithoutSuffix + "'. ");
        } else {
            if (!modelShortName.equals(rosettaNamespace.split("\\.")[0])) {
                validationResults.add("\n File '" + rosettaFileName + "' with namespace '" + rosettaNamespace + "'. Namespace should start with model name '" + modelShortName + "'. ");
            }
            if (!rosettaNamespace.equals(fileWithoutSuffix)) {
                validationResults.add("\n File name '" + rosettaFileName + "' is not in line with namespace '" + rosettaNamespace + "'. Namespace should be '" + fileWithoutSuffix + "'. ");
            }
        }
        return validationResults;
    }

    private Pair<String, String> extractNamespace(Path rosettaFile) {
        try {
            return Files.readAllLines(rosettaFile).stream().filter(line -> line.contains("namespace")).map(line -> this.extractNamespaceFromLine(rosettaFile, (String)line)).findFirst().orElseThrow(() -> new RuntimeException("Could not find namespace for " + rosettaFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Pair<String, String> extractNamespaceFromLine(Path rosettaFile, String line) {
        Pattern pattern = Pattern.compile("^namespace ([a-zA-Z0-9_\\.]*)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 1) {
            return Pair.of((Object)rosettaFile.getFileName().toString(), (Object)matcher.group(1));
        }
        return Pair.of((Object)rosettaFile.getFileName().toString(), null);
    }
}

