/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml.deserialization;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMapLoader;
import com.regnosys.rosetta.common.serialisation.xml.deserialization.SubstitutedMethodProperty;
import java.util.ArrayList;

public class RosettaBeanDeserializerModifier
extends BeanDeserializerModifier {
    private final SubstitutionMapLoader substitutionMapLoader;

    public RosettaBeanDeserializerModifier(SubstitutionMapLoader substitutionMapLoader) {
        this.substitutionMapLoader = substitutionMapLoader;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        ArrayList propNames = new ArrayList();
        builder.getProperties().forEachRemaining(p -> propNames.add(p.getFullName()));
        for (PropertyName propName : propNames) {
            SettableBeanProperty prop = builder.findProperty(propName);
            AnnotatedMember acc = prop.getMember();
            SubstitutionMap substitutionMap = this.substitutionMapLoader.findSubstitutionMap((MapperConfig<?>)config, intr, acc);
            if (substitutionMap == null) continue;
            for (JavaType substitutedType : substitutionMap.getTypes()) {
                String substitutedName = substitutionMap.getName(substitutedType);
                SettableBeanProperty substitutedProperty = new SubstitutedMethodProperty((MethodProperty)prop, substitutedType, (AnnotatedMethod)acc).withSimpleName(substitutedName);
                builder.addOrReplaceProperty(substitutedProperty, true);
            }
        }
        return builder;
    }
}

