/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.regnosys.rosetta.common.hashing.RosettaBasicTypesHashGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public class IntegerHashGenerator
extends RosettaBasicTypesHashGenerator<Integer> {
    @Override
    Integer handle(String string) {
        char[] value = string.toCharArray();
        int h = 0;
        int length = value.length;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + value[i];
        }
        return h;
    }

    @Override
    Integer handle(Integer integer) {
        return integer;
    }

    @Override
    Integer handle(LocalDate localDate) {
        int yearValue = localDate.getYear();
        int monthValue = localDate.getMonthValue();
        int dayValue = localDate.getDayOfMonth();
        return yearValue & 0xFFFFF800 ^ (yearValue << 11) + (monthValue << 6) + dayValue;
    }

    @Override
    Integer handle(LocalTime localTime) {
        long nod = localTime.toNanoOfDay();
        return (int)(nod ^ nod >>> 32);
    }

    @Override
    Integer handle(LocalDateTime localDateTime) {
        return this.handle(localDateTime.toLocalDate()) ^ this.handle(localDateTime.toLocalTime());
    }

    @Override
    Integer handle(ZonedDateTime zonedDateTime) {
        return this.handle(zonedDateTime.toLocalDateTime()) ^ zonedDateTime.getOffset().getTotalSeconds() ^ this.handle(zonedDateTime.getZone().getId());
    }

    @Override
    Integer handle(BigDecimal bigDecimal) {
        return this.handle(bigDecimal.stripTrailingZeros().toPlainString());
    }

    @Override
    Integer handle(Boolean bool) {
        return bool != false ? 1231 : 1237;
    }

    @Override
    Integer handle(Enum<?> e) {
        return this.handle(e.name());
    }
}

