/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.mixin.legacy;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.google.common.collect.Sets;
import com.regnosys.rosetta.common.serialisation.BeanUtil;
import com.regnosys.rosetta.common.serialisation.RosettaSerialiserException;
import com.regnosys.rosetta.common.util.StringExtensions;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class LegacyRosettaBuilderIntrospector {
    public Optional<Class<?>> findPOJOBuilder(AnnotatedClass ac) {
        Class rawClass;
        JavaType type = ac.getType();
        if (null != type && RosettaModelObject.class.isAssignableFrom(rawClass = type.getRawClass())) {
            try {
                String builderName = null;
                builderName = rawClass.getName().endsWith("BuilderImpl") ? rawClass.getName() : (rawClass.getName().endsWith("Builder") ? rawClass.getName() + "Impl" : (rawClass.getName().endsWith("Impl") ? rawClass.getName().replaceAll("Impl$", "BuilderImpl") : rawClass.getTypeName() + "$" + rawClass.getSimpleName() + "BuilderImpl"));
                return Optional.of(Class.forName(builderName, true, rawClass.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new RosettaSerialiserException("Could not find the builder class for " + rawClass, e);
            }
        }
        return Optional.empty();
    }

    public Optional<PropertyName> findNameForDeserialization(Annotated a) {
        AnnotatedMethod am;
        if (a instanceof AnnotatedMethod && (am = (AnnotatedMethod)a).getParameterCount() == 1 && am.getName().startsWith("set") && RosettaModelObject.class.isAssignableFrom(am.getDeclaringClass())) {
            String firstLower = StringExtensions.toFirstLower(am.getName().substring(3));
            if (firstLower.equals("key") && GlobalKeyFields.class.isAssignableFrom(am.getDeclaringClass())) {
                firstLower = "location";
            }
            if (firstLower.equals("reference") && ReferenceWithMeta.class.isAssignableFrom(am.getDeclaringClass())) {
                firstLower = "address";
            }
            return Optional.of(new PropertyName(firstLower));
        }
        return Optional.empty();
    }

    public Optional<JsonIgnoreProperties.Value> findPropertyIgnorals(Annotated ac) {
        AnnotatedMethod am;
        String propertyName;
        if (ac instanceof AnnotatedClass) {
            AnnotatedClass acc = (AnnotatedClass)ac;
            Set<Object> names = null;
            names = RosettaModelObject.class.isAssignableFrom(ac.getRawType()) ? StreamSupport.stream(acc.memberMethods().spliterator(), false).map(m -> BeanUtil.getPropertyName(m.getAnnotated())).filter(Objects::nonNull).filter(n -> n.startsWith("orCreate") || n.startsWith("type") || n.startsWith("valueType")).collect(Collectors.toSet()) : Sets.newHashSet();
            return Optional.of(JsonIgnoreProperties.Value.forIgnoredProperties((Set)names).withAllowSetters());
        }
        if (ac instanceof AnnotatedMethod && (propertyName = BeanUtil.getPropertyName((am = (AnnotatedMethod)ac).getAnnotated())) != null && propertyName.startsWith("orCreate")) {
            return Optional.of(JsonIgnoreProperties.Value.forIgnoredProperties((String[])new String[]{propertyName}).withAllowSetters());
        }
        return Optional.empty();
    }
}

