/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.merging;

import com.regnosys.rosetta.common.util.RosettaModelObjectSupplier;
import com.regnosys.rosetta.common.util.SimpleBuilderProcessor;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.Templatable;
import com.rosetta.model.lib.meta.TemplateFields;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.PostProcessStep;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTemplateProcessStep
implements PostProcessStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeTemplateProcessStep.class);
    private final BuilderMerger merger;
    private final RosettaModelObjectSupplier templateSupplier;
    private final Consumer<RosettaModelObjectBuilder> postProcessor;

    public MergeTemplateProcessStep(BuilderMerger merger, RosettaModelObjectSupplier templateSupplier, Consumer<RosettaModelObjectBuilder> postProcessor) {
        this.merger = merger;
        this.templateSupplier = templateSupplier;
        this.postProcessor = postProcessor;
    }

    public Integer getPriority() {
        return 1;
    }

    public String getName() {
        return "Merge Template Post Processor";
    }

    public <T extends RosettaModelObject> PostProcessorReport runProcessStep(Class<? extends T> topClass, T instance) {
        MergeTemplateBuilderProcessor process = new MergeTemplateBuilderProcessor();
        RosettaPath path = RosettaPath.valueOf((String)instance.getType().getSimpleName());
        RosettaModelObjectBuilder builder = instance.toBuilder();
        process.processRosetta(path, topClass, builder, null, new AttributeMeta[0]);
        builder.process(path, (BuilderProcessor)process);
        builder.prune();
        Optional.ofNullable(this.postProcessor).ifPresent(p -> p.accept(builder));
        return null;
    }

    private class MergeTemplateBuilderProcessor
    extends SimpleBuilderProcessor {
        private MergeTemplateBuilderProcessor() {
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            if (builder == null || !builder.hasData()) {
                return false;
            }
            this.getTemplateGlobalReference(builder).flatMap(templateRef -> MergeTemplateProcessStep.this.templateSupplier.get(rosettaType, (String)templateRef)).ifPresent(template -> {
                LOGGER.info("Merging {} template with {}", (Object)rosettaType.getSimpleName(), (Object)MergeTemplateProcessStep.this.merger.getClass().getSimpleName());
                MergeTemplateProcessStep.this.merger.run(builder, template.toBuilder());
            });
            return true;
        }

        public BuilderProcessor.Report report() {
            return null;
        }

        private Optional<String> getTemplateGlobalReference(RosettaModelObjectBuilder builder) {
            return Optional.of(builder).filter(Templatable.TemplatableBuilder.class::isInstance).map(Templatable.TemplatableBuilder.class::cast).map(Templatable.TemplatableBuilder::getMeta).map(TemplateFields::getTemplateGlobalReference);
        }
    }
}

