/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import java.util.function.Function;

public enum TransformType {
    PRE_TRANSLATE("ingest/pre"),
    TRANSLATE("ingest", null),
    TRANSLATE_1_5("ingestions", null),
    POST_TRANSLATE("ingest/post"),
    PRE_ENRICH("enrich/pre"),
    ENRICH("enrich", null),
    POST_ENRICH("enrich/post"),
    PRE_REPORT("regulatory-reporting/pre", "reports.%sReportTabulator", TransformType.stripReportFunctionName()),
    REPORT("regulatory-reporting", "reports.%sReportTabulator", TransformType.stripReportFunctionName()),
    POST_REPORT("regulatory-reporting/post", "reports.%sReportTabulator", TransformType.stripReportFunctionName()),
    PRE_PROJECTION("projection/pre", "projections.%sProjectionTabulator"),
    PROJECTION("projection", "projections.%sProjectionTabulator"),
    POST_PROJECTION("projection/post", "projections.%sProjectionTabulator");

    private final String resourcePath;
    private final String tabulatorName;
    private final Function<String, String> transformFunctionName;

    private TransformType(String resourcePath) {
        this.resourcePath = resourcePath;
        this.tabulatorName = "%sTabulator";
        this.transformFunctionName = Function.identity();
    }

    private TransformType(String resourcePath, String tabulatorName) {
        this.resourcePath = resourcePath;
        this.tabulatorName = tabulatorName;
        this.transformFunctionName = Function.identity();
    }

    private TransformType(String resourcePath, String tabulatorName, Function<String, String> transformFunctionName) {
        this.resourcePath = resourcePath;
        this.tabulatorName = tabulatorName;
        this.transformFunctionName = transformFunctionName;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    private static Function<String, String> stripReportFunctionName() {
        return functionName -> functionName.replaceAll("ReportFunction$", "");
    }
}

