/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapperCreator;
import com.regnosys.rosetta.common.transform.FunctionNameHelper;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class TestPackUtils {
    public static final Path PROJECTION_PATH = Paths.get(TransformType.PROJECTION.getResourcePath(), new String[0]);
    public static final Path PROJECTION_CONFIG_PATH;
    @Deprecated
    public static final Path PROJECTION_CONFIG_PATH_WITHOUT_ISO20022;
    public static final Path REPORT_CONFIG_PATH;
    public static final Path INGEST_CONFIG_PATH;

    public static TestPackModel createTestPack(String testPackName, TransformType transformType, String modelId, String formattedFunctionName, List<TestPackModel.SampleModel> sampleModels) {
        return new TestPackModel(TestPackUtils.createTestPackId(transformType, formattedFunctionName, testPackName), TestPackUtils.createPipelineId(transformType, modelId, formattedFunctionName), testPackName, sampleModels);
    }

    private static String createTestPackId(TransformType transformType, String formattedFunctionName, String testPackName) {
        return String.format("test-pack-%s-%s-%s", transformType.name().toLowerCase(), formattedFunctionName, testPackName.replace(" ", "-")).toLowerCase();
    }

    public static String createPipelineId(TransformType transformType, String modelId, String functionQualifiedName) {
        FunctionNameHelper functionNameHelper = new FunctionNameHelper();
        String formattedFunctionName = functionNameHelper.readableId(functionQualifiedName);
        return String.format("pipeline-%s%s-%s", transformType.name(), Optional.ofNullable(modelId).map(m -> "-" + m).orElse(""), formattedFunctionName).toLowerCase();
    }

    public static PipelineModel createPipeline(TransformType transformType, String functionQualifiedName, String displayName, String inputType, String outputType, String upstreamPipelineId, PipelineModel.Serialisation inputSerialisation, PipelineModel.Serialisation outputSerialisation, String modelId) {
        String pipelineId = TestPackUtils.createPipelineId(transformType, modelId, functionQualifiedName);
        PipelineModel.Transform transform = new PipelineModel.Transform(transformType, functionQualifiedName, inputType, outputType);
        return new PipelineModel(pipelineId, displayName, transform, upstreamPipelineId, inputSerialisation, outputSerialisation, modelId);
    }

    public static List<PipelineModel> getPipelineModels(Path resourcePath, ClassLoader classLoader, ObjectMapper jsonObjectMapper) {
        List<URL> pipelineFiles = TestPackUtils.findPaths(resourcePath, classLoader, "pipeline-.*\\.json");
        return pipelineFiles.stream().map(url -> TestPackUtils.readFile(url, jsonObjectMapper, PipelineModel.class)).collect(Collectors.toList());
    }

    public static PipelineModel getPipelineModel(List<PipelineModel> pipelineModels, String functionName) {
        return TestPackUtils.getPipelineModel(pipelineModels, functionName, null);
    }

    public static List<PipelineModel> getPipelineModels(List<PipelineModel> pipelineModels, String functionName) {
        return pipelineModels.stream().filter(p -> p.getTransform().getFunction().equals(functionName)).collect(Collectors.toList());
    }

    public static PipelineModel getPipelineModel(List<PipelineModel> pipelineModels, String functionName, String modelId) {
        List<PipelineModel> pipelineModelsFunctionName = TestPackUtils.getPipelineModels(pipelineModels, functionName);
        if (pipelineModelsFunctionName.isEmpty()) {
            throw new IllegalArgumentException(String.format("No PipelineModel found with function name %s", functionName));
        }
        return TestPackUtils.findPipelineModel(pipelineModelsFunctionName, modelId).orElseGet(() -> TestPackUtils.getOnlyPipelineModel(pipelineModelsFunctionName).orElse(null));
    }

    private static Optional<PipelineModel> findPipelineModel(List<PipelineModel> pipelineModels, String modelId) {
        List<PipelineModel> filteredPipelineModels = pipelineModels.stream().filter(p -> modelId != null && modelId.equals(p.getModelId()) || modelId == null && p.getModelId() == null).collect(Collectors.toList());
        return TestPackUtils.getOnlyPipelineModel(filteredPipelineModels);
    }

    private static Optional<PipelineModel> getOnlyPipelineModel(List<PipelineModel> filteredPipelineModels) {
        if (filteredPipelineModels.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple PipelineModels found. IDs: %s", filteredPipelineModels.stream().map(PipelineModel::getId).collect(Collectors.joining(", "))));
        }
        if (filteredPipelineModels.size() == 1) {
            return Optional.of(filteredPipelineModels.get(0));
        }
        return Optional.empty();
    }

    public static List<TestPackModel> getTestPackModels(Path resourcePath, ClassLoader classLoader, ObjectMapper jsonObjectMapper) {
        List<URL> testPackUrls = TestPackUtils.findPaths(resourcePath, classLoader, "test-pack-.*\\.json");
        return testPackUrls.stream().map(url -> TestPackUtils.readFile(url, jsonObjectMapper, TestPackModel.class)).collect(Collectors.toList());
    }

    public static List<TestPackModel> getTestPackModels(List<TestPackModel> testPackModels, String pipelineId) {
        return testPackModels.stream().filter(testPackModel -> testPackModel.getPipelineId() != null).filter(testPackModel -> testPackModel.getPipelineId().equals(pipelineId)).collect(Collectors.toList());
    }

    public static Optional<ObjectMapper> getObjectMapper(PipelineModel.Serialisation serialisation) {
        if (serialisation != null && serialisation.getFormat() == PipelineModel.Serialisation.Format.XML) {
            Optional<ObjectMapper> optional;
            block9: {
                URL xmlConfigPath = Objects.requireNonNull(Resources.getResource((String)serialisation.getConfigPath()));
                InputStream inputStream = xmlConfigPath.openStream();
                try {
                    optional = Optional.of(RosettaObjectMapperCreator.forXML(inputStream).create());
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<ObjectWriter> getObjectWriter(PipelineModel.Serialisation serialisation) {
        return TestPackUtils.getObjectMapper(serialisation).map(ObjectMapper::writerWithDefaultPrettyPrinter);
    }

    public static String getReportTestPackName(String reportId) {
        return "test-pack-report-" + reportId + ".*\\.json";
    }

    public static List<URL> findPaths(Path basePath, ClassLoader classLoader, String fileName) {
        List expectations = ClassPathUtils.findPathsFromClassPath(Collections.singletonList(UrlUtils.toPortableString(basePath)), fileName, Optional.empty(), classLoader).stream().map(UrlUtils::toUrl).collect(Collectors.toList());
        return ImmutableList.copyOf(expectations);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readFile(URL u, ObjectMapper mapper, Class<T> clazz) {
        try (Reader src = UrlUtils.openURL(u);){
            Object object = mapper.readValue(src, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read url %s", u), e);
        }
    }

    public static PipelineModel.Serialisation getSerialisation(String xmlConfigPath) {
        return xmlConfigPath == null ? null : new PipelineModel.Serialisation(PipelineModel.Serialisation.Format.XML, xmlConfigPath);
    }

    static {
        PROJECTION_CONFIG_PATH_WITHOUT_ISO20022 = PROJECTION_CONFIG_PATH = PROJECTION_PATH.resolve("config");
        REPORT_CONFIG_PATH = Paths.get(TransformType.REPORT.getResourcePath(), new String[0]).resolve("config");
        INGEST_CONFIG_PATH = Paths.get(TransformType.TRANSLATE.getResourcePath(), new String[0]).resolve("config");
    }
}

