/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml.serialization;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMapLoader;
import com.regnosys.rosetta.common.serialisation.xml.serialization.RosettaBeanSerializer;
import com.regnosys.rosetta.common.serialisation.xml.serialization.SubstitutingBeanPropertyWriter;
import java.util.List;

public class RosettaBeanSerializerModifier
extends BeanSerializerModifier {
    private final SubstitutionMapLoader substitutionMapLoader;

    public RosettaBeanSerializerModifier(SubstitutionMapLoader substitutionMapLoader) {
        this.substitutionMapLoader = substitutionMapLoader;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int len = beanProperties.size();
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = beanProperties.get(i);
            AnnotatedMember member = bpw.getMember();
            SubstitutionMap substitutionMap = this.substitutionMapLoader.findSubstitutionMap((MapperConfig<?>)config, intr, member);
            if (substitutionMap == null) continue;
            beanProperties.set(i, new SubstitutingBeanPropertyWriter(bpw, substitutionMap));
        }
        return beanProperties;
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (!(serializer instanceof XmlBeanSerializer)) {
            return serializer;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        return new RosettaBeanSerializer((XmlBeanSerializer)serializer, null);
    }
}

