/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public abstract class RosettaBasicTypesHashGenerator<T> {
    public <U> T generate(U object) {
        if (object instanceof String) {
            return this.handle((String)object);
        }
        if (object instanceof Integer) {
            return this.handle((Integer)object);
        }
        if (object instanceof LocalDate) {
            return this.handle((LocalDate)object);
        }
        if (object instanceof Date) {
            return this.handle(((Date)object).toLocalDate());
        }
        if (object instanceof LocalTime) {
            return this.handle((LocalTime)object);
        }
        if (object instanceof LocalDateTime) {
            return this.handle((LocalDateTime)object);
        }
        if (object instanceof ZonedDateTime) {
            return this.handle((ZonedDateTime)object);
        }
        if (object instanceof BigDecimal) {
            return this.handle((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return this.handle((Boolean)object);
        }
        if (object instanceof Enum) {
            return this.handle((Enum)object);
        }
        throw new IllegalArgumentException("Unsupported type: " + object.getClass());
    }

    abstract T handle(String var1);

    abstract T handle(Integer var1);

    abstract T handle(LocalDate var1);

    abstract T handle(LocalTime var1);

    abstract T handle(LocalDateTime var1);

    abstract T handle(ZonedDateTime var1);

    abstract T handle(BigDecimal var1);

    abstract T handle(Boolean var1);

    abstract T handle(Enum<?> var1);
}

