/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.mixin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.regnosys.rosetta.common.serialisation.BackwardsCompatibleAnnotationIntrospector;
import com.regnosys.rosetta.common.serialisation.BeanUtil;
import com.regnosys.rosetta.common.serialisation.mixin.EnumAsStringBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.mixin.RosettaEnumBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.mixin.legacy.LegacyRosettaBuilderIntrospector;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RosettaJSONAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements BackwardsCompatibleAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private final LegacyRosettaBuilderIntrospector legacyRosettaBuilderIntrospector;
    private final EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector;
    private final RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector;

    public RosettaJSONAnnotationIntrospector(boolean supportRosettaEnumValue) {
        this(new LegacyRosettaBuilderIntrospector(), new EnumAsStringBuilderIntrospector(), new RosettaEnumBuilderIntrospector(supportRosettaEnumValue));
    }

    public RosettaJSONAnnotationIntrospector(LegacyRosettaBuilderIntrospector legacyRosettaBuilderIntrospector, EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector, RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector) {
        this.legacyRosettaBuilderIntrospector = legacyRosettaBuilderIntrospector;
        this.rosettaEnumBuilderIntrospector = rosettaEnumBuilderIntrospector;
        this.enumAsStringBuilderIntrospector = enumAsStringBuilderIntrospector;
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).builder();
        }
        return this.legacyRosettaBuilderIntrospector.findPOJOBuilder(ac).orElse(super.findPOJOBuilder(ac));
    }

    public PropertyName findNameForSerialization(Annotated a) {
        if (a.hasAnnotation(RosettaAttribute.class)) {
            return new PropertyName(((RosettaAttribute)a.getAnnotation(RosettaAttribute.class)).value());
        }
        return super.findNameForSerialization(a);
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        if (a.hasAnnotation(RosettaAttribute.class)) {
            return new PropertyName(((RosettaAttribute)a.getAnnotation(RosettaAttribute.class)).value());
        }
        return this.legacyRosettaBuilderIntrospector.findNameForDeserialization(a).orElse(super.findNameForDeserialization(a));
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        } else {
            this.enumAsStringBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        }
        return names;
    }

    public void findEnumAliases(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumAliases(enumType, enumValues, aliasList);
        } else {
            super.findEnumAliases(config, enumType, (Enum[])enumValues, aliasList);
        }
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated ann) {
        return this.findPropertyIgnorals(ann);
    }

    @Deprecated
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated ac) {
        if (ac instanceof AnnotatedClass && ac.hasAnnotation(RosettaDataType.class)) {
            AnnotatedClass acc = (AnnotatedClass)ac;
            Set<String> includes = RosettaJSONAnnotationIntrospector.getPropertyNames(acc, x -> x.hasAnnotation(RosettaAttribute.class));
            Set<String> ignored = RosettaJSONAnnotationIntrospector.getPropertyNames(acc, x -> !x.hasAnnotation(RosettaAttribute.class));
            ignored.removeAll(includes);
            return JsonIgnoreProperties.Value.forIgnoredProperties(ignored).withAllowSetters();
        }
        return this.legacyRosettaBuilderIntrospector.findPropertyIgnorals(ac).orElse(JsonIgnoreProperties.Value.empty());
    }

    private static Set<String> getPropertyNames(AnnotatedClass acc, Predicate<AnnotatedMethod> filter) {
        return StreamSupport.stream(acc.memberMethods().spliterator(), false).filter(filter).map(m -> BeanUtil.getPropertyName(m.getAnnotated())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Version version() {
        return Version.unknownVersion();
    }
}

