/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.regnosys.rosetta.common.serialisation.ObjectMapperCreator;
import com.regnosys.rosetta.common.serialisation.mixin.ReferenceFilter;
import com.regnosys.rosetta.common.serialisation.mixin.ReferenceWithMetaMixIn;
import com.regnosys.rosetta.common.serialisation.mixin.RosettaDateModule;
import com.regnosys.rosetta.common.serialisation.mixin.RosettaJSONModule;
import com.regnosys.rosetta.common.serialisation.mixin.legacy.LegacyGlobalKeyFieldsMixIn;
import com.regnosys.rosetta.common.serialisation.mixin.legacy.LegacyKeyMixIn;
import com.regnosys.rosetta.common.serialisation.mixin.legacy.LegacyReferenceMixIn;
import com.regnosys.rosetta.common.serialisation.xml.RosettaSerialiserFactory;
import com.regnosys.rosetta.common.serialisation.xml.RosettaXMLModule;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;

public class RosettaObjectMapperCreator
implements ObjectMapperCreator {
    private final Module rosettaModule;
    private final ObjectMapper baseMapper;

    public RosettaObjectMapperCreator(Module rosettaModule, ObjectMapper baseMapper) {
        this.rosettaModule = rosettaModule;
        this.baseMapper = baseMapper;
    }

    public static RosettaObjectMapperCreator forJSON() {
        boolean supportRosettaEnumValue = true;
        ObjectMapper base = new ObjectMapper();
        return new RosettaObjectMapperCreator((Module)new RosettaJSONModule(supportRosettaEnumValue), base);
    }

    public static RosettaObjectMapperCreator forXML(RosettaXMLConfiguration config, ClassLoader classLoader) {
        boolean supportRosettaEnumValue = true;
        XmlMapper baseXML = new XmlMapper((JacksonXmlModule)null);
        baseXML.setSerializerFactory((SerializerFactory)RosettaSerialiserFactory.INSTANCE);
        ObjectMapper base = new XmlMapper.Builder(baseXML).defaultUseWrapper(false).build();
        return new RosettaObjectMapperCreator((Module)new RosettaXMLModule(base, config, supportRosettaEnumValue, classLoader), base);
    }

    public static RosettaObjectMapperCreator forXML(RosettaXMLConfiguration config) {
        return RosettaObjectMapperCreator.forXML(config, RosettaObjectMapperCreator.class.getClassLoader());
    }

    public static RosettaObjectMapperCreator forXML(InputStream configInputStream, ClassLoader classLoader) throws IOException {
        RosettaXMLConfiguration config = RosettaObjectMapperCreator.getRosettaXMLConfiguration(configInputStream);
        return RosettaObjectMapperCreator.forXML(config, classLoader);
    }

    public static RosettaObjectMapperCreator forXML(InputStream configInputStream) throws IOException {
        return RosettaObjectMapperCreator.forXML(configInputStream, RosettaObjectMapperCreator.class.getClassLoader());
    }

    public static RosettaObjectMapperCreator forXML() {
        return RosettaObjectMapperCreator.forXML(new RosettaXMLConfiguration(Collections.emptyMap()), RosettaObjectMapperCreator.class.getClassLoader());
    }

    private static RosettaXMLConfiguration getRosettaXMLConfiguration(InputStream configInputStream) throws IOException {
        ObjectMapper xmlConfigurationMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return (RosettaXMLConfiguration)xmlConfigurationMapper.readValue(configInputStream, RosettaXMLConfiguration.class);
    }

    @Override
    public ObjectMapper create() {
        ObjectMapper mapper = this.baseMapper.registerModule((Module)new GuavaModule()).registerModule((Module)new JodaModule()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new RosettaDateModule()).registerModule(this.rosettaModule).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(SerializationFeature.WRITE_DATES_WITH_CONTEXT_TIME_ZONE, false).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN}).setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter("ReferenceFilter", (SimpleBeanPropertyFilter)new ReferenceFilter())).addMixIn(ReferenceWithMeta.class, ReferenceWithMetaMixIn.class).addMixIn(GlobalKeyFields.class, LegacyGlobalKeyFieldsMixIn.class).addMixIn(Key.class, LegacyKeyMixIn.class).addMixIn(Reference.class, LegacyReferenceMixIn.class).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        return mapper;
    }
}

