/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.regnosys.rosetta.common.model.MemoiseCacheKey;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingMethodInterceptor.class);
    private static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    private final Cache<MemoiseCacheKey, Object> memoiseCache;
    private final Set<String> debugFunctions;

    public CachingMethodInterceptor(CacheBuilder cacheBuilder, Set<String> debugFunctions) {
        this.memoiseCache = cacheBuilder.build();
        this.debugFunctions = debugFunctions;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        MemoiseCacheKey key = MemoiseCacheKey.create(invocation.getMethod().toString(), invocation.getArguments());
        boolean debugLoggingEnabled = this.isDebugLoggingEnabled(invocation);
        Object ifPresent = this.memoiseCache.getIfPresent((Object)key);
        if (ifPresent == null) {
            Object invoked = invocation.proceed();
            CachingMethodInterceptor.log(debugLoggingEnabled, "Executed function", invocation, invoked);
            if (invoked == null) {
                this.memoiseCache.put((Object)key, NULL);
            } else {
                this.memoiseCache.put((Object)key, invoked);
            }
            return invoked;
        }
        CachingMethodInterceptor.log(debugLoggingEnabled, "Cached function", invocation, ifPresent);
        if (ifPresent == NULL) {
            return null;
        }
        return ifPresent;
    }

    private boolean isDebugLoggingEnabled(MethodInvocation invocation) {
        return this.debugFunctions.contains(invocation.getMethod().getDeclaringClass().getSimpleName().toUpperCase());
    }

    private static void log(boolean debugLoggingEnabled, String message, MethodInvocation invocation, Object functionResult) {
        if (debugLoggingEnabled) {
            LOGGER.debug("{} '{}' Inputs[{}] Output[{}]", new Object[]{message, invocation.getMethod().getDeclaringClass().getSimpleName(), invocation.getArguments(), functionResult});
        }
    }
}

