/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.synonymmap.Element;
import java.util.List;
import java.util.stream.Collectors;

public class SynonymValue {
    private final List<Element> synonymPath;
    private final int mapsTo;
    private final boolean isMeta;

    public SynonymValue(List<Element> synonymPath, int mapsTo, boolean isMeta) {
        this.synonymPath = synonymPath;
        this.mapsTo = mapsTo;
        this.isMeta = isMeta;
    }

    public List<Element> getSynonymPath() {
        return this.synonymPath;
    }

    public int getMapsTo() {
        return this.mapsTo;
    }

    public boolean isMeta() {
        return this.isMeta;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isMeta ? 1231 : 1237);
        result = 31 * result + this.mapsTo;
        result = 31 * result + (this.synonymPath == null ? 0 : this.synonymPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymValue other = (SynonymValue)obj;
        if (this.isMeta != other.isMeta) {
            return false;
        }
        if (this.mapsTo != other.mapsTo) {
            return false;
        }
        return !(this.synonymPath == null ? other.synonymPath != null : !this.synonymPath.equals(other.synonymPath));
    }

    public String toString() {
        return "SynonymValue [synonymPath=" + String.valueOf(this.synonymPath) + ", mapsTo=" + this.mapsTo + ", isMeta=" + this.isMeta + "]";
    }

    String toPathString() {
        return this.synonymPath.stream().map(e -> e.getName() + (e.getCardinality() == Cardinality.MULTIPLE ? "*" : "")).collect(Collectors.joining("->"));
    }
}

