/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroup;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroupMapping;
import com.regnosys.rosetta.translate.synonymmap.SynonymCondition;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SynonymMap
implements Comparable<SynonymMap> {
    private final RosettaType rosetta;
    private final SynonymMap superMap;
    private final Multimap<SynonymValue, SynonymCondition> conditionalCaptures;
    private final Map<AttributeGroup, SynonymMap> attributeGroupMap;
    private final Multimap<ExpandedAttribute, RosettaMergeSynonymValue> attributeMergeSynonyms;
    private final Set<Entity> linkedEntities = new HashSet<Entity>();

    public SynonymMap(RosettaType rosetta) {
        this(rosetta, null);
    }

    public SynonymMap() {
        this(null, null);
    }

    public SynonymMap(RosettaType rosetta, SynonymMap superMap) {
        this.rosetta = rosetta;
        this.superMap = superMap;
        this.attributeGroupMap = new LinkedHashMap<AttributeGroup, SynonymMap>();
        this.conditionalCaptures = ArrayListMultimap.create();
        this.attributeMergeSynonyms = HashMultimap.create();
    }

    public RosettaType getRosetta() {
        return this.rosetta;
    }

    public SynonymMap getSuperMap() {
        return this.superMap;
    }

    public List<AttributeGroupMapping> getMappedGroups() {
        return this.attributeGroupMap.entrySet().stream().map(x -> new AttributeGroupMapping((AttributeGroup)x.getKey(), (SynonymMap)x.getValue())).collect(Collectors.toList());
    }

    public Collection<SynonymMap> childMappings() {
        return this.attributeGroupMap.values();
    }

    public void addMappings(Map<AttributeGroup, SynonymMap> mappings) {
        this.attributeGroupMap.putAll(mappings);
    }

    public void addMapping(AttributeGroup group, SynonymMap mapping) {
        this.attributeGroupMap.put(group, mapping);
    }

    public Collection<AttributeGroup> attributeGroups() {
        return this.attributeGroupMap.keySet();
    }

    public Multimap<SynonymValue, SynonymCondition> getConditionalCaptures() {
        return this.conditionalCaptures;
    }

    public Multimap<ExpandedAttribute, RosettaMergeSynonymValue> getMergeSynonyms() {
        return this.attributeMergeSynonyms;
    }

    public Set<Entity> getLinkedEntities() {
        return this.linkedEntities;
    }

    public String toString() {
        return this.toString(new HashSet<String>());
    }

    public String toString(Set<String> alreadyWritten) {
        String name = this.rosettaName();
        if (!alreadyWritten.contains(name)) {
            alreadyWritten.add(name);
            return "SynonymMap [rosetta=" + name + ", map=" + this.attributeGroupMap.entrySet().stream().map(me -> String.valueOf(me.getKey()) + "=" + ((SynonymMap)me.getValue()).toString(alreadyWritten)).map(s -> s.replaceAll("\n", "\n\t")).collect(Collectors.joining(",\n", "\n{", "}")) + "]";
        }
        return name + "...";
    }

    public String rosettaName() {
        return this.rosetta == null ? "Basic" : this.rosetta.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rosetta == null ? 0 : this.rosetta.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymMap other = (SynonymMap)obj;
        return !(this.rosetta == null ? other.rosetta != null : !this.rosetta.equals((Object)other.rosetta));
    }

    @Override
    public int compareTo(SynonymMap o) {
        if (this.rosetta == o.rosetta) {
            return 0;
        }
        if (this.rosetta == null && o.rosetta != null) {
            return -1;
        }
        if (this.rosetta != null && o.rosetta == null) {
            return 1;
        }
        return this.rosetta.getName().compareTo(o.rosetta.getName());
    }

    protected Map<AttributeGroup, SynonymMap> getAttributeGroupMap() {
        return this.attributeGroupMap;
    }

    public List<SynonymMap> getForClass(String className) {
        return this.getForClass(className, new HashSet<SynonymMap>());
    }

    public List<SynonymMap> getForClass(String className, Set<SynonymMap> searched) {
        if (searched.contains(this)) {
            return Collections.emptyList();
        }
        searched.add(this);
        ArrayList<SynonymMap> result = new ArrayList<SynonymMap>();
        if (this.rosetta != null && this.rosetta.getName().equals(className)) {
            result.add(this);
        }
        for (SynonymMap sub : this.attributeGroupMap.values()) {
            result.addAll(sub.getForClass(className, searched));
        }
        return result;
    }

    public Optional<Map.Entry<AttributeGroup, SynonymMap>> getMappingFor(String path) {
        return this.attributeGroupMap.entrySet().stream().filter(e -> ((AttributeGroup)e.getKey()).attsToString().equals(path)).findFirst();
    }

    public boolean isBasic() {
        return this.rosetta == null || this.rosetta instanceof RosettaEnumeration;
    }

    public long hashForGeneration() {
        long result = 0L;
        result = result * 8191L + (long)(this.rosetta == null ? 0 : this.rosetta.getName().hashCode());
        result = result * 8191L + (this.superMap == null ? 0L : this.superMap.hashForGeneration());
        result = result * 8191L + (long)this.conditionalCaptures.hashCode();
        result *= 8191L;
        for (Map.Entry<AttributeGroup, SynonymMap> entry : this.attributeGroupMap.entrySet()) {
            result += entry.getKey().hashForGeneration();
            RosettaType nextType = entry.getValue().getRosetta();
            result += (long)(nextType == null ? 0 : nextType.getName().hashCode());
        }
        return result;
    }
}

