/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.xsd;

import com.codahale.metrics.Timer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.AttributeImpl;
import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.EntityImpl;
import com.regnosys.rosetta.translate.datamodel.ModelParser;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.SimpleType;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class BeansXsdParser
implements ModelParser {
    private Map<Integer, Entity> basicTypes = BeansXsdParser.basicTypes();

    @Override
    public Schema parseModel(URL input) {
        try {
            Timer timer = IngesterGenerator.GENERATOR_METRICS.timer("XSD model parse");
            Timer.Context time = timer.time();
            ArrayList<XmlObject> objectList = new ArrayList<XmlObject>();
            XmlObject object = XmlObject.Factory.parse((Reader)UrlUtils.openURL((URL)input), (XmlOptions)new XmlOptions().setDocumentSourceName(input.toString()));
            objectList.add(object);
            XmlOptions options = new XmlOptions();
            options.setCompileDownloadUrls();
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])objectList.toArray(new XmlObject[0]), (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)options);
            HashMap mappedEntities = new HashMap();
            SchemaGlobalElement[] globalElements = sts.globalElements();
            Map<QName, Collection<SchemaGlobalElement>> substitutions = this.findSubstitutions(globalElements);
            Collection attributes = Arrays.stream(globalElements).map(el -> this.convert((SchemaGlobalElement)el, (Map<SchemaType, Entity>)mappedEntities, globalElements, substitutions)).distinct().collect(Collectors.toList());
            SchemaType[] globalTypes = sts.globalTypes();
            Arrays.stream(globalTypes).forEach(gt -> this.getOrCreateEntity(mappedEntities, globalElements, (SchemaType)gt, substitutions));
            Collection globalEntities = attributes.stream().map(a -> a.getType()).collect(Collectors.toList());
            time.stop();
            return new Schema(attributes, globalEntities);
        }
        catch (IOException | XmlException e) {
            throw new RuntimeException("Error parsing input xsd file", e);
        }
    }

    private Attribute convert(SchemaGlobalElement el, Map<SchemaType, Entity> mappedEntities, SchemaGlobalElement[] globalElements, Map<QName, Collection<SchemaGlobalElement>> substitutions) {
        QName name = el.getName();
        String localName = name.getLocalPart();
        SchemaType type = el.getType();
        Entity entity = this.getOrCreateEntity(mappedEntities, globalElements, type, substitutions);
        Cardinality card = el.getMaxOccurs() == null || el.getMaxOccurs().longValue() <= 1L ? Cardinality.SINGLE : Cardinality.MULTIPLE;
        return new AttributeImpl(localName, card, entity);
    }

    private Entity createEntity(SchemaType type, Map<SchemaType, Entity> mappedEntities, SchemaGlobalElement[] globalElements, Map<QName, Collection<SchemaGlobalElement>> substitutions) {
        QName name;
        Entity parent = null;
        if (!type.isBuiltinType()) {
            parent = this.getOrCreateEntity(mappedEntities, globalElements, type.getBaseType(), substitutions);
        }
        if ((name = type.getName()) == null) {
            name = type.getContainerField().getName();
        }
        NamespaceName ns = new NamespaceName(name.getNamespaceURI(), name.getLocalPart());
        return new EntityImpl(ns, parent, type.getSimpleVariety() == 1);
    }

    private Entity populateEntity(SchemaType type, Map<SchemaType, Entity> mappedEntities, SchemaGlobalElement[] globalElements, Entity entity, Map<QName, Collection<SchemaGlobalElement>> substitutions) {
        SchemaProperty[] attributeProperties;
        SchemaProperty[] elementProperties;
        List<Attribute> attributes = entity.getAttributes();
        if (type.hasElementWildcards()) {
            this.addWildCardAttributes(attributes, type.qnameSetForWildcardElements(), mappedEntities, globalElements, substitutions);
        }
        for (SchemaProperty prop : elementProperties = type.getElementProperties()) {
            Collection<SchemaGlobalElement> subs = substitutions.get(prop.getName());
            if (subs != null) {
                subs.forEach(sge -> attributes.add(this.convert((SchemaGlobalElement)sge, mappedEntities, globalElements, substitutions)));
            }
            attributes.add(this.convert(prop, mappedEntities, globalElements, substitutions));
        }
        for (SchemaProperty att : attributeProperties = type.getAttributeProperties()) {
            attributes.add(this.convert(att, mappedEntities, globalElements, substitutions));
        }
        return entity;
    }

    private Attribute convert(SchemaProperty prop, Map<SchemaType, Entity> mappedEntities, SchemaGlobalElement[] globalElements, Map<QName, Collection<SchemaGlobalElement>> substitutions) {
        String name = prop.getName().getLocalPart();
        Entity type = this.getOrCreateEntity(mappedEntities, globalElements, prop.getType(), substitutions);
        Cardinality card = prop.getMaxOccurs() == null || prop.getMaxOccurs().longValue() > 1L ? Cardinality.MULTIPLE : Cardinality.SINGLE;
        return new AttributeImpl(name, card, type);
    }

    private void addWildCardAttributes(List<Attribute> attributes, QNameSet wildcards, Map<SchemaType, Entity> mappedEntities, SchemaGlobalElement[] globalElements, Map<QName, Collection<SchemaGlobalElement>> substitutions) {
        for (SchemaGlobalElement el : globalElements) {
            if (!wildcards.contains(el.getName())) continue;
            attributes.add(this.convert(el, mappedEntities, globalElements, substitutions));
        }
    }

    private Entity getOrCreateEntity(Map<SchemaType, Entity> mappedEntities, SchemaGlobalElement[] globalElements, SchemaType type, Map<QName, Collection<SchemaGlobalElement>> substitutions) {
        Entity ent = mappedEntities.get(type);
        if (type.isSimpleType()) {
            Integer typeNum = type.getBuiltinTypeCode();
            ent = this.basicTypes.get(typeNum);
        }
        if (ent == null) {
            ent = this.createEntity(type, mappedEntities, globalElements, substitutions);
            mappedEntities.put(type, ent);
            this.populateEntity(type, mappedEntities, globalElements, ent, substitutions);
        }
        return ent;
    }

    private Map<QName, Collection<SchemaGlobalElement>> findSubstitutions(SchemaGlobalElement[] globalElements) {
        List globalElementsWithSubstitutionGroup = Arrays.stream(globalElements).filter(e -> e.substitutionGroup() != null).collect(Collectors.toList());
        ArrayListMultimap substitutionsMultimap = ArrayListMultimap.create();
        globalElementsWithSubstitutionGroup.stream().map(SchemaGlobalElement::substitutionGroup).forEach(arg_0 -> BeansXsdParser.lambda$findSubstitutions$6((Multimap)substitutionsMultimap, arg_0));
        Map substitutionsMap = substitutionsMultimap.asMap();
        globalElementsWithSubstitutionGroup.stream().forEach(arg_0 -> BeansXsdParser.lambda$findSubstitutions$7((Multimap)substitutionsMultimap, arg_0));
        return substitutionsMap;
    }

    private static Map<Integer, Entity> basicTypes() {
        return ImmutableMap.builder().put((Object)12, (Object)SimpleType.stringType("string")).put((Object)3, (Object)SimpleType.booleanType("boolean")).put((Object)4, (Object)SimpleType.stringType("base64Binary")).put((Object)5, (Object)SimpleType.stringType("hexBinary")).put((Object)9, (Object)SimpleType.decimalType("float")).put((Object)11, (Object)SimpleType.decimalType("decimal")).put((Object)10, (Object)SimpleType.decimalType("float")).put((Object)6, (Object)SimpleType.stringType("anyURI")).put((Object)7, (Object)SimpleType.stringType("QName")).put((Object)8, (Object)SimpleType.stringType("NOTATION")).put((Object)13, (Object)SimpleType.stringType("duration")).put((Object)14, (Object)SimpleType.dateTimeType("dateTime")).put((Object)15, (Object)SimpleType.timeType("time")).put((Object)16, (Object)SimpleType.dateType("date")).put((Object)17, (Object)SimpleType.dateType("gYearMonth")).put((Object)18, (Object)SimpleType.dateType("gYear")).put((Object)19, (Object)SimpleType.dateType("gMonthDay")).put((Object)20, (Object)SimpleType.dateType("gDay")).put((Object)21, (Object)SimpleType.dateType("gMonth")).put((Object)22, (Object)SimpleType.intType("integer")).put((Object)30, (Object)SimpleType.intType("positiveInteger")).put((Object)29, (Object)SimpleType.intType("nonNegativeInteger")).put((Object)35, (Object)SimpleType.stringType("normalizedString")).put((Object)36, (Object)SimpleType.stringType("token")).put((Object)40, (Object)SimpleType.stringType("ID")).put((Object)41, (Object)SimpleType.stringType("IDREF")).build();
    }

    private static /* synthetic */ void lambda$findSubstitutions$7(Multimap substitutionsMultimap, SchemaGlobalElement e) {
        substitutionsMultimap.put((Object)e.substitutionGroup().getName(), (Object)e);
    }

    private static /* synthetic */ void lambda$findSubstitutions$6(Multimap substitutionsMultimap, SchemaGlobalElement e) {
        Arrays.stream(e.substitutionGroupMembers()).forEach(qName -> substitutionsMultimap.put(qName, (Object)e));
    }
}

