/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json.schema;

import com.regnosys.rosetta.translate.datamodel.json.schema.JsonSchemaToClasses;
import com.regnosys.rosetta.translate.datamodel.json.schema.JsonSchemaToJavaGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class IsdaCreateJavaGenerator {
    private static final String REGIME = "Regime";
    static final Map<String, String> ENTITY_TYPE_TO_CLASS_MAP = new HashMap<String, String>(){
        {
            this.put("#regime", IsdaCreateJavaGenerator.REGIME);
            this.put("#partyanswers", "PartyAnswers");
        }
    };
    static final Map<String, String> ENTITY_NAME_TO_CLASS_MAP = new HashMap<String, String>(){
        {
            this.put("canada", IsdaCreateJavaGenerator.REGIME);
            this.put("cftc", IsdaCreateJavaGenerator.REGIME);
            this.put("emir", IsdaCreateJavaGenerator.REGIME);
            this.put("japan", IsdaCreateJavaGenerator.REGIME);
            this.put("prudential", IsdaCreateJavaGenerator.REGIME);
            this.put("sec", IsdaCreateJavaGenerator.REGIME);
            this.put("switzerland", IsdaCreateJavaGenerator.REGIME);
            this.put("regimes", "AdditionalRegime");
            this.put("partya", "Party");
            this.put("partyb", "Party");
        }
    };
    static final List<String> SHARED_CLASSES_EXCLUSIONS = Collections.singletonList("Answers");

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(Option.builder((String)"s").longOpt("schemaDir").desc("Schema Directory").hasArg().build());
        options.addOption(Option.builder((String)"c").longOpt("classNamePrefix").desc("class name Prefix").hasArg().build());
        options.addOption(Option.builder((String)"o").longOpt("outputDir").desc("Output Directory").hasArg().build());
        options.addOption(Option.builder((String)"p").longOpt("basePackage").desc("Base Package").hasArg().build());
        CommandLine line = parser.parse(options, args);
        String schemaDir = IsdaCreateJavaGenerator.ensureTrailingChar(line.getOptionValue("s"), '/');
        String classNamePrefix = line.getOptionValue("c");
        String outputDir = IsdaCreateJavaGenerator.ensureTrailingChar(line.getOptionValue("o"), '/');
        String basePackage = IsdaCreateJavaGenerator.ensureTrailingChar(line.getOptionValue("p"), '.');
        List<JsonSchemaToJavaGenerator.GeneratorParam> generatorParams = Arrays.asList(new JsonSchemaToJavaGenerator.GeneratorParam(schemaDir + "2016-im-csd-eng-law-schema-2.3.json", classNamePrefix + "IsdaCsdIm2016EngLaw", basePackage + "isda.csdim2016.englaw"), new JsonSchemaToJavaGenerator.GeneratorParam(schemaDir + "2016-im-csa-jpn-law-schema-1.4.json", classNamePrefix + "IsdaCsaIm2016JpnLaw", basePackage + "isda.csaim2016.jpnlaw"), new JsonSchemaToJavaGenerator.GeneratorParam(schemaDir + "2016-im-csa-ny-law-schema-0.10.json", classNamePrefix + "IsdaCsaIm2016NyLaw", basePackage + "isda.csaim2016.nylaw"));
        JsonSchemaToClasses jsonSchemaToClasses = new JsonSchemaToClasses(ENTITY_TYPE_TO_CLASS_MAP, ENTITY_NAME_TO_CLASS_MAP);
        JsonSchemaToJavaGenerator generator = new JsonSchemaToJavaGenerator(jsonSchemaToClasses, SHARED_CLASSES_EXCLUSIONS);
        generator.generate(generatorParams, outputDir, basePackage + "shared");
    }

    private static String ensureTrailingChar(String s, char c) {
        if (!s.endsWith(String.valueOf(c))) {
            return s + String.valueOf(c);
        }
        return s;
    }
}

