/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.ImmutableList;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.IngestException;
import com.regnosys.rosetta.translate.MatchResult;
import com.regnosys.rosetta.translate.MatchType;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ParserHelper {
    private static final char BOM = '\ufeff';

    static char[] toCharsfromReader(Reader xmlReader) {
        try {
            return ParserHelper.removeBom(IOUtils.toCharArray((Reader)xmlReader));
        }
        catch (IOException e) {
            throw new IngestException("Error reading from file", e);
        }
    }

    static MatchResult getMatchType(Collection<List<String>> matchPaths, Deque<Path.PathElement> path) {
        Path fullMatch = null;
        MatchType matchType = MatchType.NONE;
        for (List<String> possibleMatch : matchPaths) {
            if (path.size() > possibleMatch.size()) continue;
            int i = 0;
            boolean matchSoFar = true;
            for (Path.PathElement pathVal : path) {
                String matchVal;
                if ((matchVal = possibleMatch.get(i++)).equals(pathVal.getPathName())) continue;
                matchSoFar = false;
                break;
            }
            if (!matchSoFar) continue;
            if (path.size() == possibleMatch.size()) {
                matchType = matchType == MatchType.PARTIAL ? MatchType.BOTH : MatchType.FULL;
                fullMatch = new Path((List)ImmutableList.copyOf(path));
                continue;
            }
            if (matchType == MatchType.FULL || matchType == MatchType.BOTH) {
                matchType = MatchType.BOTH;
                continue;
            }
            matchType = MatchType.PARTIAL;
        }
        return new MatchResult(matchType, fullMatch);
    }

    private static char[] removeBom(char[] charArray) {
        if (charArray != null && charArray.length > 0 && charArray[0] == '\ufeff') {
            return Arrays.copyOfRange(charArray, 1, charArray.length);
        }
        return charArray;
    }
}

