/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.MatchResult;
import com.regnosys.rosetta.translate.ParseHandler;
import com.regnosys.rosetta.translate.ParserHelper;
import com.regnosys.rosetta.translate.ROMParseHandler;
import com.regnosys.rosetta.translate.basic.BasicParseHandler;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class HandlerWithPath {
    private final ParseHandler handler;
    private final Deque<Path.PathElement> elementStack = new ArrayDeque<Path.PathElement>();

    HandlerWithPath(ParseHandler handler) {
        this.handler = handler;
    }

    Deque<Path.PathElement> addToStackIfNotNull(Path.PathElement element) {
        if (element != null) {
            this.elementStack.addLast(element);
        }
        return this.elementStack;
    }

    void removeLastIfExists() {
        if (!this.elementStack.isEmpty()) {
            this.elementStack.removeLast();
        }
    }

    boolean isComplexHandler() {
        return this.handler instanceof ROMParseHandler;
    }

    Collection<Map.Entry<RosettaPath, ? extends MappingProcessor>> matchingMappingProcessors(Path parentPath, MappingContext mappingContext) {
        ROMParseHandler parseHandler = (ROMParseHandler)this.handler;
        Collection<List<String>> matchPaths = parseHandler.getMappingProcessorMatchPaths();
        MatchResult matchResult = ParserHelper.getMatchType(matchPaths, this.elementStack);
        switch (matchResult.matchType()) {
            case FULL: 
            case BOTH: {
                return parseHandler.getMappingProcessorForPath(matchResult.fullMatch(), parentPath, mappingContext);
            }
        }
        return Collections.emptyList();
    }

    List<HandlerWithPath> matchingHandlers(Path.PathElement element, Path parentPath) {
        ROMParseHandler parseHandler = (ROMParseHandler)this.handler;
        Deque<Path.PathElement> path = this.addToStackIfNotNull(element);
        Collection<List<String>> matchPaths = parseHandler.getHandlerMatchPaths();
        MatchResult matchResult = ParserHelper.getMatchType(matchPaths, path);
        switch (matchResult.matchType()) {
            case FULL: {
                return this.createHandlersFromMatch(parseHandler, matchResult, parentPath);
            }
            case BOTH: {
                List<HandlerWithPath> handlersFromMatch = this.createHandlersFromMatch(parseHandler, matchResult, parentPath);
                handlersFromMatch.add(this);
                return handlersFromMatch;
            }
            case PARTIAL: {
                return Collections.singletonList(this);
            }
            case NONE: {
                return Collections.emptyList();
            }
        }
        throw new AssertionError((Object)"Invalid MatchResult.MatchType enum");
    }

    static List<Mapping> createMappings(List<HandlerWithPath> handlers, String trimmedVal, Path path) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        Supplier<Boolean> someMultiMap = () -> false;
        for (HandlerWithPath handler : handlers) {
            if (handler.isComplexHandler()) continue;
            handler.createMapping(trimmedVal, path, someMultiMap).ifPresent(mappings::add);
        }
        if (mappings.isEmpty()) {
            mappings.add(new Mapping(path, (Object)trimmedVal, null, null, "Element could not be mapped to a rosettaField", someMultiMap.get().booleanValue(), false, false));
        }
        return mappings;
    }

    private List<HandlerWithPath> createHandlersFromMatch(ROMParseHandler<?> parseHandler, MatchResult matchResult, Path parentPath) {
        Collection<ParseHandler> newHandlers = parseHandler.getHandlersForPath(matchResult.fullMatch(), parentPath);
        List<HandlerWithPath> resultHandlers = newHandlers.stream().map(ph -> new HandlerWithPath((ParseHandler)ph)).collect(Collectors.toList());
        return resultHandlers;
    }

    private Optional<Mapping> createMapping(String value, Path path, Supplier<Boolean> someMultiMap) {
        BasicParseHandler basicHandler = (BasicParseHandler)this.handler;
        if (basicHandler.allowsMultiple()) {
            someMultiMap = () -> true;
        }
        BasicParseHandler.SetResult result = basicHandler.setValue(value);
        switch (result.getStatus()) {
            case DUPLICATE: {
                if (basicHandler.isCondition() && result.getNewValue().equals(result.getOldValue())) {
                    return Optional.empty();
                }
                return Optional.of(new Mapping(path, (Object)value, basicHandler.getRosettaPath(), result.getNewValue(), "Element mapped to already populated field", someMultiMap.get().booleanValue(), basicHandler.isCondition(), true));
            }
            case PARSING: {
                return Optional.of(new Mapping(path, (Object)value, basicHandler.getRosettaPath(), result.getNewValue(), "Element " + value + " could not be parsed as a " + this.handler.getClass().getSimpleName().replace("ParseHandler", ""), someMultiMap.get().booleanValue(), basicHandler.isCondition(), false));
            }
            case MAPPING: {
                return Optional.of(new Mapping(path, (Object)value, basicHandler.getRosettaPath(), result.getNewValue(), "Element " + value + " was not set due to path mapping issues", someMultiMap.get().booleanValue(), basicHandler.isCondition(), false));
            }
            case SUCCESS: {
                return Optional.of(new Mapping(path, (Object)value, basicHandler.getRosettaPath(), result.getNewValue(), null, someMultiMap.get().booleanValue(), basicHandler.isCondition(), false));
            }
        }
        throw new AssertionError((Object)"Invalid BasicParseHandler.SetResult enum");
    }

    public String toString() {
        return "HandlerWithPath [handler=" + String.valueOf(this.handler) + ", xmlPathsToHere=" + String.valueOf(this.handler.getXmlPathsToHere()) + ", rosettaPath=" + String.valueOf(this.handler.getRosettaPath()) + ", elementStack=" + String.valueOf(this.elementStack) + "]";
    }
}

