/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.regnosys.rosetta.common.translation.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GeneratorPathUtil {
    public static boolean anyMatch(Path p, List<Path> paths) {
        return paths.stream().anyMatch(ps -> p.endsWith(ps));
    }

    public static <A> Optional<A> getValueForPath(Map<Path, A> values, Collection<String> paths) {
        return values.entrySet().stream().filter(e -> GeneratorPathUtil.matches((Path)e.getKey(), paths)).map(e -> e.getValue()).findFirst();
    }

    public static <A> Collection<A> getValuesForPathEnding(Map<Path, A> values, List<String> paths) {
        return values.entrySet().stream().filter(e -> GeneratorPathUtil.endsWith((Path)e.getKey(), paths)).map(e -> e.getValue()).collect(Collectors.toList());
    }

    public static boolean matches(Set<Path> paths, Collection<String> path) {
        return path.stream().map(Path::parse).anyMatch(p -> paths.stream().anyMatch(k -> p.nameStartMatches(k)));
    }

    private static boolean matches(Path path, Collection<String> paths) {
        return paths.stream().map(Path::parse).anyMatch(k -> path.nameStartMatches(k));
    }

    public static boolean matches(Path rosettaPath, String matchString) {
        Path matchPath = Path.parse((String)matchString);
        List elements = matchPath.getElements();
        List rElements = rosettaPath.getElements();
        if (rElements.size() < elements.size() - 1) {
            return false;
        }
        for (int i = 1; i < elements.size(); ++i) {
            Path.PathElement rElement = (Path.PathElement)rElements.get(rElements.size() - i);
            Path.PathElement mElement = (Path.PathElement)elements.get(elements.size() - i);
            if (rElement.getPathName().equals(mElement.getPathName())) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(Path rosettaPath, Collection<String> matchStrings) {
        return matchStrings.stream().anyMatch(m -> GeneratorPathUtil.endsWith(rosettaPath, m));
    }

    public static boolean endsWith(Path rosettaPath, String matchString) {
        return GeneratorPathUtil.withoutValue(rosettaPath).endsWith(matchString.split("\\."));
    }

    private static Path withoutValue(Path path) {
        return new Path(path.getElements().stream().filter(e -> !e.getPathName().equals("value")).collect(Collectors.toList()));
    }

    public static boolean sameBranchMatches(Path fullPath, Path nearBranch) {
        int branchPoint;
        for (branchPoint = fullPath.getElements().size() - 1; branchPoint >= 0 && !((Path.PathElement)fullPath.getElements().get(branchPoint)).getPathName().equals(((Path.PathElement)nearBranch.getElements().get(0)).getPathName()); --branchPoint) {
        }
        if (branchPoint < 0) {
            return false;
        }
        int i = 0;
        while (i < nearBranch.getElements().size()) {
            if (i >= fullPath.getElements().size() - branchPoint) {
                return true;
            }
            Path.PathElement fullElement = (Path.PathElement)fullPath.getElements().get(branchPoint + i);
            Path.PathElement branchElement = (Path.PathElement)fullPath.getElements().get(i);
            if (!fullElement.getPathName().equals(branchElement.getPathName())) {
                return true;
            }
            if (!fullElement.getIndex().equals(branchElement.getIndex())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <A> Set<A> getPathMatchingValues(Set<Path> itemPaths, Map<Path, A> valueCache) {
        HashSet<A> result = new HashSet<A>();
        for (Path itemPath : itemPaths) {
            for (Map.Entry<Path, A> entry : valueCache.entrySet()) {
                if (!GeneratorPathUtil.sameBranchMatches(itemPath, entry.getKey())) continue;
                result.add(entry.getValue());
            }
        }
        return result;
    }
}

