/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.service;

import com.codahale.metrics.Timer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.regnosys.ingest.test.framework.ingestor.IngestionParserMapper;
import com.regnosys.ingest.test.framework.ingestor.IngestionReport;
import com.regnosys.ingest.test.framework.ingestor.generic.GenericErrorReport;
import com.regnosys.ingest.test.framework.ingestor.postprocess.PostProcessorRunner;
import com.regnosys.ingest.test.framework.ingestor.postprocess.pathduplicates.PathCollector;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReport;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingResult;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationReport;
import com.regnosys.rosetta.common.postprocess.qualify.QualifyProcessorStep;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaIngestionService
implements IngestionService {
    private static final Logger LOG = LoggerFactory.getLogger(RosettaIngestionService.class);
    private final PostProcessorRunner postProcessorRunner;
    private final IngestionParserMapper ingestionParserMapper;
    private final RosettaTypeValidator rosettaTypeValidator;
    private final String environmentName;

    public RosettaIngestionService(PostProcessorRunner postProcessorRunner, IngestionParserMapper ingestionParserMapper, RosettaTypeValidator rosettaTypeValidator, String environmentName) {
        this.postProcessorRunner = postProcessorRunner;
        this.ingestionParserMapper = ingestionParserMapper;
        this.rosettaTypeValidator = rosettaTypeValidator;
        this.environmentName = environmentName;
    }

    @Override
    public <T extends RosettaModelObject> IngestionReport<T> ingestValidateAndPostProcess(Class<T> rosettaModelClass, Reader reader) {
        RosettaModelObject temp;
        Timer parseAndMapTimer = INGESTION_METRICS.timer("ParseAndMap");
        Timer.Context parseAndMap = parseAndMapTimer.time();
        IngestionParserMapper.ParserMapperResult<T> parsingResult = this.ingestionParserMapper.parseAndMapXml(reader, rosettaModelClass);
        parseAndMap.stop();
        ArrayList<GenericErrorReport.ErrorMessage> genericErrorList = new ArrayList<GenericErrorReport.ErrorMessage>();
        LOG.debug(" {} ", (Object)parsingResult.getMappingReport());
        RosettaModelObjectBuilder rosettaObject = parsingResult.getRosettaObject();
        if (null == rosettaObject) {
            return new IngestionReport<Object>(parsingResult.getMappingReport(), null, new ValidationReport(null, new ArrayList()), new QualificationReport(null, new ArrayList()), parsingResult.getInputValidationReport());
        }
        RosettaModelObject resultObject = null;
        ArrayList postProcessorErrors = new ArrayList();
        PostProcessorReport postProcessRosettaObject = this.postProcess(rosettaModelClass, rosettaObject, postProcessorErrors, genericErrorList);
        resultObject = temp = postProcessRosettaObject.getResultObject().toBuilder().prune().build();
        if (!parsingResult.getInputValidationReport().getErrors().isEmpty() || resultObject == null) {
            RosettaModelObject rosettaModelInstance = rosettaObject.build();
            return new IngestionReport<RosettaModelObject>(parsingResult.getMappingReport(), rosettaModelInstance, new ValidationReport(null, postProcessorErrors), new QualificationReport(rosettaModelInstance, new ArrayList()), parsingResult.getInputValidationReport(), new GenericErrorReport(genericErrorList));
        }
        ValidationReport validationReport = (ValidationReport)this.postProcessorRunner.reportFor(RosettaTypeValidator.class).get();
        validationReport.getValidationResults().addAll(postProcessorErrors);
        QualificationReport qualificationReport = this.getQualificationReport();
        Optional<PostProcessorReport> actualPaths = this.postProcessorRunner.reportFor(PathCollector.class);
        MappingReport findDuplicates = null;
        if (actualPaths.isPresent()) {
            findDuplicates = this.findDuplicates(parsingResult.getMappingReport(), (PathCollector.PathReport)actualPaths.get());
        }
        return new IngestionReport<RosettaModelObject>(findDuplicates, resultObject, validationReport, qualificationReport, parsingResult.getInputValidationReport(), new GenericErrorReport(genericErrorList));
    }

    @Override
    public <T extends RosettaModelObject> IngestionReport<T> ingestAndPostProcessJson(Class<T> rosettaModelClass, Reader reader) {
        Timer parseAndMapTimer = INGESTION_METRICS.timer("ParseAndMap");
        Timer.Context parseAndMap = parseAndMapTimer.time();
        IngestionParserMapper.ParserMapperResult<T> parsingResult = this.ingestionParserMapper.parseAndMapJSON(reader, rosettaModelClass);
        parseAndMap.stop();
        ArrayList<GenericErrorReport.ErrorMessage> genericErrorList = new ArrayList<GenericErrorReport.ErrorMessage>();
        RosettaModelObjectBuilder rosettaObject = parsingResult.getRosettaObject();
        if (null == rosettaObject) {
            return new IngestionReport<Object>(parsingResult.getMappingReport(), null, new ValidationReport(null, new ArrayList()), new QualificationReport(null, new ArrayList()), parsingResult.getInputValidationReport());
        }
        ArrayList postProcessorErrors = new ArrayList();
        PostProcessorReport postProcessRosettaObject = this.postProcess(rosettaModelClass, parsingResult.getRosettaObject(), postProcessorErrors, genericErrorList);
        RosettaModelObject resultObject = postProcessRosettaObject.getResultObject().toBuilder().prune().build();
        if (!parsingResult.getInputValidationReport().getErrors().isEmpty() || resultObject == null) {
            RosettaModelObject rosettaModelInstance = parsingResult.getRosettaObject().build();
            return new IngestionReport<RosettaModelObject>(parsingResult.getMappingReport(), rosettaModelInstance, new ValidationReport(null, postProcessorErrors), new QualificationReport(rosettaModelInstance, new ArrayList()), parsingResult.getInputValidationReport(), new GenericErrorReport(genericErrorList));
        }
        ValidationReport validationReport = (ValidationReport)this.postProcessorRunner.reportFor(RosettaTypeValidator.class).get();
        QualificationReport qualificationReport = this.getQualificationReport();
        Optional<PostProcessorReport> actualPaths = this.postProcessorRunner.reportFor(PathCollector.class);
        MappingReport findDuplicates = null;
        if (actualPaths.isPresent()) {
            findDuplicates = this.findDuplicates(parsingResult.getMappingReport(), (PathCollector.PathReport)actualPaths.get());
        }
        return new IngestionReport<RosettaModelObject>(findDuplicates, resultObject, validationReport, qualificationReport, parsingResult.getInputValidationReport(), new GenericErrorReport(genericErrorList));
    }

    @Override
    public QualificationReport getQualificationReport() {
        return this.postProcessorRunner.reportFor(QualifyProcessorStep.class).orElse(null);
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    private MappingReport findDuplicates(MappingReport mappingReport, PathCollector.PathReport actualPaths) {
        ArrayList<MappingResult> newResults = new ArrayList<MappingResult>();
        RosettaPath.RosettaPathTree actualPathTree = RosettaPath.RosettaPathTree.treeify(actualPaths.getCollectedPaths());
        for (MappingResult oldResult : mappingReport.getMappingResults()) {
            long matchingValues;
            HashMap<RosettaPath, Object> internalPaths = new HashMap<RosettaPath, Object>(oldResult.getInternalPaths());
            Multimap<RosettaPath, Object> newInternalPaths = this.matchPaths(internalPaths, actualPathTree);
            List<Object> issues = oldResult.getIssues();
            MappingResult.Result result = oldResult.getResult();
            boolean success = oldResult.isSuccess();
            if (newInternalPaths.isEmpty() && !oldResult.isCondition()) {
                issues = Collections.singletonList("Element with value " + oldResult.getValue() + " could not be mapped to a rosettaField");
                result = MappingResult.Result.Fail_MappedNone;
                success = false;
            }
            if ((matchingValues = newInternalPaths.values().stream().filter(v -> internalPaths.values().contains(v)).count()) > 1L && !oldResult.allowsMultiple()) {
                issues = new ArrayList<String>(oldResult.getIssues());
                issues.add("Element mapped to multiple rosettaFields");
                result = MappingResult.Result.Fail_MappedMultiple;
                success = false;
            }
            newResults.add(new MappingResult(success, oldResult.getExternalPath(), oldResult.getValue(), this.getInternalPathsSortedValues(newInternalPaths), issues, oldResult.isExcludedExternalPath(), oldResult.allowsMultiple(), oldResult.isCondition(), result));
        }
        return new MappingReport(newResults);
    }

    private Map<RosettaPath, List<Object>> getInternalPathsSortedValues(Multimap<RosettaPath, Object> newInternalPaths) {
        return newInternalPaths.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((Collection)x.getValue()).stream().sorted().collect(Collectors.toList())));
    }

    private Multimap<RosettaPath, Object> matchPaths(Map<RosettaPath, Object> internalPaths, RosettaPath.RosettaPathTree actualPathTree) {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<RosettaPath, Object> entry : internalPaths.entrySet()) {
            List pathMatches = actualPathTree.matches(entry.getKey(), Comparator.comparing(RosettaPath.Element::getPath));
            pathMatches.forEach(arg_0 -> RosettaIngestionService.lambda$matchPaths$2((Multimap)result, entry, arg_0));
        }
        return result;
    }

    @Override
    public <T extends RosettaModelObject> RosettaModelObjectBuilder ingest(Class<T> rosettaModelClass, Reader reader) {
        return this.ingestionParserMapper.parseAndMapXml(reader, rosettaModelClass).getRosettaObject();
    }

    @Override
    public <T extends RosettaModelObject> RosettaModelObjectBuilder ingestJson(Class<T> rosettaModelClass, Reader reader) {
        return this.ingestionParserMapper.parseAndMapJSON(reader, rosettaModelClass).getRosettaObject();
    }

    @Override
    public <T extends RosettaModelObject> PostProcessorReport postProcess(Class<T> rosettaModelClass, RosettaModelObjectBuilder rosettaModelObject, List<ValidationResult<?>> postProcessorErrors, List<GenericErrorReport.ErrorMessage> genericErrors) {
        RosettaModelObjectBuilder result = this.postProcessorRunner.postProcess(rosettaModelClass, rosettaModelObject, postProcessorErrors, genericErrors);
        return new PostProcessorReportImpl(result);
    }

    @Override
    public <T extends RosettaModelObject> ValidationReport validate(T rosettaModelObject) {
        return this.rosettaTypeValidator.runProcessStep(rosettaModelObject.getClass(), (RosettaModelObject)rosettaModelObject.toBuilder());
    }

    private static /* synthetic */ void lambda$matchPaths$2(Multimap result, Map.Entry entry, RosettaPath.RosettaPathTree p) {
        result.put((Object)((RosettaPath)entry.getKey()), p.getValue());
    }

    public static class PostProcessorReportImpl<T extends RosettaModelObject>
    implements PostProcessorReport {
        private RosettaModelObjectBuilder result;

        public PostProcessorReportImpl(RosettaModelObjectBuilder result) {
            this.result = result;
        }

        public RosettaModelObjectBuilder getResultObject() {
            return this.result;
        }
    }
}

