/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.service;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.ingest.test.framework.ingestor.GeneratedIngestionParserMapper;
import com.regnosys.ingest.test.framework.ingestor.postprocess.PostProcessorRunner;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.regnosys.ingest.test.framework.ingestor.service.RosettaIngestionService;
import com.regnosys.ingest.test.framework.ingestor.service.TranslatorOptionsFactory;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.translate.HandlerFactory;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.SynonymToEnumMapGenerator;
import com.regnosys.rosetta.translate.Translator;
import com.regnosys.rosetta.translate.TranslatorOptions;
import com.rosetta.model.lib.process.PostProcessStep;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IngestionFactory.class);
    private static final String DEFAULT_INSTANCE_NAME = "target/DEFAULT";
    private static final ConcurrentHashMap<String, IngestionFactory> INSTANCES = new ConcurrentHashMap();
    private final String instanceName;
    private final RosettaTypeValidator validatorPostProcessor;
    private final PostProcessStep[] postProcessors;
    private final ConcurrentHashMap<String, IngestionService> services = new ConcurrentHashMap();
    private final ClassLoader classLoader;
    private final TranslatorOptionsFactory translatorOptionsFactory;
    private final Module modelRuntimeModel;

    public static synchronized void init(Module modelRuntimeModel, PostProcessStep ... postProcessors) {
        INSTANCES.computeIfAbsent(DEFAULT_INSTANCE_NAME, name -> new IngestionFactory((String)name, IngestionFactory.class.getClassLoader(), modelRuntimeModel, postProcessors));
    }

    public static synchronized void init(String instanceName, ClassLoader classLoader, Module modelRuntimeModel, PostProcessStep ... postProcessors) {
        INSTANCES.computeIfAbsent(instanceName, name -> new IngestionFactory((String)name, classLoader, modelRuntimeModel, postProcessors));
    }

    public static void init(Collection<URL> envFiles, Module modelRuntimeModel, PostProcessStep[] postProcessors) {
        INSTANCES.computeIfAbsent(DEFAULT_INSTANCE_NAME, name -> new IngestionFactory((String)name, IngestionFactory.class.getClassLoader(), envFiles, modelRuntimeModel, postProcessors));
    }

    public static void init(String instanceName, Collection<URL> envFiles, Module modelRuntimeModel, PostProcessStep[] postProcessors) {
        INSTANCES.computeIfAbsent(instanceName, name -> new IngestionFactory((String)name, IngestionFactory.class.getClassLoader(), envFiles, modelRuntimeModel, postProcessors));
    }

    public IngestionFactory(String instanceName, ClassLoader classLoader, Module modelRuntimeModel, PostProcessStep ... postProcessors) {
        this(instanceName, classLoader, TranslatorOptionsFactory.getDefaultIngestionResource(classLoader), modelRuntimeModel, postProcessors);
    }

    public IngestionFactory(String instanceName, ClassLoader classLoader, Collection<URL> ingestionEnvs, Module modelRuntimeModel, PostProcessStep ... postProcessors) {
        this.validatorPostProcessor = IngestionFactory.getProcessStep(postProcessors, RosettaTypeValidator.class);
        this.postProcessors = postProcessors;
        this.instanceName = instanceName;
        this.classLoader = classLoader;
        this.translatorOptionsFactory = new TranslatorOptionsFactory(ingestionEnvs);
        this.modelRuntimeModel = modelRuntimeModel;
    }

    public static IngestionFactory getInstance() {
        IngestionFactory factory = INSTANCES.get(DEFAULT_INSTANCE_NAME);
        if (null == factory) {
            throw new IllegalStateException("IngestionFactory.init must be called before you try to use the IngestionFactory");
        }
        return factory;
    }

    public static IngestionFactory getInstance(String name) {
        IngestionFactory factory = INSTANCES.get(name);
        if (null == factory) {
            throw new IllegalStateException("IngestionFactory.init must be called before you try to use the IngestionFactory");
        }
        return factory;
    }

    public void initServices(ExecutorService executorService) {
        executorService.execute(this::getFpml5ConfirmationToTradeState);
        executorService.execute(this::getDtcc11);
        executorService.execute(this::getDtcc9);
        executorService.execute(this::getCmeCleared117);
        executorService.execute(this::getCmeSubmissionIrs1);
        executorService.execute(this::getFis);
    }

    public IngestionService getFpml5ConfirmationToTradeState() {
        String envName = "FpML_5_Confirmation_To_TradeState";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getFpml5ConfirmationToWorkflowStep() {
        String envName = "FpML_5_Confirmation_To_WorkflowStep";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getFpml5RecordKeepingToReportableEvent() {
        String envName = "FpML_5_RecordKeeping_To_ReportableEvent";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getDtcc11() {
        String envName = "DTCC_11_0";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getDtcc9() {
        String envName = "DTCC_9_0";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getCmeCleared117() {
        String envName = "CME_ClearedConfirm_1_17";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getCmeSubmissionIrs1() {
        String envName = "CME_SubmissionIRS_1_0";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getOre1039() {
        String envName = "ORE_1_0_39";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService getFis() {
        String envName = "FIS_TRADE";
        TranslatorOptions env = this.translatorOptionsFactory.getTranslatorOptions(envName);
        return this.registerService(envName, env);
    }

    public IngestionService registerService(String serviceName, TranslatorOptions translatorOptions) {
        return this.services.computeIfAbsent(serviceName, schema -> this.createService((String)schema, translatorOptions));
    }

    public IngestionService getService(String serviceName) {
        return this.services.computeIfAbsent(serviceName, n -> this.createService((String)n, this.translatorOptionsFactory.getTranslatorOptions((String)n)));
    }

    public TranslatorOptions getTranslateOptions(String serviceName) {
        return this.translatorOptionsFactory.getTranslatorOptions(serviceName);
    }

    public synchronized void clear() {
        this.services.clear();
        INSTANCES.clear();
    }

    private IngestionService createService(String serviceName, TranslatorOptions translatorOptions) {
        try {
            LOG.debug("Using classloader {}", (Object)this.classLoader.getName());
            LOG.debug("... translator options {}", (Object)translatorOptions);
            Path baseDir = Paths.get(this.instanceName + "/" + serviceName, new String[0]);
            LOG.debug("... and outputting to dir {}", (Object)baseDir);
            Injector injector = Guice.createInjector((Module[])new Module[]{this.modelRuntimeModel});
            IngesterGenerator generator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
            SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
            Translator translator = new Translator(translatorOptions, this.classLoader, generator, synonymToEnumMapGenerator);
            Translator.GeneratedClasses<? extends HandlerFactory> factoryClass = this.createFactoryClass(translatorOptions.isJson(), baseDir, translator);
            GeneratedIngestionParserMapper ingestionParserMapper = new GeneratedIngestionParserMapper(factoryClass.getHandlerFactory(), factoryClass.getSynonymToEnumMap(), translatorOptions.getXmlExclusionsFilePath(), translatorOptions.isJson(), translatorOptions.preProcessJson(), injector);
            return new RosettaIngestionService(new PostProcessorRunner(this.postProcessors), ingestionParserMapper, this.validatorPostProcessor, translatorOptions.getName());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to construct IngestionResource for " + serviceName, e);
        }
    }

    private Translator.GeneratedClasses<? extends HandlerFactory> createFactoryClass(boolean isJson, Path baseDir, Translator translator) throws IOException, ClassNotFoundException {
        return isJson ? translator.generateClassesFromJsonSchema(baseDir) : translator.generateClassesFromXmlSchema(baseDir);
    }

    private static <T extends PostProcessStep> T getProcessStep(PostProcessStep[] postProcessors, Class<T> clazz) {
        return (T)Arrays.stream(postProcessors).filter(clazz::isInstance).map(clazz::cast).findFirst().orElseThrow();
    }
}

