/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.regnosys.ingest.test.framework.ingestor.AssertIngestion;
import com.regnosys.ingest.test.framework.ingestor.ExpectationManager;
import com.regnosys.ingest.test.framework.ingestor.ExpectationUtil;
import com.regnosys.ingest.test.framework.ingestor.IngestionReport;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionFactory;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.regnosys.ingest.test.framework.ingestor.service.TranslatorOptionsFactory;
import com.regnosys.ingest.test.framework.ingestor.testing.Expectation;
import com.regnosys.rosetta.RosettaRuntimeModule;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandler;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandlerProvider;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.testing.MappingCoverage;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.process.PostProcessStep;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.xtext.common.TerminalsStandaloneSetup;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IngestionTest<C extends RosettaModelObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestionTest.class);
    private static final Path INPUT_PATH = Path.of("cdm-sample-files", new String[0]);
    private static final Path OUTPUT_PATH = Path.of("result-json-files", new String[0]);
    protected static boolean writeActualExpectations = ExpectationUtil.WRITE_EXPECTATIONS;
    private static Injector injector;
    private static List<PostProcessStep> postProcessors;
    private static ExpectationManager expectationsManager;
    private static ObjectWriter objectWriter;
    private final Path baseInputPath;
    private final Path baseOutputPath;

    public IngestionTest() {
        this(INPUT_PATH, OUTPUT_PATH);
    }

    public IngestionTest(Path path, Path path2) {
        this.baseInputPath = path;
        this.baseOutputPath = path2;
    }

    protected static void initialiseIngestionFactory(Module module, List<PostProcessStep> list) {
        IngestionTest.initialiseIngestionFactory(TranslatorOptionsFactory.getDefaultIngestionResource(IngestionTest.class.getClassLoader()), module, list);
    }

    protected static void initialiseIngestionFactory(Collection<URL> collection, Module module, List<PostProcessStep> list) {
        Module module2 = IngestionTest.setupRuntimeModules(module);
        postProcessors = list;
        IngestionFactory.init(collection, module2, list.toArray(new PostProcessStep[0]));
    }

    private static Module setupRuntimeModules(Module module) {
        TerminalsStandaloneSetup.doSetup();
        Module module2 = Modules.combine((Module[])new Module[]{module, new RosettaRuntimeModule()});
        injector = Guice.createInjector((Module[])new Module[]{module2});
        new RosettaStandaloneSetup().register(injector);
        return module2;
    }

    protected static void initialiseIngestionFactory(String string, Collection<URL> collection, Module module, List<PostProcessStep> list) {
        Module module2 = IngestionTest.setupRuntimeModules(module);
        postProcessors = list;
        IngestionFactory.init(string, collection, module2, list.toArray(new PostProcessStep[0]));
    }

    @BeforeAll
    static void beforeAll() {
        expectationsManager = new ExpectationManager(writeActualExpectations);
        objectWriter = RosettaObjectMapper.getNewRosettaObjectMapper().writerWithDefaultPrettyPrinter();
    }

    @BeforeEach
    protected void setUp() {
        injector.injectMembers((Object)this);
    }

    @ParameterizedTest(name="{2}")
    @MethodSource(value={"fpMLFiles"})
    protected void ingest(String string, Expectation expectation, String string2) throws Throwable {
        LOGGER.info("---------------------- Running Test for file: {} ----------------------", (Object)expectation.getFileName());
        URL uRL = Resources.getResource((String)expectation.getFileName());
        IngestionReport<C> ingestionReport = this.postIngestIngestionReport(this.ingest(expectation, uRL));
        String string3 = IngestionTest.toJson(ingestionReport.getRosettaModelInstance());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string3);
        }
        expectationsManager.captureExpectation(string, string3, ingestionReport, expectation);
        Executable executable = this.assertJsonEquals(uRL, string3);
        expectationsManager.captureMappingReport(string, expectation, ingestionReport.getMappingReport());
        executable.execute();
        this.assertExpectations(expectation, ingestionReport);
        LOGGER.info("-----------------------------------------------------------------");
    }

    private IngestionReport<C> ingest(Expectation expectation, URL uRL) throws IOException {
        String string = UrlUtils.getFileExtension((URL)uRL);
        if (string.equals("xml")) {
            return this.ingestionService().ingestValidateAndPostProcess(this.getClazz(), UrlUtils.openURL((URL)uRL));
        }
        if (string.equals("json")) {
            return this.ingestionService().ingestAndPostProcessJson(this.getClazz(), UrlUtils.openURL((URL)uRL));
        }
        throw new IllegalArgumentException("Don't know how to process a file of this type " + expectation.getFileName());
    }

    protected C postIngest(C c) {
        return c;
    }

    protected IngestionReport<C> postIngestIngestionReport(IngestionReport<C> ingestionReport) {
        return new IngestionReport<RosettaModelObject>(ingestionReport.getMappingReport(), this.postIngest(ingestionReport.getRosettaModelInstance()), ingestionReport.getValidationReport(), ingestionReport.getQualificationReport(), ingestionReport.getInputValidation(), ingestionReport.getGenericErrorReport());
    }

    protected Executable assertJsonEquals(URL uRL, String string) {
        return () -> {
            String string2 = this.getExpectedJsonPath(uRL);
            String string3 = AssertIngestion.getExpectedJson(string2, this.getClass());
            if (string3 == null) {
                Assertions.fail((String)String.format("No json expectation found for path %s", string2));
            }
            AssertIngestion.assertJsonEquals(string3, string);
        };
    }

    protected String getExpectedJsonPath(URL uRL) {
        String string = UrlUtils.toPortableString((Path)UrlUtils.toPath((URL)uRL));
        String string2 = string.split(UrlUtils.toPortableString((Path)this.baseInputPath))[1].replace(".json", "_cdm.json").replace(".xml", ".json").substring(1);
        String string3 = "/" + UrlUtils.toPortableString((Path)this.baseOutputPath.resolve(string2));
        LOGGER.debug("Expected JSON path {}", (Object)string3);
        return string3;
    }

    protected void assertExpectations(Expectation expectation, IngestionReport<C> ingestionReport) throws JsonProcessingException {
        AssertIngestion.assertMapped(ingestionReport.getMappingReport(), expectation.getOutstandingMappings());
        AssertIngestion.assertValidated(ingestionReport.getValidationReport(), expectation.getValidationFailures());
        AssertIngestion.assertQualification(ingestionReport.getQualificationReport(), expectation.getQualificationExpectation());
        AssertIngestion.assertQualifiedNames(ingestionReport.getRosettaModelInstance(), ingestionReport.getQualificationReport(), expectation.getQualificationExpectation(), this.getQualificationHandlerMap());
        AssertIngestion.assertSerialisation(ingestionReport);
    }

    protected Map<Class<?>, QualificationHandler<?, ?, ?>> getQualificationHandlerMap() {
        return ((QualificationHandlerProvider)injector.getInstance(QualificationHandlerProvider.class)).getQualificationHandlerMap();
    }

    @AfterAll
    static void tearDown() throws IOException {
        expectationsManager.printExpectations();
        expectationsManager.writeMappingReportsSummary();
    }

    protected abstract IngestionService ingestionService();

    protected abstract Class<C> getClazz();

    protected static Stream<Arguments> readExpectationsFromString(ImmutableList<String> immutableList) {
        return IngestionTest.readExpectationsFrom((ImmutableList<URL>)((ImmutableList)immutableList.stream().map(Resources::getResource).collect(ImmutableList.toImmutableList())));
    }

    protected static Stream<Arguments> readExpectationsFromPath(String string) {
        List list = ClassPathUtils.findPathsFromClassPath(List.of(string), (String)"expectations.json", Optional.empty(), (ClassLoader)IngestionTest.class.getClassLoader()).stream().map(UrlUtils::toUrl).collect(Collectors.toList());
        return IngestionTest.readExpectationsFrom((ImmutableList<URL>)ImmutableList.copyOf(list));
    }

    protected static Stream<Arguments> readExpectationsFrom(ImmutableList<URL> immutableList) {
        ObjectMapper objectMapper = new ObjectMapper();
        TypeReference<List<Expectation>> typeReference = new TypeReference<List<Expectation>>(){};
        return immutableList.stream().flatMap(arg_0 -> IngestionTest.lambda$readExpectationsFrom$2(objectMapper, (TypeReference)typeReference, arg_0));
    }

    protected static Stream<Expectation> readFile(URL uRL, ObjectMapper objectMapper, TypeReference<List<Expectation>> typeReference) {
        try {
            List list = (List)objectMapper.readValue(UrlUtils.openURL((URL)uRL), typeReference);
            return list.stream();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static List<MappingCoverage> readCoverageFile(URL uRL, ObjectMapper objectMapper) {
        try {
            return (List)objectMapper.readValue(UrlUtils.openURL((URL)uRL), (TypeReference)new TypeReference<List<MappingCoverage>>(){});
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static String toJson(Object object) throws JsonProcessingException {
        return objectWriter.writeValueAsString(object);
    }

    @Test
    void ensureWriteActualExpectationIsFalse() {
        Assertions.assertFalse((boolean)writeActualExpectations);
    }

    private static /* synthetic */ Stream lambda$readExpectationsFrom$2(ObjectMapper objectMapper, TypeReference typeReference, URL uRL) {
        Stream<Arguments> stream;
        block8: {
            Reader reader = UrlUtils.openURL((URL)uRL);
            try {
                List list = (List)objectMapper.readValue(reader, typeReference);
                stream = list.stream().map(expectation -> Arguments.of((Object[])new Object[]{uRL.getPath(), expectation, expectation.getFileName().substring(expectation.getFileName().lastIndexOf(47) + 1)}));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
            reader.close();
        }
        return stream;
    }
}

