/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json.schema;

import com.regnosys.rosetta.common.util.StringExtensions;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.json.JsonAttribute;
import com.regnosys.rosetta.translate.datamodel.json.JsonEntity;
import com.regnosys.rosetta.translate.datamodel.json.schema.JavaFileWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonSchemaToClasses {
    private static final List<String> PRIMITIVE_TYPES = Arrays.asList("string", "integer", "boolean");
    private final Map<String, String> entityTypeToClassNameMap;
    private final Map<String, String> entityNameToClassNameMap;

    public JsonSchemaToClasses(Map<String, String> entityTypeToClassNameMap, Map<String, String> entityNameToClassNameMap) {
        this.entityTypeToClassNameMap = entityTypeToClassNameMap;
        this.entityNameToClassNameMap = entityNameToClassNameMap;
    }

    public Set<JavaFileWriter.PojoClass> translate(Schema jsonSchema, String topClassName) {
        HashMap<String, JavaFileWriter.PojoClass> visitor = new HashMap<String, JavaFileWriter.PojoClass>();
        this.createClass(topClassName, jsonSchema.getAttributes(), "container", topClassName, visitor);
        return new HashSet<JavaFileWriter.PojoClass>(visitor.values());
    }

    private JavaFileWriter.PojoClass createClass(JsonEntity entity, String parentName, Map<String, JavaFileWriter.PojoClass> visitor) {
        String className = this.entityTypeToClassNameMap.getOrDefault(entity.getType().toLowerCase(), this.entityNameToClassNameMap.getOrDefault(entity.getName().getName().toLowerCase(), entity.getName().getName()));
        return this.createClass(className, entity.getAttributes(), entity.getType(), parentName, visitor);
    }

    private JavaFileWriter.PojoClass createClass(String name, Collection<Attribute> attributes, String entityType, String parentName, Map<String, JavaFileWriter.PojoClass> visitor) {
        List<JavaFileWriter.PojoAttribute> properties = attributes.stream().map(JsonAttribute.class::cast).map(a -> this.createAttribute((JsonAttribute)a, parentName, visitor)).collect(Collectors.toList());
        Object className = StringExtensions.toFirstUpper((String)this.toCamelCase(name));
        JavaFileWriter.PojoClass pojoClass = new JavaFileWriter.PojoClass((String)className, properties);
        JavaFileWriter.PojoClass existingPojoClass = visitor.get(className);
        if (existingPojoClass != null && !pojoClass.equals(existingPojoClass)) {
            className = StringExtensions.toFirstUpper((String)this.toCamelCase(parentName)) + (String)className;
            pojoClass = new JavaFileWriter.PojoClass((String)className, properties);
        }
        visitor.put((String)className, pojoClass);
        return pojoClass;
    }

    private JavaFileWriter.PojoAttribute createAttribute(JsonAttribute attribute, String parentName, Map<String, JavaFileWriter.PojoClass> visitor) {
        JsonEntity entity = (JsonEntity)attribute.getType();
        String jsonProperty = attribute.getName();
        String formattedName = this.toCamelCase(jsonProperty);
        if (entity.hasData() || !entity.hasChild()) {
            String entityType = entity.getType().toLowerCase();
            String primitiveType = PRIMITIVE_TYPES.contains(entityType) ? entityType : "String";
            return new JavaFileWriter.PojoAttribute(jsonProperty, formattedName, primitiveType, attribute.getCardinality());
        }
        JavaFileWriter.PojoClass attributeClass = this.createClass(entity, parentName, visitor);
        return new JavaFileWriter.PojoAttribute(jsonProperty, formattedName, attributeClass.getName(), attribute.getCardinality());
    }

    private String toCamelCase(String name) {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            chars[i] = 95;
            if (i + 1 >= chars.length) continue;
            chars[i + 1] = Character.toUpperCase(chars[i + 1]);
        }
        return StringExtensions.toFirstLower((String)String.valueOf(chars).replaceAll("_", ""));
    }
}

