/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json.schema;

import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.rosetta.util.DottedPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class JavaFileWriter {
    private static final Logger LOGGER = Logger.getLogger(JavaFileWriter.class);

    public CharSequence toJava(DottedPath mainPackage, DottedPath sharedPackage, PojoClass c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append((Object)mainPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import com.fasterxml.jackson.annotation.JsonProperty;");
        _builder.newLine();
        boolean _containsList = this.containsList(c.attributes);
        if (_containsList) {
            _builder.append("import java.util.List;");
            _builder.newLine();
        }
        if (mainPackage != sharedPackage) {
            _builder.append("import ");
            _builder.append((Object)sharedPackage);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(c.name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        boolean _hasElements = false;
        for (PojoAttribute a : c.attributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "\t");
            }
            _builder.append("\t");
            _builder.append("@JsonProperty(\"");
            _builder.append(a.jsonProperty, "\t");
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("private ");
            String _firstUpper = StringExtensions.toFirstUpper((String)this.toAttributeClass(a));
            _builder.append(_firstUpper, "\t");
            _builder.append(" ");
            _builder.append(a.name, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        boolean _hasElements_1 = false;
        for (PojoAttribute a_1 : c.attributes) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)"\n", "\t");
            }
            _builder.append("\t");
            _builder.append("public ");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.toAttributeClass(a_1));
            _builder.append(_firstUpper_1, "\t");
            _builder.append(" get");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)a_1.name);
            _builder.append(_firstUpper_2, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            _builder.append(a_1.name, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set");
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)a_1.name);
            _builder.append(_firstUpper_3, "\t");
            _builder.append("(");
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)this.toAttributeClass(a_1));
            _builder.append(_firstUpper_4, "\t");
            _builder.append(" ");
            _builder.append(a_1.name, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("this.");
            _builder.append(a_1.name, "\t\t");
            _builder.append(" = ");
            _builder.append(a_1.name, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public void writeFile(Path outputDir, DottedPath mainPackage, String fileName, String contents) {
        try {
            boolean _not;
            Path path = outputDir.resolve(mainPackage.toPath());
            boolean _exists = Files.exists(path, new LinkOption[0]);
            boolean bl = _not = !_exists;
            if (_not) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            Path fullPath = path.resolve(fileName + ".java");
            LOGGER.debug((Object)("Writing class " + String.valueOf(fullPath)));
            Files.write(fullPath, contents.getBytes(), new OpenOption[0]);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String toAttributeClass(PojoAttribute a) {
        if (a.cardinality == Cardinality.MULTIPLE) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("List<");
            _builder.append(a.className);
            _builder.append(">");
            return _builder.toString();
        }
        return a.className;
    }

    private boolean containsList(List<PojoAttribute> attributes) {
        Functions.Function1 _function = it -> it.cardinality == Cardinality.MULTIPLE;
        return IterableExtensions.exists(attributes, (Functions.Function1)_function);
    }

    @Data
    public static class PojoClass {
        private final String name;
        private final List<PojoAttribute> attributes;

        public PojoClass(String name, List<PojoAttribute> attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoClass other = (PojoClass)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("attributes", this.attributes);
            return b.toString();
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public List<PojoAttribute> getAttributes() {
            return this.attributes;
        }
    }

    @Data
    public static class PojoAttribute {
        private final String jsonProperty;
        private final String name;
        private final String className;
        private final Cardinality cardinality;

        public PojoAttribute(String jsonProperty, String name, String className, Cardinality cardinality) {
            this.jsonProperty = jsonProperty;
            this.name = name;
            this.className = className;
            this.cardinality = cardinality;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.jsonProperty == null ? 0 : this.jsonProperty.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return 31 * result + (this.cardinality == null ? 0 : this.cardinality.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoAttribute other = (PojoAttribute)obj;
            if (this.jsonProperty == null ? other.jsonProperty != null : !this.jsonProperty.equals(other.jsonProperty)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.cardinality == null ? other.cardinality != null : !this.cardinality.equals((Object)other.cardinality));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("jsonProperty", (Object)this.jsonProperty);
            b.add("name", (Object)this.name);
            b.add("className", (Object)this.className);
            b.add("cardinality", (Object)this.cardinality);
            return b.toString();
        }

        @Pure
        public String getJsonProperty() {
            return this.jsonProperty;
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public String getClassName() {
            return this.className;
        }

        @Pure
        public Cardinality getCardinality() {
            return this.cardinality;
        }
    }
}

