/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json;

import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.BasicType;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SimpleJsonEntity
implements Entity {
    private final NamespaceName name;
    private final BasicType type;

    private SimpleJsonEntity(String name, BasicType type) {
        this.name = new NamespaceName("", name);
        this.type = type;
    }

    public static Entity stringType(String name) {
        return new SimpleJsonEntity(name, BasicType.STRING);
    }

    @Override
    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public void addAttribute(Attribute att) {
        throw new UnsupportedOperationException("N/A");
    }

    @Override
    public Entity getExtendedEntity() {
        throw new UnsupportedOperationException("N/A");
    }

    @Override
    public List<Entity> getKnownExtendingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChild() {
        return false;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public BasicType getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + String.valueOf((Object)this.type) + ")";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SimpleJsonEntity)) {
            return false;
        }
        SimpleJsonEntity otherP = (SimpleJsonEntity)other;
        return Objects.equals(this.name, otherP.name) && Objects.equals((Object)this.type, (Object)otherP.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    @Override
    public String toString(Set<String> alreadyWritten) {
        return this.toString();
    }
}

