/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.basic;

import com.regnosys.rosetta.translate.ParseHandler;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicParseHandler<T>
extends ParseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicParseHandler.class);
    protected Consumer<T> parentSetter;
    protected Supplier<Optional<T>> parentSupplier;
    private final boolean allowsMultiple;
    private final boolean isCondition;
    private final String patternMatch;
    private final String patternReplace;
    private final boolean removeHtml;

    public BasicParseHandler(boolean allowsMultiple) {
        this.allowsMultiple = allowsMultiple;
        this.isCondition = false;
        this.patternMatch = null;
        this.patternReplace = null;
        this.removeHtml = false;
    }

    public BasicParseHandler(boolean allowsMultiple, boolean isCondition) {
        this.allowsMultiple = allowsMultiple;
        this.isCondition = isCondition;
        this.patternMatch = null;
        this.patternReplace = null;
        this.removeHtml = false;
    }

    public BasicParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml) {
        this.allowsMultiple = allowsMultiple;
        this.isCondition = isCondition;
        this.patternMatch = null;
        this.patternReplace = null;
        this.removeHtml = removeHtml;
    }

    public BasicParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml, String patternMatch, String patternReplace) {
        this.allowsMultiple = allowsMultiple;
        this.isCondition = isCondition;
        this.patternMatch = patternMatch;
        this.patternReplace = patternReplace;
        this.removeHtml = removeHtml;
    }

    public SetResult setValue(String value) {
        try {
            if (this.patternMatch != null) {
                value = value.replaceAll(this.patternMatch, this.patternReplace);
            }
            if (this.removeHtml) {
                value = Jsoup.parse((String)value).text();
            }
            T newValue = this.convert(value);
            return this.setTypedValue(newValue);
        }
        catch (RuntimeException e) {
            LOGGER.info("Error setting a value [" + value + "]: " + e.getMessage());
            return new SetResult(SetResultStatus.PARSING, null, null);
        }
    }

    public SetResult setTypedValue(T newValue) {
        Optional<T> prevValue = this.parentSupplier.get();
        if (prevValue.isPresent()) {
            return new SetResult(SetResultStatus.DUPLICATE, prevValue.orElse(null), newValue);
        }
        this.parentSetter.accept(newValue);
        return new SetResult(SetResultStatus.SUCCESS, null, newValue);
    }

    public void setParentSetter(Consumer<T> parentSetter) {
        this.parentSetter = parentSetter;
    }

    public void setParentSupplier(Supplier<Optional<T>> parentSupplier) {
        this.parentSupplier = parentSupplier;
    }

    protected abstract T convert(String var1);

    public boolean allowsMultiple() {
        return this.allowsMultiple;
    }

    public boolean isCondition() {
        return this.isCondition;
    }

    public static class SetResult {
        private final SetResultStatus status;
        private final Object oldValue;
        private final Object newValue;

        public SetResult(SetResultStatus status, Object oldValue, Object newValue) {
            this.status = status;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public SetResultStatus getStatus() {
            return this.status;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return "SetResult [status=" + String.valueOf((Object)this.status) + ", oldValue=" + String.valueOf(this.oldValue) + ", newValue=" + String.valueOf(this.newValue) + "]";
        }
    }

    public static enum SetResultStatus {
        SUCCESS,
        DUPLICATE,
        PARSING,
        MAPPING;

    }
}

