/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.object.ExpandedType;
import com.regnosys.rosetta.generator.util.IterableUtil;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.RosettaAttributeReference;
import com.regnosys.rosetta.rosetta.RosettaAttributeReferenceSegment;
import com.regnosys.rosetta.rosetta.RosettaBuiltinType;
import com.regnosys.rosetta.rosetta.RosettaDataReference;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.translate.CustomDeserialise;
import com.regnosys.rosetta.translate.GeneratedNameAndSource;
import com.regnosys.rosetta.translate.GenerationResult;
import com.regnosys.rosetta.translate.GeneratorParams;
import com.regnosys.rosetta.translate.GeneratorUtil;
import com.regnosys.rosetta.translate.IngesterGeneratorUtils;
import com.regnosys.rosetta.translate.MappingError;
import com.regnosys.rosetta.translate.SynonymAttributePath;
import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.ModelParser;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.SchemaDeserialise;
import com.regnosys.rosetta.translate.datamodel.SchemaSerialise;
import com.regnosys.rosetta.translate.datamodel.json.JsonSchemaParser;
import com.regnosys.rosetta.translate.datamodel.xsd.BeansXsdParser;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroup;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroupMapping;
import com.regnosys.rosetta.translate.synonymmap.CardinalityChecker;
import com.regnosys.rosetta.translate.synonymmap.Element;
import com.regnosys.rosetta.translate.synonymmap.ModelCombiner;
import com.regnosys.rosetta.translate.synonymmap.SynonymAbsentTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymBinaryTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymCondition;
import com.regnosys.rosetta.translate.synonymmap.SynonymConditionFuncTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymExistsTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymGroup;
import com.regnosys.rosetta.translate.synonymmap.SynonymMap;
import com.regnosys.rosetta.translate.synonymmap.SynonymMapBuilder;
import com.regnosys.rosetta.translate.synonymmap.SynonymMapConsumer;
import com.regnosys.rosetta.translate.synonymmap.SynonymPathTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymRosettaPathTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class IngesterGenerator {
    private static final Logger LOGGER = Logger.getLogger(IngesterGenerator.class);
    public static final MetricRegistry GENERATOR_METRICS = new MetricRegistry();
    @Inject
    @Extension
    private JavaTypeTranslator typeTranslator;
    @Inject
    private JsonSchemaParser jsonSchemaParser;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private SynonymMapConsumer synonymMapConsumer;
    @Inject
    private RosettaJavaPackages packages;
    @Inject
    private JavaTypeUtil typeUtil;

    public GeneratedIngesters generateXml(String envName, String factoryName, List<GeneratorParams> generatorParamsList) {
        BeansXsdParser _beansXsdParser = new BeansXsdParser();
        ParseHandlersAndMappingErrors handlersAndErrors = this.parseHandlersAndMappingErrors(_beansXsdParser, generatorParamsList);
        String factory = this.generateXmlFactory(envName, factoryName, generatorParamsList);
        GenerationResult _generationResult = new GenerationResult(false, factory);
        GeneratedNameAndSource _generatedNameAndSource = new GeneratedNameAndSource(envName + "." + factoryName, _generationResult);
        return new GeneratedIngesters(_generatedNameAndSource, handlersAndErrors.parseHandlers, handlersAndErrors.errors);
    }

    public GeneratedIngesters generateJson(String envName, String factoryName, List<GeneratorParams> generatorParamsList) {
        String _simpleName = this.jsonSchemaParser.getClass().getSimpleName();
        String _plus = "JSON model parser " + _simpleName;
        LOGGER.info((Object)_plus);
        ParseHandlersAndMappingErrors handlersAndErrors = this.parseHandlersAndMappingErrors(this.jsonSchemaParser, generatorParamsList);
        String factory = this.generateJsonFactory(envName, factoryName, generatorParamsList);
        GenerationResult _generationResult = new GenerationResult(false, factory);
        GeneratedNameAndSource _generatedNameAndSource = new GeneratedNameAndSource(envName + "." + factoryName, _generationResult);
        return new GeneratedIngesters(_generatedNameAndSource, handlersAndErrors.parseHandlers, handlersAndErrors.errors);
    }

    private ParseHandlersAndMappingErrors parseHandlersAndMappingErrors(ModelParser modelParser, List<GeneratorParams> params) {
        ParseHandlersAndMappingErrors _xblockexpression = null;
        ArrayList parseHandlers = CollectionLiterals.newArrayList();
        ArrayList errors = CollectionLiterals.newArrayList();
        for (GeneratorParams param : params) {
            Pair<Map<String, GenerationResult>, Collection<MappingError>> parsers = this.generateParsers(modelParser, param.getSchema(), param.getRosettaEntities(), param.getSources(), param.getTopLevelTags(), param.getChildPackageName());
            Functions.Function1 _function = it -> {
                String _childPackageName = param.getChildPackageName();
                String _plus = _childPackageName + ".";
                String _key = (String)it.getKey();
                String _plus_1 = _plus + _key;
                String _plus_2 = _plus_1 + "ParseHandler";
                GenerationResult _value = (GenerationResult)it.getValue();
                return new GeneratedNameAndSource(_plus_2, _value);
            };
            Iterables.addAll((Collection)parseHandlers, (Iterable)IterableExtensions.map(((Map)parsers.getKey()).entrySet(), (Functions.Function1)_function));
            errors.addAll((Collection)parsers.getValue());
        }
        _xblockexpression = new ParseHandlersAndMappingErrors(parseHandlers, errors);
        return _xblockexpression;
    }

    private Pair<Map<String, GenerationResult>, Collection<MappingError>> generateParsers(ModelParser modelParser, URL modelUrl, Collection<RosettaType> rosettaEntities, Collection<RosettaSynonymSource> sources, Collection<String> topLevelTags, String childPackageName) {
        Pair<Map<String, GenerationResult>, Collection<MappingError>> _xblockexpression = null;
        Schema schema = this.getSchema(modelParser, modelUrl, childPackageName);
        _xblockexpression = this.generateParsers(sources, rosettaEntities, schema, topLevelTags, childPackageName);
        return _xblockexpression;
    }

    public Schema getSchema(ModelParser modelParser, URL modelUrl, String childPackageName) {
        try {
            Schema _xblockexpression = null;
            String _baseFileName = UrlUtils.getBaseFileName((URL)modelUrl);
            String jschemaFileName = _baseFileName + ".schema";
            URL schemaURL = new URL(modelUrl, jschemaFileName);
            try {
                long loadStart = System.currentTimeMillis();
                SchemaDeserialise deserial = new SchemaDeserialise();
                Object _deserialise = deserial.deserialise(schemaURL.openStream());
                Schema schema = (Schema)_deserialise;
                long _currentTimeMillis = System.currentTimeMillis();
                long _minus = _currentTimeMillis - loadStart;
                String _plus = "Loaded schema from file " + String.valueOf(schemaURL) + " in " + Long.valueOf(_minus);
                LOGGER.info((Object)_plus);
                return schema;
            }
            catch (Throwable _t) {
                boolean _not;
                if (!(_t instanceof IOException) && !(_t instanceof CustomDeserialise.ParseException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                LOGGER.info((Object)("Failed to read schema file from " + String.valueOf(schemaURL)));
                String _xifexpression = null;
                String _lowerCase = UrlUtils.getFileExtension((URL)modelUrl).toLowerCase();
                boolean _equals = Objects.equals(_lowerCase, "xsd");
                _xifexpression = _equals ? "XSD" : "JSON";
                String type = _xifexpression;
                LOGGER.info((Object)("Parsing " + type + " model for " + childPackageName));
                Schema schema = modelParser.parseModel(modelUrl);
                boolean _isOpaque = schemaURL.toURI().isOpaque();
                boolean bl = _not = !_isOpaque;
                if (_not) {
                    URI _uRI = schemaURL.toURI();
                    File schemaFile = new File(_uRI);
                    SchemaSerialise serialise = new SchemaSerialise();
                    FileOutputStream _fileOutputStream = new FileOutputStream(schemaFile);
                    serialise.serialiseObject(schema, _fileOutputStream);
                }
                _xblockexpression = schema;
                return _xblockexpression;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Pair<Map<String, GenerationResult>, Collection<MappingError>> generateParsers(Collection<RosettaSynonymSource> sources, Collection<RosettaType> rosettaEntities, Schema schema, Collection<String> topLevelTags, String childPackageName) {
        LOGGER.info((Object)"Building synonym map");
        List<String> synonymSourceNames = GeneratorUtil.synonymSourceNames(sources);
        List<RosettaExternalSynonymSource> externalSynonyms = GeneratorUtil.externalSynonymSources(sources);
        SynonymMapBuilder mappingBuilder = new SynonymMapBuilder(synonymSourceNames, externalSynonyms, this.typeTranslator);
        HashMap<String, Long> _hashMap = new HashMap<String, Long>();
        return this.generateParsers(mappingBuilder, sources, rosettaEntities, schema, topLevelTags, childPackageName, _hashMap);
    }

    public Pair<Map<String, GenerationResult>, Collection<MappingError>> generateParsers(SynonymMapBuilder mappingBuilder, Collection<RosettaSynonymSource> sources, Collection<RosettaType> rosettaEntities, Schema schema, Collection<String> topLevelTags, String childPackageName, Map<String, Long> synHashCache) {
        Functions.Function1 _function = c -> mappingBuilder.buildMap((RosettaType)c);
        List<SynonymMap> syns = IterableExtensions.toList((Iterable)IterableExtensions.map(rosettaEntities, (Functions.Function1)_function));
        LOGGER.info((Object)"Validating synonyms");
        ModelCombiner combiner = new ModelCombiner();
        ArrayList combineErrors = CollectionLiterals.newArrayList();
        syns = combiner.combineModels(schema, syns, combineErrors, topLevelTags);
        LOGGER.info((Object)"Pruning synonyms");
        syns = combiner.prune(syns);
        Predicate<MappingError> _function_1 = e -> {
            MappingError.MappingErrorLevel _level = e.getLevel();
            return Objects.equals((Object)_level, (Object)MappingError.MappingErrorLevel.ERROR);
        };
        boolean _anyMatch = combineErrors.stream().anyMatch(_function_1);
        if (_anyMatch) {
            // empty if block
        }
        LOGGER.info((Object)"Checking cardinalities");
        combineErrors.addAll(new CardinalityChecker().checkCardinalities(syns));
        Map<String, GenerationResult> parsers = this.generateParsers(syns, sources, childPackageName, synHashCache);
        this.synonymMapConsumer.accept(syns);
        return new Pair(parsers, (Object)combineErrors);
    }

    public Map<String, GenerationResult> generateParsers(Collection<SynonymMap> topLevels, Collection<RosettaSynonymSource> sources, String childName, Map<String, Long> synHashCache) {
        LOGGER.debug((Object)"Creating java files");
        HashMap<String, GenerationResult> generated = new HashMap<String, GenerationResult>();
        for (SynonymMap mapping : topLevels) {
            this.generateParsers(mapping, generated, sources, childName, synHashCache);
        }
        return generated;
    }

    private void generateParsers(SynonymMap mapping, Map<String, GenerationResult> generated, Collection<RosettaSynonymSource> sources, String childPackageName, Map<String, Long> synHashCache) {
        boolean _containsKey = generated.containsKey(mapping.getRosetta().getName());
        if (_containsKey) {
            return;
        }
        boolean _isClassOrData = this.isClassOrData(mapping.getRosetta());
        if (_isClassOrData) {
            this.generateClassParsers(mapping, generated, sources, childPackageName, synHashCache);
        } else {
            RosettaType _rosetta = mapping.getRosetta();
            if (_rosetta instanceof RosettaEnumeration) {
                this.generateEnumParsers(mapping, generated, childPackageName, synHashCache);
            }
        }
    }

    private boolean validNamespaces(RosettaModel model, String importedNamespace) {
        boolean _tripleEquals;
        Set _xifexpression = null;
        ResourceSet _resourceSet = model.eResource().getResourceSet();
        EList _resources = null;
        if (_resourceSet != null) {
            _resources = _resourceSet.getResources();
        }
        boolean bl = _tripleEquals = _resources == null;
        if (_tripleEquals) {
            HashSet _xblockexpression = null;
            String _string = model.eResource().getURI().toString();
            String _plus = "No resource set found for " + _string;
            LOGGER.warn((Object)_plus);
            _xifexpression = _xblockexpression = CollectionLiterals.newHashSet();
        } else {
            Functions.Function1 _function = it -> it.getContents();
            Functions.Function1 _function_1 = it -> it.getElements();
            Functions.Function1 _function_2 = it -> it instanceof Data || it instanceof RosettaEnumeration;
            Functions.Function1 _function_3 = it -> (RosettaType)RosettaType.class.cast(it);
            Functions.Function1 _function_4 = it -> it.getModel().getName();
            _xifexpression = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)model.eResource().getResourceSet().getResources(), (Functions.Function1)_function), RosettaModel.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        }
        HashSet validNamespacesSet = _xifexpression;
        String namespace = importedNamespace.substring(0, this.indexOrLength(importedNamespace, '.'));
        return validNamespacesSet.contains(namespace);
    }

    private int indexOrLength(String toSearch, char find) {
        int _xblockexpression = 0;
        int index = toSearch.lastIndexOf(find);
        int _xifexpression = 0;
        _xifexpression = index == -1 ? toSearch.length() : index;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private void generateClassParsers(SynonymMap mapping, Map<String, GenerationResult> generated, Collection<RosettaSynonymSource> synonymSources, String envName, Map<String, Long> synHashCache) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        boolean _containsKey = generated.containsKey(IterableUtil.fullname((RosettaType)mapping.getRosetta()));
        if (_containsKey) {
            return;
        }
        EObject _eContainer = mapping.getRosetta().eContainer();
        RosettaModel rosettaModel = (RosettaModel)_eContainer;
        Resource _eResource = rosettaModel.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            LOGGER.warn((Object)("Unable to generate translate parsers. No resource found for rosetta model: " + String.valueOf(rosettaModel)));
            return;
        }
        Long prevHash = synHashCache.get(IterableUtil.fullname((RosettaType)mapping.getRosetta()));
        long newHash = mapping.hashForGeneration();
        if (prevHash == null || newHash != prevHash) {
            boolean _not;
            Object _handler;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("package ");
            _builder.append(envName);
            _builder.append(".");
            String _packageName = IterableUtil.packageName((RosettaType)mapping.getRosetta());
            _builder.append(_packageName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("import java.math.BigDecimal;");
            _builder.newLine();
            _builder.append("import java.time.LocalDate;");
            _builder.newLine();
            _builder.append("import java.time.LocalTime;");
            _builder.newLine();
            _builder.append("import java.util.Collections;");
            _builder.newLine();
            _builder.append("import java.util.ArrayList;");
            _builder.newLine();
            _builder.append("import java.util.List;");
            _builder.newLine();
            _builder.append("import java.util.Set;");
            _builder.newLine();
            _builder.append("import java.util.Optional;");
            _builder.newLine();
            _builder.append("import java.util.Map;");
            _builder.newLine();
            _builder.append("import java.util.HashMap;");
            _builder.newLine();
            _builder.append("import java.util.LinkedHashMap;");
            _builder.newLine();
            _builder.append("import java.util.concurrent.atomic.AtomicBoolean;");
            _builder.newLine();
            _builder.append("import java.util.stream.Collectors;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("import com.google.common.collect.ImmutableList;");
            _builder.newLine();
            _builder.append("import com.google.common.collect.ImmutableMultimap;");
            _builder.newLine();
            _builder.append("import com.google.inject.Injector;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.HandlerSupplier;");
            _builder.newLine();
            _builder.append("import com.rosetta.model.lib.meta.Reference;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.GeneratorPathUtil;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.HandlerCache;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.IngestMerger;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.MappingProcessorSupplier;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.SynonymValueGroup;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.ROMParseHandler;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.common.translation.Mapping;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.common.translation.MappingContext;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.common.translation.Path;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.common.util.PathUtils;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.translate.basic.*;");
            _builder.newLine();
            _builder.append("import com.regnosys.rosetta.common.translation.Path.PathElement;");
            _builder.newLine();
            EList _imports = rosettaModel.getImports();
            for (Object importResources : _imports) {
                String importedNamespace = importResources.getImportedNamespace();
                _builder.newLineIfNotEmpty();
                boolean _validNamespaces = this.validNamespaces(rosettaModel, importedNamespace);
                if (!_validNamespaces) continue;
                _builder.append("import ");
                _builder.append(importedNamespace);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("import ");
            String _name = rosettaModel.getName();
            _builder.append(_name);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            List<String> _traversedImports = IngesterGeneratorUtils.getTraversedImports(mapping);
            for (String traversedImports : _traversedImports) {
                _builder.append("import ");
                _builder.append(traversedImports);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("import com.rosetta.model.lib.records.*;");
            _builder.newLine();
            _builder.append("import com.rosetta.model.lib.RosettaModelObjectBuilder;");
            _builder.newLine();
            _builder.append("import com.rosetta.model.lib.path.RosettaPath;");
            _builder.newLine();
            _builder.append("import com.rosetta.model.lib.process.BuilderProcessor;");
            _builder.newLine();
            _builder.append("import com.rosetta.model.metafields.MetaFields;");
            _builder.newLine();
            _builder.newLine();
            String header = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("public ");
            boolean _isAbstract = this.isAbstract(mapping.getRosetta());
            if (_isAbstract) {
                _builder_1.append("abstract ");
            }
            _builder_1.append("class ");
            CharSequence _pNameW = this.pNameW(mapping);
            _builder_1.append((Object)_pNameW);
            _builder_1.append("<T extends ");
            StringConcatenationClient _builder_2 = this.toBuilder((EObject)mapping.getRosetta());
            _builder_1.append(_builder_2);
            _builder_1.append("> ");
            CharSequence _romExtends = this.romExtends(mapping, envName);
            _builder_1.append((Object)_romExtends);
            _builder_1.append(" {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            String _pathConstants = this.pathConstants(mapping);
            _builder_1.append(_pathConstants, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            CharSequence _conditionalValues = this.conditionalValues(mapping);
            _builder_1.append((Object)_conditionalValues, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            CharSequence _handlerCaches = this.handlerCaches(mapping, envName);
            _builder_1.append((Object)_handlerCaches, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            CharSequence _constructor = this.constructor(mapping);
            _builder_1.append((Object)_constructor, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("// regular handlers");
            _builder_1.newLine();
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> !it_1.getSynonymValues().isEmpty() && IterableExtensions.forall(it_1.getConditions(), it_2 -> it_2.getCondition().isEmpty());
                return IterableExtensions.exists(it.getGroup().getSynonymGroups(), (Functions.Function1)_function_1);
            };
            Functions.Function1 _function_1 = it -> it.getGroup();
            Functions.Function1 _function_2 = it -> this.toHandlerMethodName(it.getGroup());
            List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.sortBy((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
            boolean _hasElements = false;
            for (AttributeGroupMapping h : _sortBy) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_1.appendImmediate((Object)"\n", "\t");
                }
                _builder_1.append("\t");
                _handler = this.handler(h, mapping, envName);
                _builder_1.append(_handler, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("// conditional handlers");
            _builder_1.newLine();
            Functions.Function1 _function_3 = it -> {
                Functions.Function1 _function_4 = it_1 -> !it_1.getSynonymValues().isEmpty() && IterableExtensions.exists(it_1.getConditions(), it_2 -> {
                    boolean _isEmpty = it_2.getCondition().isEmpty();
                    return !_isEmpty;
                });
                return IterableExtensions.exists(it.getGroup().getSynonymGroups(), (Functions.Function1)_function_4);
            };
            Functions.Function1 _function_4 = it -> it.getGroup();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
            boolean _hasElements_1 = false;
            for (AttributeGroupMapping h_1 : _sortBy_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_1.appendImmediate((Object)"\n", "\t");
                }
                _builder_1.append("\t");
                CharSequence _condHandler = this.condHandler(h_1, mapping, envName);
                _builder_1.append((Object)_condHandler, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("// conditional capture handlers");
            _builder_1.newLine();
            Functions.Function1 _function_5 = e -> this.toConditionalHandlerMethodName((SynonymValue)e.getKey());
            List _sortBy_2 = IterableExtensions.sortBy(mapping.getConditionalCaptures().asMap().entrySet(), (Functions.Function1)_function_5);
            boolean _hasElements_2 = false;
            for (Map.Entry ent : _sortBy_2) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder_1.appendImmediate((Object)"\n", "\t");
                }
                _builder_1.append("\t");
                CharSequence _conditionalCaptureHandler = this.conditionalCaptureHandler(ent, mapping);
                _builder_1.append((Object)_conditionalCaptureHandler, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("// regular handler getter (for nested 'set to' conditional mapping with path predicate)");
            _builder_1.newLine();
            _builder_1.append("\t");
            HashSet alreadyGenerated = CollectionLiterals.newHashSet();
            _builder_1.newLineIfNotEmpty();
            Functions.Function1 _function_6 = it -> {
                Functions.Function1 _function_7 = it_1 -> it_1.getSynonymValues().isEmpty();
                return IterableExtensions.exists(it.getGroup().getSynonymGroups(), (Functions.Function1)_function_7);
            };
            Functions.Function1 _function_7 = it -> {
                Functions.Function1 _function_8 = it_1 -> it_1.getConditions();
                Functions.Function1 _function_9 = it_1 -> it_1.getCondition();
                Functions.Function1 _function_10 = it_1 -> it_1 instanceof SynonymPathTest;
                return IterableExtensions.exists((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap(it.getGroup().getSynonymGroups(), (Functions.Function1)_function_8), (Functions.Function1)_function_9), (Functions.Function1)_function_10);
            };
            Functions.Function1 _function_8 = it -> it.getGroup().getAttributePath();
            Functions.Function1 _function_9 = it -> {
                int _size = it.size();
                return _size > 1;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function_6), (Functions.Function1)_function_7), (Functions.Function1)_function_8), (Functions.Function1)_function_9);
            boolean _hasElements_3 = false;
            _handler = _filter.iterator();
            while (_handler.hasNext()) {
                List p = (List)_handler.next();
                if (!_hasElements_3) {
                    _hasElements_3 = true;
                } else {
                    _builder_1.appendImmediate((Object)"\n", "\t");
                }
                _builder_1.append("\t");
                CharSequence _nestedSetToHandler = this.nestedSetToHandler(p, mapping, alreadyGenerated);
                _builder_1.append((Object)_nestedSetToHandler, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t");
            _builder_1.newLine();
            _builder_1.append("\t");
            _builder_1.append("// mappers");
            _builder_1.newLine();
            Functions.Function1 _function_10 = it -> {
                Functions.Function1 _function_11 = it_1 -> {
                    String _mapperName = it_1.getMapperName();
                    return _mapperName != null;
                };
                return IterableExtensions.exists(it.getGroup().getSynonymGroups(), (Functions.Function1)_function_11);
            };
            Functions.Function1 _function_11 = it -> it.getGroup();
            List _sortBy_3 = IterableExtensions.sortBy((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function_10), (Functions.Function1)_function_11);
            boolean _hasElements_4 = false;
            for (AttributeGroupMapping h_2 : _sortBy_3) {
                if (!_hasElements_4) {
                    _hasElements_4 = true;
                } else {
                    _builder_1.appendImmediate((Object)"\n", "\t");
                }
                _builder_1.append("\t");
                CharSequence _mappingProcessor = this.mappingProcessor(h_2, mapping);
                _builder_1.append((Object)_mappingProcessor, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t");
            _builder_1.newLine();
            boolean _isAbstract_1 = this.isAbstract(mapping.getRosetta());
            boolean bl2 = _not = !_isAbstract_1;
            if (_not) {
                _builder_1.append("\t");
                _builder_1.append("// builder proxy");
                _builder_1.newLine();
                _builder_1.append("\t");
                CharSequence _generateBuilderProxy = this.generateBuilderProxy(mapping);
                _builder_1.append((Object)_generateBuilderProxy, "\t");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("}");
            _builder_1.newLine();
            String body = _builder_1.toString();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(header);
            _builder_3.newLineIfNotEmpty();
            _builder_3.newLine();
            _builder_3.append(body);
            _builder_3.newLineIfNotEmpty();
            String parser = _builder_3.toString();
            String _fullname = IterableUtil.fullname((RosettaType)mapping.getRosetta());
            GenerationResult _generationResult = new GenerationResult(false, parser);
            generated.put(_fullname, _generationResult);
            synHashCache.put(IterableUtil.fullname((RosettaType)mapping.getRosetta()), newHash);
        } else {
            String _fullname_1 = IterableUtil.fullname((RosettaType)mapping.getRosetta());
            GenerationResult _generationResult_1 = new GenerationResult(true, null);
            generated.put(_fullname_1, _generationResult_1);
        }
        SynonymMap _superMap = mapping.getSuperMap();
        boolean bl3 = _tripleNotEquals = _superMap != null;
        if (_tripleNotEquals) {
            this.generateParsers(mapping.getSuperMap(), generated, synonymSources, envName, synHashCache);
        }
        Collection<SynonymMap> _childMappings = mapping.childMappings();
        for (SynonymMap subParser : _childMappings) {
            RosettaType _rosetta = subParser.getRosetta();
            boolean _tripleNotEquals_1 = _rosetta != null;
            if (!_tripleNotEquals_1) continue;
            this.generateParsers(subParser, generated, synonymSources, envName, synHashCache);
        }
    }

    protected boolean _isAbstract(RosettaType type) {
        return true;
    }

    protected boolean _isAbstract(Data type) {
        return false;
    }

    public Multimap<SynonymValue, SynonymCondition> captureList(List<SynonymGroup> groups) {
        LinkedListMultimap conditionals = LinkedListMultimap.create();
        for (SynonymGroup sg : groups) {
            List<SynonymValue> _synonymValues = sg.getSynonymValues();
            for (SynonymValue sv : _synonymValues) {
                conditionals.putAll((Object)sv, sg.getConditions());
            }
        }
        return conditionals;
    }

    private String toPathName(SynonymValue synonymValue) {
        Functions.Function1 _function = it -> it.getName();
        return StringExtensions.toFirstLower((String)IterableExtensions.join((Iterable)ListExtensions.map(synonymValue.getSynonymPath(), (Functions.Function1)_function), (CharSequence)"_"));
    }

    private CharSequence romExtends(SynonymMap mapping, String envName) {
        boolean _tripleEquals;
        StringConcatenation _xifexpression = null;
        SynonymMap _superMap = mapping.getSuperMap();
        boolean bl = _tripleEquals = _superMap == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("extends ROMParseHandler<T>");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("extends ");
            CharSequence _pFullNameW = this.pFullNameW(mapping.getSuperMap(), envName);
            _builder_1.append((Object)_pFullNameW);
            _builder_1.append("<T>");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    private CharSequence pNameW(SynonymMap mapping) {
        return this.pNameW(mapping.getRosetta());
    }

    private CharSequence pFullNameT(SynonymMap mapping, String packageName) {
        return this.pFullNameT(mapping.getRosetta(), packageName);
    }

    private CharSequence pNameW(RosettaType rosetta) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rosetta.getName();
        _builder.append(_name);
        _builder.append("ParseHandler");
        return _builder;
    }

    private CharSequence pFullNameT(ExpandedType rosetta, String envName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(envName);
        _builder.append(".");
        String _name = rosetta.getModel().getName();
        _builder.append(_name);
        _builder.append(".");
        String _name_1 = rosetta.getName();
        _builder.append(_name_1);
        return _builder;
    }

    private CharSequence pFullNameW(ExpandedType rosetta, String envName) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _pFullNameT = this.pFullNameT(rosetta, envName);
        _builder.append((Object)_pFullNameT);
        _builder.append("ParseHandler");
        return _builder;
    }

    private CharSequence pFullNameW(SynonymMap mapping, String envName) {
        return this.pFullNameW(mapping.getRosetta(), envName);
    }

    private CharSequence pFullNameW(RosettaType rosetta, String envName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(envName);
        _builder.append(".");
        String _fullname = IterableUtil.fullname((RosettaType)rosetta);
        _builder.append(_fullname);
        _builder.append("ParseHandler");
        return _builder;
    }

    private CharSequence pFullNameT(RosettaType rosetta, String envName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(envName);
        _builder.append(".");
        String _fullname = IterableUtil.fullname((RosettaType)rosetta);
        _builder.append(_fullname);
        _builder.append("ParseHandler<");
        StringConcatenationClient _builder_1 = this.toBuilder((EObject)rosetta);
        _builder.append(_builder_1);
        _builder.append(">");
        return _builder;
    }

    private CharSequence expandedTypeToBuilder(ExpandedType type) {
        StringConcatenation _xifexpression = null;
        boolean _isType = type.isType();
        if (_isType) {
            StringConcatenation _builder = new StringConcatenation();
            JavaClass _expandedTypeToJavaType = this.expandedTypeToJavaType(type);
            JavaClass<?> _builderType = IngesterGeneratorUtils.toBuilderType(_expandedTypeToJavaType);
            _builder.append(_builderType);
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            JavaClass _expandedTypeToJavaType_1 = this.expandedTypeToJavaType(type);
            _builder_1.append((Object)_expandedTypeToJavaType_1);
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    private JavaClass expandedTypeToJavaType(ExpandedType type) {
        if (Objects.equals(type.getName(), RosettaAttributeExtensions.METAFIELDS_CLASS_NAME) || Objects.equals(type, RosettaAttributeExtensions.META_AND_TEMPLATE_FIELDS_CLASS_NAME)) {
            DottedPath _child = this.packages.defaultNamespace().child("metafields");
            String _name = type.getName();
            return new GeneratedJavaClass(_child, _name, Object.class);
        }
        boolean _isMetaType = type.isMetaType();
        if (_isMetaType) {
            return this.typeUtil.STRING;
        }
        boolean _isBuiltInType = type.isBuiltInType();
        if (_isBuiltInType) {
            return this.typeTranslator.toJavaReferenceType(this.builtins.getType(type.getName(), Collections.emptyMap()));
        }
        DottedPath _modelPackage = this.modelPackage(type.getModel());
        String _name_1 = type.getName();
        return new GeneratedJavaClass(_modelPackage, _name_1, Object.class);
    }

    private ExpandedType toExpandedType(RosettaType type) {
        return this.toExpandedType(type);
    }

    private DottedPath modelPackage(RosettaModel model) {
        return DottedPath.splitOnDots((String)model.getName());
    }

    private StringConcatenationClient _toBuilder(final Data type) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _xblockexpression = null;
        boolean _endsWith = type.getName().endsWith("WithMeta");
        if (_endsWith) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _fullname = IngesterGenerator.this.fullname(type);
                    _builder.append((Object)_fullname);
                    _builder.append((Object)".");
                    String _name = type.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)"Builder");
                    String _firstUpper = StringExtensions.toFirstUpper((String)type.getDefinition());
                    _builder.append((Object)_firstUpper);
                }
            };
            return _client;
        }
        _xblockexpression = _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _fullname = IngesterGenerator.this.fullname(type);
                _builder.append((Object)_fullname);
                _builder.append((Object)".");
                String _name = type.getName();
                _builder.append((Object)_name);
                _builder.append((Object)"Builder");
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient _toBuilder(final RosettaEnumeration type) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name = type.getName();
                _builder.append((Object)_name);
            }
        };
        return _client;
    }

    private StringConcatenationClient _toBuilder(final RosettaBuiltinType type) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Optional _type = IngesterGenerator.this.builtins.getType(type.getName(), (Map)CollectionLiterals.newHashMap());
                _builder.append((Object)_type);
            }
        };
        return _client;
    }

    private StringConcatenationClient _toBuilder(RosettaTypeAlias type) {
        return this.toBuilder((EObject)type.getTypeCall().getType());
    }

    private String fullname(Data type) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = type.getModel().getName();
        _builder.append(_name);
        _builder.append(".");
        String _name_1 = type.getName();
        _builder.append(_name_1);
        return _builder.toString();
    }

    private String pathConstants(SynonymMap mapping) {
        LinkedHashSet<SynonymGroup> svs = new LinkedHashSet<SynonymGroup>();
        Functions.Function1 _function = it -> it.getSynonymGroups();
        Iterables.addAll(svs, (Iterable)IterableExtensions.flatMap(mapping.attributeGroups(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            List<SynonymValue> _singletonList = Collections.singletonList(it);
            List<SynonymCondition> _emptyList = Collections.emptyList();
            return new SynonymGroup(_singletonList, _emptyList, null, null, null, null, false);
        };
        Iterables.addAll(svs, (Iterable)IterableExtensions.map((Iterable)mapping.getConditionalCaptures().keySet(), (Functions.Function1)_function_1));
        return this.pathConstants(svs);
    }

    private String pathConstants(Iterable<SynonymGroup> sgs) {
        Functions.Function1 _function = it -> it.getSynonymValues();
        Functions.Function1 _function_1 = it -> this.toPathName((SynonymValue)it);
        Functions.Function1 _function_2 = synonymValue -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("private final static ImmutableList<String> ");
            String _pathName = this.toPathName((SynonymValue)synonymValue);
            _builder.append(_pathName);
            _builder.append("Path = ImmutableList.of(");
            CharSequence _list = this.list(synonymValue.getSynonymPath());
            _builder.append((Object)_list);
            _builder.append(");");
            return _builder.toString();
        };
        return IterableExtensions.join((Iterable)IterableUtil.distinct((Iterable)ListExtensions.map((List)IterableExtensions.sortBy((Iterable)IterableExtensions.flatMap(sgs, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2)), (CharSequence)"\n");
    }

    private CharSequence conditionalValues(SynonymMap mapping) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toAttPathName((AttributeGroup)it);
        List groups = IterableExtensions.sortBy(mapping.attributeGroups(), (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> !it_1.getSynonymValues().isEmpty() && IterableExtensions.exists(it_1.getConditions(), it_2 -> {
                boolean _isEmpty = it_2.getCondition().isEmpty();
                return !_isEmpty;
            });
            return IterableExtensions.exists(it.getSynonymGroups(), (Functions.Function1)_function_2);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)groups, (Functions.Function1)_function_1);
        for (AttributeGroup group : _filter) {
            _builder.append("protected Map<Path, ");
            CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(group.getAttributePath())).getType());
            _builder.append((Object)_expandedTypeToBuilder);
            _builder.append("> ");
            String _attPathName = this.toAttPathName(group);
            _builder.append(_attPathName);
            _builder.append("Values = new LinkedHashMap<>();");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_2 = it -> this.toPathName((SynonymValue)it.getKey());
        List _sortBy = IterableExtensions.sortBy(mapping.getConditionalCaptures().asMap().entrySet(), (Functions.Function1)_function_2);
        for (Map.Entry e : _sortBy) {
            Functions.Function1 _function_3 = it -> {
                Cardinality _cardinality = it.getCardinality();
                return _cardinality == Cardinality.MULTIPLE;
            };
            boolean _exists = IterableExtensions.exists(((SynonymValue)e.getKey()).getSynonymPath(), (Functions.Function1)_function_3);
            if (_exists) {
                _builder.append("protected Map<Path, String> ");
                String _pathName = this.toPathName((SynonymValue)e.getKey());
                _builder.append(_pathName);
                _builder.append("Values = new HashMap<>();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("protected String ");
            String _pathName_1 = this.toPathName((SynonymValue)e.getKey());
            _builder.append(_pathName_1);
            _builder.append("Value;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence handlerCaches(SynonymMap mapping, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// basic");
        _builder.newLine();
        CharSequence _basicTypeCaches = this.basicTypeCaches(mapping);
        _builder.append((Object)_basicTypeCaches);
        _builder.newLineIfNotEmpty();
        _builder.append("// rosetta");
        _builder.newLine();
        CharSequence _rosettaTypeCaches = this.rosettaTypeCaches(mapping, packageName);
        _builder.append((Object)_rosettaTypeCaches);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence basicTypeCaches(SynonymMap mapping) {
        CharSequence _xblockexpression = null;
        Functions.Function1 _function = it -> {
            boolean _isClassOrData = this.isClassOrData(it.getMappings().getRosetta());
            return !_isClassOrData;
        };
        Functions.Function1 _function_1 = it -> it.getGroup();
        Iterable attrPathSynGroups = IterableExtensions.map((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> {
            int _size = it.getAttributePath().size();
            return _size > 1;
        };
        Functions.Function1 _function_3 = it -> this.toAttPathName(this.toFirstMultiple((AttributeGroup)it));
        Map chopped = IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)attrPathSynGroups, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        _xblockexpression = this.handlerCache(chopped);
        return _xblockexpression;
    }

    private ArrayList<ExpandedAttribute> toFirstMultiple(AttributeGroup group) {
        return this.toFirstMultiple(group.getAttributePath());
    }

    private ArrayList<ExpandedAttribute> toFirstMultiple(Iterable<ExpandedAttribute> atts) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        boolean multiple = false;
        int i = 0;
        while (!multiple && i <= IterableExtensions.size(atts) - 2) {
            int _plusPlus = i++;
            ExpandedAttribute att = ((ExpandedAttribute[])Conversions.unwrapArray(atts, ExpandedAttribute.class))[_plusPlus];
            result.add(att);
            multiple = att.isMultiple();
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private CharSequence handlerCache(Map<String, List<AttributeGroup>> attributeGroupMap) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> this.toAttPathName((AttributeGroup)it_1);
            return this.toAttPathName((AttributeGroup)IterableExtensions.lastOrNull((Iterable)IterableExtensions.sortBy((Iterable)((Iterable)it.getValue()), (Functions.Function1)_function_1)));
        };
        List _sortBy = IterableExtensions.sortBy(attributeGroupMap.entrySet(), (Functions.Function1)_function);
        for (Map.Entry attrPathSynGroups : _sortBy) {
            Functions.Function1 _function_1 = it -> this.removeLast((AttributeGroup)it);
            Functions.Function1 _function_2 = it -> this.multipleCardinality((AttributeGroup)it);
            boolean _exists = IterableExtensions.exists((Iterable)ListExtensions.map((List)((List)attrPathSynGroups.getValue()), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
            if (_exists) {
                _builder.append("protected HandlerCache<");
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(this.toFirstMultiple((AttributeGroup)IterableExtensions.lastOrNull((Iterable)((Iterable)attrPathSynGroups.getValue()))))).getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append("> ");
                String _key = (String)attrPathSynGroups.getKey();
                _builder.append(_key);
                _builder.append("Underlyers =");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("new HandlerCache<>(ImmutableMultimap.<String, SynonymValueGroup>builder()");
                _builder.newLine();
                List _sort = IterableExtensions.sort((Iterable)((Iterable)attrPathSynGroups.getValue()));
                for (AttributeGroup attrPathSynGroup : _sort) {
                    Functions.Function1 _function_3 = it -> this.toSVG((SynonymGroup)it);
                    List _sortBy_1 = IterableExtensions.sortBy(attrPathSynGroup.getSynonymGroups(), (Functions.Function1)_function_3);
                    for (SynonymGroup sg : _sortBy_1) {
                        _builder.append("\t\t\t");
                        _builder.append(".put(\"");
                        String _attributeName = AttributeGroup.attributeName((ExpandedAttribute)IterableExtensions.lastOrNull(attrPathSynGroup.getAttributePath()));
                        _builder.append(_attributeName, "\t\t\t");
                        _builder.append("\", new SynonymValueGroup(");
                        String _sVG = this.toSVG(sg);
                        _builder.append(_sVG, "\t\t\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t\t\t");
                _builder.append(".build());");
                _builder.newLine();
                continue;
            }
            _builder.append("protected AnonHandler<");
            CharSequence _expandedTypeToBuilder_1 = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(this.removeLast(((AttributeGroup)IterableExtensions.lastOrNull((Iterable)((Iterable)attrPathSynGroups.getValue()))).getAttributePath()))).getType());
            _builder.append((Object)_expandedTypeToBuilder_1);
            _builder.append("> ");
            String _attPathName = this.toAttPathName(this.removeLast((AttributeGroup)IterableExtensions.lastOrNull((Iterable)((Iterable)attrPathSynGroups.getValue()))));
            _builder.append(_attPathName);
            _builder.append("UnderlyerB;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence rosettaTypeCaches(SynonymMap mapping, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.isClassOrData(it.getMappings().getRosetta());
        Functions.Function1 _function_1 = it -> this.toAttPathName(it.getGroup());
        List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (AttributeGroupMapping mappedGroup : _sortBy) {
            boolean _multipleCardinality = this.multipleCardinality(mappedGroup.getGroup());
            if (_multipleCardinality) {
                _builder.append("protected HandlerCache<");
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(mappedGroup.getGroup().getAttributePath())).getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append("> ");
                CharSequence _handlerFieldName = this.toHandlerFieldName(mappedGroup.getGroup());
                _builder.append((Object)_handlerFieldName);
                _builder.append(" =");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("new HandlerCache<>(ImmutableMultimap.<String, SynonymValueGroup>builder()");
                _builder.newLine();
                Functions.Function1 _function_2 = it -> this.toSVG((SynonymGroup)it);
                List _sortBy_1 = IterableExtensions.sortBy(mappedGroup.getGroup().getSynonymGroups(), (Functions.Function1)_function_2);
                for (SynonymGroup sg : _sortBy_1) {
                    _builder.append("\t\t\t\t");
                    _builder.append(".put(\"");
                    String _attributeName = AttributeGroup.attributeName((ExpandedAttribute)IterableExtensions.lastOrNull(mappedGroup.getGroup().getAttributePath()));
                    _builder.append(_attributeName, "\t\t\t\t");
                    _builder.append("\", new SynonymValueGroup(");
                    String _sVG = this.toSVG(sg);
                    _builder.append(_sVG, "\t\t\t\t");
                    _builder.append("))");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t\t\t");
                _builder.append(".build());");
                _builder.newLine();
                continue;
            }
            Functions.Function1 _function_3 = it -> it.getConditions().isEmpty();
            boolean _exists = IterableExtensions.exists(mappedGroup.getGroup().getSynonymGroups(), (Functions.Function1)_function_3);
            if (!_exists) continue;
            _builder.append("protected ");
            CharSequence _pFullNameT = this.pFullNameT(mappedGroup.getMappings(), packageName);
            _builder.append((Object)_pFullNameT);
            _builder.append(" ");
            CharSequence _handlerFieldName_1 = this.toHandlerFieldName(mappedGroup.getGroup());
            _builder.append((Object)_handlerFieldName_1);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String toSVG(SynonymGroup group) {
        boolean _isEmpty = group.getSynonymValues().isEmpty();
        if (_isEmpty) {
            Functions.Function1 _function = it -> it.getCondition();
            Functions.Function1 _function_1 = it -> it.getPathWithDots();
            Iterable pathExprs = IterableExtensions.map((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(group.getConditions(), (Functions.Function1)_function)), SynonymPathTest.class), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> it.getCondition();
            Functions.Function1 _function_3 = it -> it.getPaths();
            Functions.Function1 _function_4 = p -> {
                Functions.Function1 _function_5 = it -> it.getName();
                return IterableExtensions.join((Iterable)ListExtensions.map(p.getSynonymPath(), (Functions.Function1)_function_5), (CharSequence)".");
            };
            Iterable binExprs = IterableExtensions.map((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(group.getConditions(), (Functions.Function1)_function_2)), SynonymBinaryTest.class), (Functions.Function1)_function_3)), (Functions.Function1)_function_4);
            Functions.Function1 _function_5 = it -> it;
            return IterableExtensions.join((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)CollectionLiterals.newArrayList((Object[])new Iterable[]{pathExprs, binExprs}))), (CharSequence)"\"", (CharSequence)"\", \"", (CharSequence)"\"", (Functions.Function1)_function_5);
        }
        Functions.Function1 _function_6 = it -> this.toFirstLeaf(it.getSynonymPath());
        Functions.Function1 _function_7 = p -> {
            Functions.Function1 _function_8 = e -> e.getName();
            return IterableExtensions.join((Iterable)ListExtensions.map((List)p, (Functions.Function1)_function_8), (CharSequence)".");
        };
        return IterableExtensions.join((Iterable)ListExtensions.map(group.getSynonymValues(), (Functions.Function1)_function_6), (CharSequence)"\"", (CharSequence)"\", \"", (CharSequence)"\"", (Functions.Function1)_function_7);
    }

    private CharSequence toHandlerFieldName(AttributeGroup attrPathSynGroup) {
        String _xifexpression = null;
        boolean _multipleCardinality = this.multipleCardinality(attrPathSynGroup);
        _xifexpression = _multipleCardinality ? "Handlers" : "Handler";
        String handlerSuffix = _xifexpression;
        String _attPathName = this.toAttPathName(attrPathSynGroup);
        return _attPathName + handlerSuffix;
    }

    private String toHandlerMethodName(AttributeGroup attrPathSynGroup) {
        String _attPathName = this.toAttPathName(attrPathSynGroup);
        return _attPathName + "Handler";
    }

    private CharSequence toCondHandlerMethodName(AttributeGroup attrPathSynGroup) {
        String _attPathName = this.toAttPathName(attrPathSynGroup);
        return _attPathName + "ConditionalHandler";
    }

    private String toConditionalHandlerMethodName(SynonymValue synonymValue) {
        String _pathName = this.toPathName(synonymValue);
        return _pathName + "ConditionalCaptureHandler";
    }

    private CharSequence toMappingProcessorMethodName(AttributeGroup attrPathSynGroup, SynonymGroup group) {
        String _attPathName = this.toAttPathName(attrPathSynGroup);
        Functions.Function1 _function = it -> it.getSynonymPath();
        Functions.Function1 _function_1 = it -> it.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(group.getSynonymValues(), (Functions.Function1)_function), (Functions.Function1)_function_1)));
        String _plus = _attPathName + _firstUpper;
        return _plus + "MappingProcessor";
    }

    private Set<String> toSynonymLastElementName(SynonymGroup group) {
        Functions.Function1 _function = it -> it.getSynonymPath();
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> it_1.getName();
            return (String)IterableExtensions.lastOrNull((Iterable)ListExtensions.map((List)it, (Functions.Function1)_function_2));
        };
        return IterableExtensions.toSet((Iterable)ListExtensions.map((List)ListExtensions.map(group.getSynonymValues(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private ArrayList<Element> toFirstLeaf(List<Element> elements) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        boolean isLeaf = false;
        int i = 0;
        while (!isLeaf && i < elements.size()) {
            int _plusPlus = i++;
            Element e = elements.get(_plusPlus);
            result.add(e);
            isLeaf = false;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private boolean multipleCardinality(AttributeGroup attrPathSynGroup) {
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        return IterableExtensions.exists(attrPathSynGroup.getAttributePath(), (Functions.Function1)_function);
    }

    private boolean multipleCardinality(List<ExpandedAttribute> attributePath) {
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        return IterableExtensions.exists(attributePath, (Functions.Function1)_function);
    }

    private boolean getterMultipleCardinality(List<ExpandedAttribute> attributePath) {
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        return IterableExtensions.exists(this.removeLast(attributePath), (Functions.Function1)_function);
    }

    private String toAttPathName(AttributeGroup attrPathSynGroup) {
        return this.toAttPathName(attrPathSynGroup.getAttributePath());
    }

    private String toAttPathName(List<ExpandedAttribute> attributePath) {
        Functions.Function1 _function = s -> AttributeGroup.attributeName(s);
        return StringExtensions.toFirstLower((String)IterableExtensions.join((Iterable)ListExtensions.map(attributePath, (Functions.Function1)_function), (CharSequence)""));
    }

    private CharSequence list(List<Element> path) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = s -> s.getName();
        List _map = ListExtensions.map(path, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (String string : _map) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append("\"");
            _builder.append(string);
            _builder.append("\"");
        }
        return _builder;
    }

    private <T extends RosettaModelObject> CharSequence constructor(SynonymMap mapping) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAbstract = this.isAbstract(mapping.getRosetta());
        boolean bl = _not = !_isAbstract;
        if (_not) {
            _builder.append("@SuppressWarnings(\"unchecked\")");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        CharSequence _pNameW = this.pNameW(mapping);
        _builder.append((Object)_pNameW);
        _builder.append("(Injector injector, MappingContext mappingContext) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super(injector, mappingContext);");
        _builder.newLine();
        _builder.append("\t");
        boolean _isAbstract_1 = this.isAbstract(mapping.getRosetta());
        boolean bl2 = _not_1 = !_isAbstract_1;
        if (_not_1) {
            _builder.append("setUnderlying((T)new BuilderProxy());");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handlers = ImmutableMultimap.<List<String>, HandlerSupplier>builder()");
        _builder.newLine();
        SynonymMap _superMap = mapping.getSuperMap();
        boolean bl3 = _tripleNotEquals = _superMap != null;
        if (_tripleNotEquals) {
            _builder.append("\t\t");
            _builder.append(".putAll(super.handlers)");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// unconditional handlers");
        _builder.newLine();
        List<SynonymAttributePath> _unconditionalHandlerPaths = this.unconditionalHandlerPaths(mapping);
        for (SynonymAttributePath path : _unconditionalHandlerPaths) {
            _builder.append("\t\t");
            _builder.append(".put(");
            String _synonymPath = path.getSynonymPath();
            _builder.append(_synonymPath, "\t\t");
            _builder.append("Path, this::");
            String _attributePath = path.getAttributePath();
            _builder.append(_attributePath, "\t\t");
            _builder.append("Handler_");
            int _index = path.getIndex();
            _builder.append((Object)_index, "\t\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("// conditional handlers");
        _builder.newLine();
        List<SynonymAttributePath> _conditionalHandlerPaths = this.conditionalHandlerPaths(mapping);
        for (SynonymAttributePath path_1 : _conditionalHandlerPaths) {
            _builder.append("\t\t");
            _builder.append(".put(");
            String _synonymPath_1 = path_1.getSynonymPath();
            _builder.append(_synonymPath_1, "\t\t");
            _builder.append("Path, this::");
            String _attributePath_1 = path_1.getAttributePath();
            _builder.append(_attributePath_1, "\t\t");
            _builder.append("ConditionalHandler)");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("// conditional captures");
        _builder.newLine();
        List _sort = IterableExtensions.sort((Iterable)IterableUtil.distinct(this.condCaptures(mapping)));
        for (String conditional : _sort) {
            _builder.append("\t\t");
            _builder.append(conditional, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append(".build();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mappingProcessors = ImmutableMultimap.<List<String>, MappingProcessorSupplier>builder()");
        _builder.newLine();
        SynonymMap _superMap_1 = mapping.getSuperMap();
        boolean bl4 = _tripleNotEquals_1 = _superMap_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append("\t\t");
            _builder.append(".putAll(super.mappingProcessors)");
            _builder.newLine();
        }
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                String _mapperName = it_1.getMapperName();
                return _mapperName != null;
            };
            return IterableExtensions.exists(it.getSynonymGroups(), (Functions.Function1)_function_1);
        };
        List _sort_1 = IterableExtensions.sort((Iterable)IterableExtensions.filter(mapping.attributeGroups(), (Functions.Function1)_function));
        for (AttributeGroup attrPathSynGroup : _sort_1) {
            Functions.Function1 _function_1 = it -> {
                String _mapperName = it.getMapperName();
                return _mapperName != null;
            };
            Iterable _filter = IterableExtensions.filter(attrPathSynGroup.getSynonymGroups(), (Functions.Function1)_function_1);
            for (SynonymGroup mapperSynGroup : _filter) {
                Function<SynonymValue, String> _function_2 = it -> this.toPathName((SynonymValue)it);
                Functions.Function1 _function_3 = it -> this.toPathName((SynonymValue)it);
                List _sortBy = IterableExtensions.sortBy((Iterable)IterableUtil.distinctBy(mapperSynGroup.getSynonymValues(), _function_2), (Functions.Function1)_function_3);
                for (SynonymValue synonymValue : _sortBy) {
                    _builder.append("\t\t");
                    _builder.append(".put(");
                    String _pathName = this.toPathName(synonymValue);
                    _builder.append(_pathName, "\t\t");
                    _builder.append("Path, this::");
                    CharSequence _mappingProcessorMethodName = this.toMappingProcessorMethodName(attrPathSynGroup, mapperSynGroup);
                    _builder.append((Object)_mappingProcessorMethodName, "\t\t");
                    _builder.append(")");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.append("\t\t");
        _builder.append(".build();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private List<SynonymAttributePath> unconditionalHandlerPaths(SynonymMap mapping) {
        ArrayList paths = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                Functions.Function1 _function_2 = it_2 -> it_2.getCondition().isEmpty();
                return IterableExtensions.forall(it_1.getConditions(), (Functions.Function1)_function_2);
            };
            return IterableExtensions.exists(it.getSynonymGroups(), (Functions.Function1)_function_1);
        };
        List _sort = IterableExtensions.sort((Iterable)IterableExtensions.filter(mapping.attributeGroups(), (Functions.Function1)_function));
        for (AttributeGroup attrPathSynGroup : _sort) {
            Procedures.Procedure2 _function_1 = (sg, i) -> {
                Integer _xblockexpression = null;
                ExpandedAttribute last = (ExpandedAttribute)IterableExtensions.lastOrNull(attrPathSynGroup.getAttributePath());
                Integer _xifexpression = null;
                _xifexpression = last.getType().isType() || Objects.equals(last.getType().getName(), "RosettaReference") ? Integer.valueOf(0) : i;
                Integer index = _xblockexpression = _xifexpression;
                if (!sg.getSynonymValues().isEmpty() && IterableExtensions.forall(sg.getConditions(), it -> it.getCondition().isEmpty())) {
                    Function<SynonymValue, String> _function_2 = it -> this.toPathName((SynonymValue)it);
                    Functions.Function1 _function_3 = it -> this.toPathName((SynonymValue)it);
                    Consumer<SynonymValue> _function_4 = sv -> {
                        String _pathName = this.toPathName((SynonymValue)sv);
                        String _attPathName = this.toAttPathName(attrPathSynGroup);
                        SynonymAttributePath _synonymAttributePath = new SynonymAttributePath(_pathName, _attPathName, index);
                        paths.add(_synonymAttributePath);
                    };
                    IterableExtensions.sortBy((Iterable)IterableUtil.distinctBy(sg.getSynonymValues(), _function_2), (Functions.Function1)_function_3).forEach(_function_4);
                }
            };
            IterableExtensions.forEach(attrPathSynGroup.getSynonymGroups(), (Procedures.Procedure2)_function_1);
        }
        return IterableExtensions.sort((Iterable)paths);
    }

    private List<SynonymAttributePath> conditionalHandlerPaths(SynonymMap mapping) {
        ArrayList paths = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                Functions.Function1 _function_2 = it_2 -> {
                    boolean _isEmpty = it_2.getCondition().isEmpty();
                    return !_isEmpty;
                };
                return IterableExtensions.exists(it_1.getConditions(), (Functions.Function1)_function_2);
            };
            return IterableExtensions.exists(it.getSynonymGroups(), (Functions.Function1)_function_1);
        };
        List _sort = IterableExtensions.sort((Iterable)IterableExtensions.filter(mapping.attributeGroups(), (Functions.Function1)_function));
        for (AttributeGroup attrPathSynGroup : _sort) {
            Functions.Function1 _function_1 = it -> !it.getSynonymValues().isEmpty() && IterableExtensions.exists(it.getConditions(), it_1 -> {
                boolean _isEmpty = it_1.getCondition().isEmpty();
                return !_isEmpty;
            });
            Functions.Function1 _function_2 = sg -> sg.getSynonymValues();
            Function<SynonymValue, String> _function_3 = it -> this.toPathName((SynonymValue)it);
            Functions.Function1 _function_4 = it -> this.toPathName((SynonymValue)it);
            List _sortBy = IterableExtensions.sortBy((Iterable)IterableUtil.distinctBy((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter(attrPathSynGroup.getSynonymGroups(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), _function_3), (Functions.Function1)_function_4);
            for (SynonymValue synonymValue : _sortBy) {
                String _pathName = this.toPathName(synonymValue);
                String _attPathName = this.toAttPathName(attrPathSynGroup);
                SynonymAttributePath _synonymAttributePath = new SynonymAttributePath(_pathName, _attPathName, 0);
                paths.add(_synonymAttributePath);
            }
        }
        return IterableExtensions.sort((Iterable)paths);
    }

    private Iterable<String> condCaptures(SynonymMap mapping) {
        Functions.Function1 _function = it -> this.toPathName((SynonymValue)it);
        Functions.Function1 _function_1 = name -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".put(");
            _builder.append(name);
            _builder.append("Path, this::");
            _builder.append(name);
            _builder.append("ConditionalCaptureHandler)");
            return _builder.toString();
        };
        return IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)mapping.getConditionalCaptures().keySet(), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    private CharSequence handler(AttributeGroupMapping mappedGroup, SynonymMap mapping, String packageName) {
        CharSequence _xblockexpression = null;
        ExpandedAttribute last = (ExpandedAttribute)IterableExtensions.lastOrNull(mappedGroup.getGroup().getAttributePath());
        CharSequence _xifexpression = null;
        if (!last.getType().isType() && !Objects.equals(last.getType().getName(), "RosettaReference")) {
            ArrayList handlers = CollectionLiterals.newArrayList();
            Procedures.Procedure2 _function = (sg, i) -> {
                boolean _isEnumeration = last.getType().isEnumeration();
                if (_isEnumeration) {
                    CharSequence _basicHandler = this.basicHandler(mappedGroup, mapping, this.pFullNameT(last.getType(), packageName), (int)i);
                    handlers.add(_basicHandler);
                } else {
                    CharSequence _basicHandler_1 = this.basicHandler(mappedGroup, mapping, StringExtensions.toFirstUpper((String)last.getType().getName()), (int)i);
                    handlers.add(_basicHandler_1);
                }
            };
            IterableExtensions.forEach(mappedGroup.getGroup().getSynonymGroups(), (Procedures.Procedure2)_function);
            return IterableExtensions.join((Iterable)handlers, (CharSequence)"\n");
        }
        _xifexpression = this.romHandler(mappedGroup, mapping, packageName);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean isClassOrData(RosettaType t) {
        return t instanceof Data;
    }

    private CharSequence nestedSetToHandler(List<ExpandedAttribute> attributePath, SynonymMap mapping, Set<String> alreadyGenerated) {
        StringConcatenation _xblockexpression = null;
        int _size = attributePath.size();
        int _minus = _size - 1;
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        boolean multiple = IterableExtensions.exists((Iterable)IterableExtensions.take(attributePath, (int)_minus), (Functions.Function1)_function);
        String _attPathName = this.toAttPathName(this.removeLast(attributePath));
        String underlyerAttrName = _attPathName + "UnderlyerB";
        StringConcatenation _xifexpression = null;
        if (!multiple && alreadyGenerated.add(underlyerAttrName)) {
            StringConcatenation _xblockexpression_1 = null;
            Object underlyerType = this.firstMultipleBuilder(attributePath, mapping);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("protected AnonHandler<");
            _builder.append(underlyerType);
            _builder.append("> get");
            String _firstUpper = StringExtensions.toFirstUpper((String)underlyerAttrName);
            _builder.append(_firstUpper);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// nested (set-to conditional mapping with path predicate) anon handler");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return ");
            _builder.append(underlyerAttrName, "\t");
            _builder.append(" != null ?");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append(underlyerAttrName, "\t\t");
            _builder.append(" :");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("useOrNew(");
            _builder.append(underlyerAttrName, "\t\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("() -> {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append(underlyerType, "\t\t\t\t");
            _builder.append(" chainBuilder;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
            CharSequence _builderChain = this.builderChain(attributePath, mapping);
            _builder.append((Object)_builderChain, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
            _builder.append("return new AnonHandler<>(injector, mappingContext, rosettaPath, chainBuilder);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("});");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence condHandler(AttributeGroupMapping mappedGroup, SynonymMap mapping, String envName) {
        CharSequence _xblockexpression = null;
        ExpandedType t = ((ExpandedAttribute)IterableExtensions.lastOrNull(mappedGroup.getGroup().getAttributePath())).getType();
        CharSequence _xifexpression = null;
        boolean _isType = t.isType();
        if (_isType) {
            _xifexpression = this.romCondHandler(mappedGroup, mapping, envName);
        } else {
            CharSequence _xifexpression_1 = null;
            boolean _isEnumeration = t.isEnumeration();
            _xifexpression_1 = _isEnumeration ? this.enumCondHandler(mappedGroup, mapping, t, envName) : this.basicCondHandler(mappedGroup, mapping, StringExtensions.toFirstUpper((String)t.getName()));
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence builderChain(List<ExpandedAttribute> attributePath, SynonymMap mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Path rosettaPath = getRosettaPath();");
        _builder.newLine();
        ArrayList<ExpandedAttribute> attList = this.toFirstMultiple(attributePath);
        _builder.newLineIfNotEmpty();
        Object lastBuilderName = "getUnderlying()";
        _builder.newLineIfNotEmpty();
        Object nextBuilderName = "";
        _builder.newLineIfNotEmpty();
        for (ExpandedAttribute att : attList) {
            boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)att);
            if (_cardinalityIsListValue) {
                _builder.append("int ");
                String _name = att.getName();
                _builder.append(_name);
                _builder.append("Index = getMappingListIndex(");
                _builder.append((String)lastBuilderName);
                _builder.append(".get");
                String _firstUpper = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper);
                _builder.append("(), ");
                CharSequence _asList = this.asList(this.mergeSynonyms(attributePath, mapping));
                _builder.append((Object)_asList);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append(" ");
                String _firstLower = StringExtensions.toFirstLower((String)att.getType().getName());
                String _plus = _firstLower + "Builder";
                nextBuilderName = _plus;
                String _nextBuilderName = nextBuilderName;
                _builder.append(_nextBuilderName);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_1);
                _builder.append("(");
                String _name_1 = att.getName();
                _builder.append(_name_1);
                _builder.append("Index);");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_2 = att.getName();
                _builder.append(_name_2);
                _builder.append("\", ");
                String _name_3 = att.getName();
                _builder.append(_name_3);
                _builder.append("Index));");
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _expandedTypeToBuilder_1 = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder_1);
                _builder.append(" ");
                String _firstLower_1 = StringExtensions.toFirstLower((String)att.getType().getName());
                String _plus_1 = _firstLower_1 + "Builder";
                nextBuilderName = _plus_1;
                String _nextBuilderName_1 = nextBuilderName;
                _builder.append(_nextBuilderName_1);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_2);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_4 = att.getName();
                _builder.append(_name_4);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
            }
            String _xblockexpression = null;
            lastBuilderName = nextBuilderName;
            _xblockexpression = "";
            _builder.append(_xblockexpression);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("chainBuilder = (");
        Object _firstMultipleBuilder = this.firstMultipleBuilder(attributePath, mapping);
        _builder.append(_firstMultipleBuilder);
        _builder.append(")");
        _builder.append((String)lastBuilderName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public List<RosettaMergeSynonymValue> mergeSynonyms(List<ExpandedAttribute> attributePath, SynonymMap mapping) {
        Functions.Function1 _function = it -> {
            List<ExpandedAttribute> _attributePath = it.getGroup().getAttributePath();
            return _attributePath == attributePath;
        };
        Functions.Function1 _function_1 = it -> it.getMappings().getMergeSynonyms().values();
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter(mapping.getMappedGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public CharSequence asList(List<RosettaMergeSynonymValue> mergeSyns) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.Arrays.asList(");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("new com.regnosys.rosetta.translate.MergeSynonymValue(\"");
            String _name = it.getName();
            _builder_1.append(_name);
            _builder_1.append("\", \"");
            String _excludePath = it.getExcludePath();
            _builder_1.append(_excludePath);
            _builder_1.append("\")");
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(mergeSyns, (Functions.Function1)_function), (CharSequence)",");
        _builder.append(_join);
        _builder.append(")");
        return _builder;
    }

    public CharSequence postAnon(AttributeGroup group, SynonymMap mapping) {
        StringConcatenation _xblockexpression = null;
        List<ExpandedAttribute> afterMultiple = this.postFirstMultiple(group);
        Object lastBuilderName = "foundbuilder.getUnderlying()";
        String nextBuilderName = null;
        StringConcatenation _builder = new StringConcatenation();
        List<ExpandedAttribute> _removeLast = this.removeLast(afterMultiple);
        for (ExpandedAttribute att : _removeLast) {
            boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)att);
            if (_cardinalityIsListValue) {
                String _plus;
                _builder.append("int ");
                String _name = att.getName();
                _builder.append(_name);
                _builder.append("Index = sizeOf(");
                _builder.append((String)lastBuilderName);
                _builder.append(".get");
                String _firstUpper = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper);
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append(" ");
                String _firstLower = StringExtensions.toFirstLower((String)att.getType().getName());
                String _nextBuilderName = nextBuilderName = (_plus = _firstLower + "Builder");
                _builder.append(_nextBuilderName);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_1);
                _builder.append("(");
                String _name_1 = att.getName();
                _builder.append(_name_1);
                _builder.append("Index);");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_2 = att.getName();
                _builder.append(_name_2);
                _builder.append("\", ");
                String _name_3 = att.getName();
                _builder.append(_name_3);
                _builder.append("Index));");
                _builder.newLineIfNotEmpty();
            } else {
                String _plus_1;
                CharSequence _expandedTypeToBuilder_1 = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder_1);
                _builder.append(" ");
                String _firstLower_1 = StringExtensions.toFirstLower((String)att.getType().getName());
                String _nextBuilderName_1 = nextBuilderName = (_plus_1 = _firstLower_1 + "Builder");
                _builder.append(_nextBuilderName_1);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_2);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_4 = att.getName();
                _builder.append(_name_4);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
            }
            String _xblockexpression_1 = null;
            lastBuilderName = nextBuilderName;
            _xblockexpression_1 = "";
            _builder.append(_xblockexpression_1);
            _builder.newLineIfNotEmpty();
        }
        Object _penultimateBuilder = this.penultimateBuilder(group.getAttributePath(), mapping);
        _builder.append(_penultimateBuilder);
        _builder.append(" builder = ");
        _builder.append((String)lastBuilderName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected List<ExpandedAttribute> postFirstMultiple(AttributeGroup group) {
        return group.getAttributePath().subList(this.toFirstMultiple(group).size(), group.getAttributePath().size());
    }

    protected List<ExpandedAttribute> postFirstMultiple(List<ExpandedAttribute> attributePath) {
        return attributePath.subList(this.toFirstMultiple(attributePath).size(), attributePath.size());
    }

    private CharSequence conditionalCaptureHandler(Map.Entry<SynonymValue, Collection<SynonymCondition>> sv, SynonymMap mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private StringParseHandler ");
        String _conditionalHandlerMethodName = this.toConditionalHandlerMethodName(sv.getKey());
        _builder.append(_conditionalHandlerMethodName);
        _builder.append("(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = e -> e.getEntity() != null && e.getCardinality() == Cardinality.MULTIPLE;
        boolean _exists = IterableExtensions.exists(sv.getKey().getSynonymPath(), (Functions.Function1)_function);
        if (_exists) {
            Functions.Function1 _function_1 = c -> {
                Functions.Function1 _function_2 = c2 -> c2 instanceof SynonymExistsTest || c2 instanceof SynonymAbsentTest;
                return IterableExtensions.forall(c.getCondition(), (Functions.Function1)_function_2);
            };
            boolean _forall = IterableExtensions.forall((Iterable)sv.getValue(), (Functions.Function1)_function_1);
            if (_forall) {
                _builder.append("\t");
                String _pathName = this.toPathName(sv.getKey());
                _builder.append(_pathName, "\t");
                _builder.append("Values.put(localPath, \"Exists\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("StringParseHandler res = new StringParseHandler(true, true);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("res.setParentSetter(a -> {});");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("res.setParentSupplier(() -> Optional.empty());");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("return res;");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("StringParseHandler handler = new StringParseHandler(true, true);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("useConditionalCache(handler, localPath, ");
                String _pathName_1 = this.toPathName(sv.getKey());
                _builder.append(_pathName_1, "\t");
                _builder.append("Values);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return handler;");
                _builder.newLine();
            }
        } else {
            Functions.Function1 _function_2 = c -> {
                Functions.Function1 _function_3 = c2 -> c2 instanceof SynonymExistsTest || c2 instanceof SynonymAbsentTest;
                return IterableExtensions.forall(c.getCondition(), (Functions.Function1)_function_3);
            };
            boolean _forall_1 = IterableExtensions.forall((Iterable)sv.getValue(), (Functions.Function1)_function_2);
            if (_forall_1) {
                _builder.append("\t");
                String _pathName_2 = this.toPathName(sv.getKey());
                _builder.append(_pathName_2, "\t");
                _builder.append("Value = \"Exists\";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("StringParseHandler res = new StringParseHandler(true, true);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("res.setParentSetter(a -> {});");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("res.setParentSupplier(() -> Optional.empty());");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("return res;");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("StringParseHandler handler = new StringParseHandler(true, true);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("handler.setParentSetter(val -> ");
                String _pathName_3 = this.toPathName(sv.getKey());
                _builder.append(_pathName_3, "\t");
                _builder.append("Value = val);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("handler.setParentSupplier(() -> Optional.ofNullable(");
                String _pathName_4 = this.toPathName(sv.getKey());
                _builder.append(_pathName_4, "\t");
                _builder.append("Value));");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return handler;");
                _builder.newLine();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence basicHandler(AttributeGroupMapping mappedGroup, SynonymMap mapping, CharSequence type, int index) {
        StringConcatenation _xblockexpression = null;
        AttributeGroup attrPathSynGroup = mappedGroup.getGroup();
        ExpandedAttribute lastAttribute = (ExpandedAttribute)IterableExtensions.lastOrNull(attrPathSynGroup.getAttributePath());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        _builder.append((Object)type);
        _builder.append("ParseHandler ");
        String _handlerMethodName = this.toHandlerMethodName(attrPathSynGroup);
        _builder.append(_handlerMethodName);
        _builder.append("_");
        _builder.append((Object)index);
        _builder.append("(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateAnonHandler = this.generateAnonHandler(attrPathSynGroup, mapping, lastAttribute, "localPath", "xmlPath");
        _builder.append((Object)_generateAnonHandler, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append((Object)type, "\t");
        _builder.append("ParseHandler handler = new ");
        CharSequence _basicHandlerConstructor = this.basicHandlerConstructor(type, attrPathSynGroup.getSynonymGroups().get(index));
        _builder.append((Object)_basicHandlerConstructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handler.addXmlPath(xmlPath);");
        _builder.newLine();
        boolean _cardinalityIsSingleValue = RosettaAttributeExtensions.cardinalityIsSingleValue((ExpandedAttribute)lastAttribute);
        if (_cardinalityIsSingleValue) {
            _builder.append("\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name = lastAttribute.getName();
            _builder.append(_name, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("handler.setParentSetter(val -> builder.set");
            String _firstUpper = StringExtensions.toFirstUpper((String)AttributeGroup.attributeName(lastAttribute));
            _builder.append(_firstUpper, "\t");
            _builder.append("(val));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("handler.setParentSupplier(() -> ");
            CharSequence _supplier = this.supplier(mappedGroup.getGroup().getAttributePath());
            _builder.append((Object)_supplier, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("int index = sizeOf(builder.get");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)lastAttribute.getName());
            _builder.append(_firstUpper_1, "\t");
            _builder.append("());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name_1 = lastAttribute.getName();
            _builder.append(_name_1, "\t");
            _builder.append("\", index));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("handler.setParentSetter(val -> builder.add");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)lastAttribute.getName());
            _builder.append(_firstUpper_2, "\t");
            _builder.append("(val));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("handler.setParentSupplier(() -> Optional.empty());");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("handler.setRosettaPath(rosettaPath);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return handler;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence basicHandlerConstructor(CharSequence type, SynonymGroup sg) {
        Functions.Function1 _function = it -> it.getMapsTo();
        Integer _max = this.max(ListExtensions.map(sg.getSynonymValues(), (Functions.Function1)_function), 0);
        boolean _greaterThan = _max > 1;
        return this.basicHandlerConstructor(type, _greaterThan, sg.isRemoveHtml(), sg.getFormatString(), sg.getPatternMatcher(), sg.getPatternReplace());
    }

    public CharSequence basicHandlerConstructor(CharSequence type, List<SynonymGroup> synonymGroups) {
        Functions.Function1 _function = it -> it.getSynonymValues();
        Functions.Function1 _function_1 = it -> it.getMapsTo();
        Integer _max = this.max(IterableExtensions.map((Iterable)IterableExtensions.flatMap(synonymGroups, (Functions.Function1)_function), (Functions.Function1)_function_1), 0);
        boolean _greaterThan = _max > 1;
        Functions.Function1 _function_2 = it -> it.isRemoveHtml();
        Functions.Function1 _function_3 = it -> true;
        Functions.Function1 _function_4 = it -> it.getFormatString();
        Functions.Function1 _function_5 = it -> true;
        Functions.Function1 _function_6 = it -> it.getPatternMatcher();
        Functions.Function1 _function_7 = it -> true;
        Functions.Function1 _function_8 = it -> it.getPatternReplace();
        Functions.Function1 _function_9 = it -> true;
        return this.basicHandlerConstructor(type, _greaterThan, (Boolean)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_4), (Functions.Function1)_function_5), (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_6), (Functions.Function1)_function_7), (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_8), (Functions.Function1)_function_9));
    }

    public CharSequence basicHandlerConstructor(CharSequence type, boolean hasMapsTo, boolean removeHtml, String formatString, String patternMatcher, String patternReplace) {
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (Objects.equals(type, "Date")) {
            _matched = true;
        }
        if (!_matched && Objects.equals(type, "DateTime")) {
            _matched = true;
        }
        if (!_matched && Objects.equals(type, "Time")) {
            _matched = true;
        }
        if (!_matched && Objects.equals(type, "ZonedDateTime")) {
            _matched = true;
        }
        if (_matched) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)type);
            _builder.append("ParseHandler(");
            _builder.append((Object)hasMapsTo);
            _builder.append(", false, ");
            _builder.append((Object)removeHtml);
            if (formatString != null) {
                _builder.append(", \"");
                _builder.append(formatString);
                _builder.append("\"");
            }
            _builder.append(");");
            _switchResult = _builder;
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)type);
            _builder_1.append("ParseHandler(");
            _builder_1.append((Object)hasMapsTo);
            _builder_1.append(", false, ");
            _builder_1.append((Object)removeHtml);
            if (patternMatcher != null) {
                _builder_1.append(", \"");
                _builder_1.append(patternMatcher);
                _builder_1.append("\", \"");
                _builder_1.append(patternReplace);
                _builder_1.append("\" ");
            }
            _builder_1.append(");");
            _switchResult = _builder_1;
        }
        return _switchResult;
    }

    public CharSequence enumHandlerConstructor(ExpandedType type, List<SynonymGroup> synonymGroups, String envName) {
        Functions.Function1 _function = it -> it.getSynonymValues();
        Functions.Function1 _function_1 = it -> it.getMapsTo();
        Integer _max = this.max(IterableExtensions.map((Iterable)IterableExtensions.flatMap(synonymGroups, (Functions.Function1)_function), (Functions.Function1)_function_1), 0);
        boolean _greaterThan = _max > 1;
        Functions.Function1 _function_2 = it -> it.isRemoveHtml();
        Functions.Function1 _function_3 = it -> true;
        Functions.Function1 _function_4 = it -> it.getFormatString();
        Functions.Function1 _function_5 = it -> true;
        Functions.Function1 _function_6 = it -> it.getPatternMatcher();
        Functions.Function1 _function_7 = it -> true;
        Functions.Function1 _function_8 = it -> it.getPatternReplace();
        Functions.Function1 _function_9 = it -> true;
        return this.enumHandlerConstructor(type, _greaterThan, (Boolean)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_4), (Functions.Function1)_function_5), (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_6), (Functions.Function1)_function_7), (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(synonymGroups, (Functions.Function1)_function_8), (Functions.Function1)_function_9), envName);
    }

    public CharSequence enumHandlerConstructor(ExpandedType type, boolean hasMapsTo, boolean removeHtml, String formatString, String patternMatcher, String patternReplace, String envName) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _pFullNameW = this.pFullNameW(type, envName);
        _builder.append((Object)_pFullNameW);
        _builder.append("(");
        _builder.append((Object)hasMapsTo);
        _builder.append(", false, ");
        _builder.append((Object)removeHtml);
        if (patternMatcher != null) {
            _builder.append(", \"");
            _builder.append(patternMatcher);
            _builder.append("\", \"");
            _builder.append(patternReplace);
            _builder.append("\" ");
        }
        _builder.append(");");
        return _builder;
    }

    private <T extends Comparable<T>> T max(Iterable<T> iterable, T defaultVal) {
        Comparable _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(iterable);
        _xifexpression = _isEmpty ? (Comparable)defaultVal : IterableExtensions.max(iterable);
        return (T)_xifexpression;
    }

    private CharSequence enumCondHandler(AttributeGroupMapping mappedGroup, SynonymMap mapping, ExpandedType type, String envName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// enum condition handler");
        _builder.newLine();
        AttributeGroup attrPathSynGroup = mappedGroup.getGroup();
        _builder.newLineIfNotEmpty();
        _builder.append("private ");
        CharSequence _pFullNameW = this.pFullNameW(type, envName);
        _builder.append((Object)_pFullNameW);
        _builder.append(" ");
        CharSequence _condHandlerMethodName = this.toCondHandlerMethodName(attrPathSynGroup);
        _builder.append((Object)_condHandlerMethodName);
        _builder.append("(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _pFullNameW_1 = this.pFullNameW(type, envName);
        _builder.append((Object)_pFullNameW_1, "\t");
        _builder.append(" handler = new ");
        CharSequence _enumHandlerConstructor = this.enumHandlerConstructor(type, attrPathSynGroup.getSynonymGroups(), envName);
        _builder.append((Object)_enumHandlerConstructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handler.addXmlPath(xmlPath);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Path rosettaPath = getRosettaPath();");
        _builder.newLine();
        List<ExpandedAttribute> _attributePath = mappedGroup.getGroup().getAttributePath();
        for (ExpandedAttribute att : _attributePath) {
            _builder.append("\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name = att.getName();
            _builder.append(_name, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("useConditionalCache(handler, localPath, ");
        String _attPathName = this.toAttPathName(mappedGroup.getGroup());
        _builder.append(_attPathName, "\t");
        _builder.append("Values);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handler.setRosettaPath(rosettaPath);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return handler;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence basicCondHandler(AttributeGroupMapping mappedGroup, SynonymMap mapping, String type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// basic type condition handler");
        _builder.newLine();
        AttributeGroup attrPathSynGroup = mappedGroup.getGroup();
        _builder.newLineIfNotEmpty();
        _builder.append("private ");
        _builder.append(type);
        _builder.append("ParseHandler ");
        CharSequence _condHandlerMethodName = this.toCondHandlerMethodName(attrPathSynGroup);
        _builder.append((Object)_condHandlerMethodName);
        _builder.append("(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(type, "\t");
        _builder.append("ParseHandler handler = new ");
        CharSequence _basicHandlerConstructor = this.basicHandlerConstructor((CharSequence)type, attrPathSynGroup.getSynonymGroups());
        _builder.append((Object)_basicHandlerConstructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handler.addXmlPath(xmlPath);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Path rosettaPath = getRosettaPath();");
        _builder.newLine();
        List<ExpandedAttribute> _attributePath = mappedGroup.getGroup().getAttributePath();
        for (ExpandedAttribute att : _attributePath) {
            _builder.append("\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name = att.getName();
            _builder.append(_name, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("useConditionalCache(handler, localPath, ");
        String _attPathName = this.toAttPathName(mappedGroup.getGroup());
        _builder.append(_attPathName, "\t");
        _builder.append("Values);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handler.setRosettaPath(rosettaPath);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return handler;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateAnonHandler(AttributeGroup group, SynonymMap mapping, ExpandedAttribute last, String localPathVar, String xmlPathVar) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// anon handler");
        _builder.newLine();
        int _size = group.getAttributePath().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            List<ExpandedAttribute> _attributePath = group.getAttributePath();
            int _size_1 = group.getAttributePath().size();
            int _minus = _size_1 - 1;
            Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
            boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.take(_attributePath, (int)_minus), (Functions.Function1)_function);
            if (_exists) {
                _builder.append("AnonHandler<");
                Object _firstMultipleBuilder = this.firstMultipleBuilder(group.getAttributePath(), mapping);
                _builder.append(_firstMultipleBuilder);
                _builder.append("> foundbuilder = findOrNew(");
                String _attPathName = this.toAttPathName(this.toFirstMultiple(group));
                _builder.append(_attPathName);
                _builder.append("Underlyers, \"");
                String _name = last.getName();
                _builder.append(_name);
                _builder.append("\", ");
                _builder.append(localPathVar);
                _builder.append(",");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("AnonHandler<");
                Object _firstMultipleBuilder_1 = this.firstMultipleBuilder(group.getAttributePath(), mapping);
                _builder.append(_firstMultipleBuilder_1);
                _builder.append("> foundbuilder = ");
                String _attPathName_1 = this.toAttPathName(this.removeLast(group));
                _builder.append(_attPathName_1);
                _builder.append("UnderlyerB = useOrNew(");
                String _attPathName_2 = this.toAttPathName(this.removeLast(group));
                _builder.append(_attPathName_2);
                _builder.append("UnderlyerB,");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("() -> {");
            _builder.newLine();
            _builder.append("\t");
            Object _firstMultipleBuilder_2 = this.firstMultipleBuilder(group.getAttributePath(), mapping);
            _builder.append(_firstMultipleBuilder_2, "\t");
            _builder.append(" chainBuilder;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _builderChain = this.builderChain(group.getAttributePath(), mapping);
            _builder.append((Object)_builderChain, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("AnonHandler<");
            Object _firstMultipleBuilder_3 = this.firstMultipleBuilder(group.getAttributePath(), mapping);
            _builder.append(_firstMultipleBuilder_3, "\t");
            _builder.append("> result = new AnonHandler<>(injector, mappingContext, rosettaPath, chainBuilder);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("result.addXmlPath(");
            _builder.append(xmlPathVar, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("});");
            _builder.newLine();
            _builder.append("Path rosettaPath = foundbuilder.getRosettaPath();");
            _builder.newLine();
            CharSequence _postAnon = this.postAnon(group, mapping);
            _builder.append((Object)_postAnon);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("Path rosettaPath = getRosettaPath();");
            _builder.newLine();
            CharSequence _pNameW = this.pNameW(mapping.getRosetta());
            _builder.append((Object)_pNameW);
            _builder.append("<T> foundbuilder = ");
            CharSequence _pNameW_1 = this.pNameW(mapping.getRosetta());
            _builder.append((Object)_pNameW_1);
            _builder.append(".this;");
            _builder.newLineIfNotEmpty();
            CharSequence _postAnon_1 = this.postAnon(group, mapping);
            _builder.append((Object)_postAnon_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence mappingProcessor(AttributeGroupMapping mappedGroup, SynonymMap mapping) {
        StringConcatenation _xblockexpression = null;
        AttributeGroup attrPathSynGroup = mappedGroup.getGroup();
        Functions.Function1 _function = it -> {
            String _mapperName = it.getMapperName();
            return _mapperName != null;
        };
        Iterable mapperSynGroups = IterableUtil.distinct((Iterable)IterableExtensions.filter(attrPathSynGroup.getSynonymGroups(), (Functions.Function1)_function));
        StringConcatenation _builder = new StringConcatenation();
        for (SynonymGroup mapperSynGroup : mapperSynGroups) {
            String _mapperName = mapperSynGroup.getMapperName();
            String mapperClassName = _mapperName + "MappingProcessor";
            _builder.newLineIfNotEmpty();
            _builder.append("private Map.Entry<RosettaPath, ");
            _builder.append(mapperClassName);
            _builder.append("> ");
            CharSequence _mappingProcessorMethodName = this.toMappingProcessorMethodName(attrPathSynGroup, mapperSynGroup);
            _builder.append((Object)_mappingProcessorMethodName);
            _builder.append("(Path parentPath, MappingContext mappingContext) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _builderChainForMapper = this.builderChainForMapper(this.getRemoveLastReference(attrPathSynGroup.getAttributePath()), mapping);
            _builder.append((Object)_builderChainForMapper, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("RosettaPath modelPath = PathUtils.toRosettaPath(rosettaPath);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("List<Path> synonymPaths = java.util.stream.Stream.of(");
            Functions.Function1 _function_1 = it -> it;
            String _join = IterableExtensions.join(this.toSynonymLastElementName(mapperSynGroup), (CharSequence)"\"", (CharSequence)"\", \"", (CharSequence)"\"", (Functions.Function1)_function_1);
            _builder.append(_join, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append(".map(Path::parse)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append(".map(parentPath::append)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append(".collect(Collectors.toList());");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return new java.util.AbstractMap.SimpleEntry<>(modelPath, new ");
            _builder.append(mapperClassName, "\t");
            _builder.append("(modelPath, synonymPaths, mappingContext));");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence builderChainForMapper(List<ExpandedAttribute> attributePath, SynonymMap mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Path rosettaPath = getRosettaPath();");
        _builder.newLine();
        List<ExpandedAttribute> attList = this.removeLast(attributePath);
        _builder.newLineIfNotEmpty();
        Object lastBuilderName = "getUnderlying()";
        _builder.newLineIfNotEmpty();
        Object nextBuilderName = "";
        _builder.newLineIfNotEmpty();
        for (ExpandedAttribute att : attList) {
            boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)att);
            if (_cardinalityIsListValue) {
                _builder.append("int ");
                String _name = att.getName();
                _builder.append(_name);
                _builder.append("Index = Math.max(0, getMappingListIndex(");
                _builder.append((String)lastBuilderName);
                _builder.append(".get");
                String _firstUpper = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper);
                _builder.append("(), ");
                CharSequence _asList = this.asList(this.mergeSynonyms(attributePath, mapping));
                _builder.append((Object)_asList);
                _builder.append(") - 1);");
                _builder.newLineIfNotEmpty();
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append(" ");
                String _firstLower = StringExtensions.toFirstLower((String)att.getType().getName());
                String _plus = _firstLower + "Builder";
                nextBuilderName = _plus;
                String _nextBuilderName = nextBuilderName;
                _builder.append(_nextBuilderName);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_1);
                _builder.append("(");
                String _name_1 = att.getName();
                _builder.append(_name_1);
                _builder.append("Index);");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_2 = att.getName();
                _builder.append(_name_2);
                _builder.append("\", ");
                String _name_3 = att.getName();
                _builder.append(_name_3);
                _builder.append("Index));");
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _expandedTypeToBuilder_1 = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder_1);
                _builder.append(" ");
                String _firstLower_1 = StringExtensions.toFirstLower((String)att.getType().getName());
                String _plus_1 = _firstLower_1 + "Builder";
                nextBuilderName = _plus_1;
                String _nextBuilderName_1 = nextBuilderName;
                _builder.append(_nextBuilderName_1);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_2);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_4 = att.getName();
                _builder.append(_name_4);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
            }
            String _xblockexpression = null;
            lastBuilderName = nextBuilderName;
            _xblockexpression = "";
            _builder.append(_xblockexpression);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
        String _name_5 = ((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getName();
        _builder.append(_name_5);
        _builder.append("\"));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public List<ExpandedAttribute> getRemoveLastReference(List<ExpandedAttribute> attributes) {
        boolean _isParentMeta = this.isParentMeta(attributes);
        if (_isParentMeta) {
            return this.removeLast(attributes);
        }
        return attributes;
    }

    public boolean isMeta(ExpandedAttribute attribute) {
        return attribute.isOverriding();
    }

    public boolean isParentMeta(List<ExpandedAttribute> attributes) {
        ExpandedAttribute _parentAttribute = this.getParentAttribute(attributes);
        boolean _isMeta = false;
        if (_parentAttribute != null) {
            _isMeta = this.isMeta(_parentAttribute);
        }
        return _isMeta;
    }

    public ExpandedAttribute getParentAttribute(List<ExpandedAttribute> attributes) {
        boolean _greaterThan;
        ExpandedAttribute _xifexpression = null;
        int _size = attributes.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            int _size_1 = attributes.size();
            int _minus = _size_1 - 2;
            _xifexpression = attributes.get(_minus);
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    private CharSequence supplier(List<ExpandedAttribute> atts) {
        StringConcatenation _xifexpression = null;
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        boolean _exists = IterableExtensions.exists(atts, (Functions.Function1)_function);
        if (_exists) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Optional.empty()");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Optional.of(getUnderlying())");
            _builder_1.newLine();
            Functions.Function1 _function_1 = it -> AttributeGroup.attributeName(it);
            List _map = ListExtensions.map(atts, (Functions.Function1)_function_1);
            for (String name : _map) {
                _builder_1.append("\t\t");
                _builder_1.append(".map(bu -> bu.get");
                String _firstUpper = StringExtensions.toFirstUpper((String)name);
                _builder_1.append(_firstUpper, "\t\t");
                _builder_1.append("())");
                _builder_1.newLineIfNotEmpty();
            }
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    private CharSequence romHandler(AttributeGroupMapping mappedGroup, SynonymMap mapping, String packageName) {
        CharSequence _xblockexpression = null;
        ExpandedAttribute last = (ExpandedAttribute)IterableExtensions.lastOrNull(mappedGroup.getGroup().getAttributePath());
        CharSequence _xifexpression = null;
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        boolean _exists = IterableExtensions.exists(mappedGroup.getGroup().getAttributePath(), (Functions.Function1)_function);
        _xifexpression = _exists ? this.romHandlerList(mappedGroup, mapping, last, packageName) : this.romHandlerSingle(mappedGroup, mapping, last, packageName);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence romCondHandler(AttributeGroupMapping mappedGroup, SynonymMap mapping, String packageName) {
        CharSequence _xblockexpression = null;
        ExpandedAttribute last = (ExpandedAttribute)IterableExtensions.lastOrNull(mappedGroup.getGroup().getAttributePath());
        CharSequence _xifexpression = null;
        Functions.Function1 _function = it -> RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)it);
        boolean _exists = IterableExtensions.exists(mappedGroup.getGroup().getAttributePath(), (Functions.Function1)_function);
        _xifexpression = _exists ? this.romCondHandlerList(mappedGroup, mapping, last, packageName) : this.romCondHandlerSingle(mappedGroup, mapping, packageName);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence romHandlerSingle(AttributeGroupMapping mappedGroup, SynonymMap mapping, ExpandedAttribute last, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        CharSequence _pFullNameT = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT);
        _builder.append(" ");
        String _handlerMethodName = this.toHandlerMethodName(mappedGroup.getGroup());
        _builder.append(_handlerMethodName);
        _builder.append("_0(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        String _attPathName = this.toAttPathName(mappedGroup.getGroup());
        _builder.append(_attPathName, "\t");
        _builder.append("Handler = useOrNew(");
        CharSequence _handlerFieldName = this.toHandlerFieldName(mappedGroup.getGroup());
        _builder.append((Object)_handlerFieldName, "\t");
        _builder.append(", ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _romSupllier = this.romSupllier(mappedGroup, mapping, last, packageName);
        _builder.append((Object)_romSupllier, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _handlerFieldName_1 = this.toHandlerFieldName(mappedGroup.getGroup());
        _builder.append((Object)_handlerFieldName_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence romCondHandlerSingle(AttributeGroupMapping mappedGroup, SynonymMap mapping, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        CharSequence _pFullNameT = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT);
        _builder.append(" ");
        CharSequence _condHandlerMethodName = this.toCondHandlerMethodName(mappedGroup.getGroup());
        _builder.append((Object)_condHandlerMethodName);
        _builder.append("(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Path rosettaPath = getRosettaPath();");
        _builder.newLine();
        List<ExpandedAttribute> _attributePath = mappedGroup.getGroup().getAttributePath();
        for (ExpandedAttribute att : _attributePath) {
            _builder.append("\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name = att.getName();
            _builder.append(_name, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _pFullNameT_1 = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT_1, "\t");
        _builder.append(" handler = new ");
        CharSequence _pFullNameT_2 = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT_2, "\t");
        _builder.append("(injector, mappingContext);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("handler.setRosettaPath(rosettaPath);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("handler.setUnderlying(");
        String _attPathName = this.toAttPathName(mappedGroup.getGroup());
        _builder.append(_attPathName, "\t");
        _builder.append("Values.computeIfAbsent(localPath, a -> handler.getUnderlying()));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return handler;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence romHandlerList(AttributeGroupMapping mappedGroup, SynonymMap mapping, ExpandedAttribute last, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        CharSequence _pFullNameT = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT);
        _builder.append(" ");
        String _handlerMethodName = this.toHandlerMethodName(mappedGroup.getGroup());
        _builder.append(_handlerMethodName);
        _builder.append("_0(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _pFullNameT_1 = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT_1, "\t");
        _builder.append(" handler = findOrNew(");
        CharSequence _handlerFieldName = this.toHandlerFieldName(mappedGroup.getGroup());
        _builder.append((Object)_handlerFieldName, "\t");
        _builder.append(", \"");
        String _name = last.getName();
        _builder.append(_name, "\t");
        _builder.append("\", localPath,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _romSupllier = this.romSupllier(mappedGroup, mapping, last, packageName);
        _builder.append((Object)_romSupllier, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return handler;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence romCondHandlerList(AttributeGroupMapping mappedGroup, SynonymMap mapping, ExpandedAttribute last, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        CharSequence _pFullNameT = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT);
        _builder.append(" ");
        CharSequence _condHandlerMethodName = this.toCondHandlerMethodName(mappedGroup.getGroup());
        _builder.append((Object)_condHandlerMethodName);
        _builder.append("(Path localPath, Path parentPath) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Path xmlPath = parentPath.addElement(localPath.getLastElement());");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _pFullNameT_1 = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT_1, "\t");
        _builder.append(" handler = findOrNew(");
        CharSequence _handlerFieldName = this.toHandlerFieldName(mappedGroup.getGroup());
        _builder.append((Object)_handlerFieldName, "\t");
        _builder.append(", \"");
        String _name = last.getName();
        _builder.append(_name, "\t");
        _builder.append("\", localPath,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("() -> {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Path rosettaPath = getRosettaPath();");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _pFullNameT_2 = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT_2, "\t\t\t");
        _builder.append(" result = new ");
        CharSequence _pFullNameW = this.pFullNameW(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameW, "\t\t\t");
        _builder.append("<>(injector, mappingContext);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("result.setUnderlying(");
        String _attPathName = this.toAttPathName(mappedGroup.getGroup());
        _builder.append(_attPathName, "\t\t\t");
        _builder.append("Values.computeIfAbsent(localPath, a -> ");
        String _name_1 = mappedGroup.getMappings().getRosetta().getName();
        _builder.append(_name_1, "\t\t\t");
        _builder.append(".builder()));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        boolean cardUsed = false;
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("// Model index is guessed at the number of conditional options, e.g., if there's 1 option, then the index would be 0");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("int index = ");
        String _attPathName_1 = this.toAttPathName(mappedGroup.getGroup());
        _builder.append(_attPathName_1, "\t\t\t");
        _builder.append("Values.keySet().size() - 1;");
        _builder.newLineIfNotEmpty();
        List<ExpandedAttribute> _attributePath = mappedGroup.getGroup().getAttributePath();
        for (ExpandedAttribute att : _attributePath) {
            if (RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)att) && !cardUsed) {
                _builder.append("\t\t\t");
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _xblockexpression = null;
                cardUsed = true;
                _xblockexpression = att.getName();
                _builder.append(_xblockexpression, "\t\t\t");
                _builder.append("\", index));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t\t\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name_2 = att.getName();
            _builder.append(_name_2, "\t\t\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t");
        _builder.append("result.addXmlPath(xmlPath);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("result.setRosettaPath(rosettaPath);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return handler;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence romSupllier(AttributeGroupMapping mappedGroup, SynonymMap mapping, ExpandedAttribute last, String packageName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("()-> {");
        Object _firstMultipleBuilder = this.firstMultipleBuilder(mappedGroup.getGroup().getAttributePath(), mapping);
        _builder.append(_firstMultipleBuilder);
        _builder.append(" chainBuilder;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _builderChain = this.builderChain(mappedGroup.getGroup().getAttributePath(), mapping);
        _builder.append((Object)_builderChain, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Object _penultimateBuilder = this.penultimateBuilder(mappedGroup.getGroup().getAttributePath(), mapping);
        _builder.append(_penultimateBuilder, "\t\t");
        _builder.append(" penultimateBuilder;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Object lastBuilderName = "chainBuilder";
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        Object nextBuilderName = "";
        _builder.newLineIfNotEmpty();
        List<ExpandedAttribute> _attributePath = mappedGroup.getGroup().getAttributePath();
        int _size = this.toFirstMultiple(mappedGroup.getGroup()).size();
        int _size_1 = mappedGroup.getGroup().getAttributePath().size();
        int _minus = _size_1 - 1;
        List<ExpandedAttribute> _subList = _attributePath.subList(_size, _minus);
        for (ExpandedAttribute att : _subList) {
            boolean _cardinalityIsListValue = RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)att);
            if (_cardinalityIsListValue) {
                _builder.append("int ");
                String _name = att.getName();
                _builder.append(_name);
                _builder.append("Index = sizeOf(");
                _builder.append((String)lastBuilderName);
                _builder.append(".get");
                String _firstUpper = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper);
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append(" ");
                String _firstLower = StringExtensions.toFirstLower((String)att.getType().getName());
                String _plus = _firstLower + "Builder";
                nextBuilderName = _plus;
                String _nextBuilderName = nextBuilderName;
                _builder.append(_nextBuilderName);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_1);
                _builder.append("(");
                String _name_1 = att.getName();
                _builder.append(_name_1);
                _builder.append("Index);");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_2 = att.getName();
                _builder.append(_name_2);
                _builder.append("\", ");
                String _name_3 = att.getName();
                _builder.append(_name_3);
                _builder.append("Index));");
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _expandedTypeToBuilder_1 = this.expandedTypeToBuilder(att.getType());
                _builder.append((Object)_expandedTypeToBuilder_1);
                _builder.append(" ");
                String _firstLower_1 = StringExtensions.toFirstLower((String)att.getType().getName());
                String _plus_1 = _firstLower_1 + "Builder";
                nextBuilderName = _plus_1;
                String _nextBuilderName_1 = nextBuilderName;
                _builder.append(_nextBuilderName_1);
                _builder.append(" = ");
                _builder.append((String)lastBuilderName);
                _builder.append(".getOrCreate");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)att.getName());
                _builder.append(_firstUpper_2);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
                String _name_4 = att.getName();
                _builder.append(_name_4);
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("//");
            lastBuilderName = nextBuilderName;
            _builder.append((String)lastBuilderName);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("penultimateBuilder = ");
        _builder.append((String)lastBuilderName, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _pFullNameT = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT, "\t\t");
        _builder.append(" result = new ");
        CharSequence _pFullNameT_1 = this.pFullNameT(mappedGroup.getMappings(), packageName);
        _builder.append((Object)_pFullNameT_1, "\t\t");
        _builder.append("(injector, mappingContext);");
        _builder.newLineIfNotEmpty();
        boolean _cardinalityIsListValue_1 = RosettaAttributeExtensions.cardinalityIsListValue((ExpandedAttribute)last);
        if (_cardinalityIsListValue_1) {
            _builder.append("\t\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name_5 = last.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\", sizeOf(penultimateBuilder.get");
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)last.getName());
            _builder.append(_firstUpper_3, "\t\t");
            _builder.append("())));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("penultimateBuilder.add");
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)last.getName());
            _builder.append(_firstUpper_4, "\t\t");
            _builder.append("(result.getUnderlying());");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("rosettaPath = rosettaPath.addElement(new PathElement(\"");
            String _name_6 = last.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("penultimateBuilder.set");
            String _firstUpper_5 = StringExtensions.toFirstUpper((String)last.getName());
            _builder.append(_firstUpper_5, "\t\t");
            _builder.append("(result.getUnderlying());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("result.addXmlPath(xmlPath);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("result.setRosettaPath(rosettaPath);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateBuilderProxy(SynonymMap mapping) {
        boolean _tripleNotEquals;
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                boolean _isEmpty = it_1.getConditions().isEmpty();
                return !_isEmpty;
            };
            return IterableExtensions.exists(it.getSynonymGroups(), (Functions.Function1)_function_1);
        };
        List conditionedPaths = IterableExtensions.toList((Iterable)IterableExtensions.filter(mapping.attributeGroups(), (Functions.Function1)_function));
        SynonymMap _superMap = mapping.getSuperMap();
        boolean bl = _tripleNotEquals = _superMap != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function_1 = it -> {
                Functions.Function1 _function_2 = it_1 -> {
                    boolean _isEmpty = it_1.getConditions().isEmpty();
                    return !_isEmpty;
                };
                return IterableExtensions.exists(it.getSynonymGroups(), (Functions.Function1)_function_2);
            };
            Iterables.addAll((Collection)conditionedPaths, (Iterable)IterableExtensions.filter(mapping.getSuperMap().attributeGroups(), (Functions.Function1)_function_1));
        }
        return this.generateBuilderProxy(mapping, conditionedPaths);
    }

    private CharSequence generateBuilderProxy(SynonymMap mapping, List<AttributeGroup> conditionedPaths) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private class BuilderProxy extends ");
        StringConcatenationClient _builder_1 = this.toBuilder((EObject)mapping.getRosetta());
        _builder.append(_builder_1);
        _builder.append("Impl {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("AtomicBoolean evaluatedConditions = new AtomicBoolean();");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _fullname = IterableUtil.fullname((RosettaType)mapping.getRosetta());
        _builder.append(_fullname, "\t");
        _builder.append(" build() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("evaluateConditions();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (super.hasData()) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return super.build();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean hasData() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("evaluateConditions();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return super.hasData();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void process(RosettaPath path, BuilderProcessor processor) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("evaluateConditions();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super.process(path, processor);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _buildEvaluateConditions = this.buildEvaluateConditions(mapping, conditionedPaths);
        _builder.append((Object)_buildEvaluateConditions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence buildEvaluateConditions(SynonymMap mapping, Iterable<AttributeGroup> conditionedPaths) {
        StringConcatenation _xblockexpression = null;
        HashMap<String, Integer> counterPerAttribute = new HashMap<String, Integer>();
        for (AttributeGroup path : conditionedPaths) {
            counterPerAttribute.put(StringExtensions.toFirstUpper((String)this.toAttPathName(path)), 0);
        }
        LinkedHashMap<CallSite, CharSequence> methods = new LinkedHashMap<CallSite, CharSequence>();
        TreeMultimap methodOrder = TreeMultimap.create();
        Functions.Function1 _function = it -> it.attsToString();
        List _sortBy = IterableExtensions.sortBy(conditionedPaths, (Functions.Function1)_function);
        for (AttributeGroup path_1 : _sortBy) {
            Functions.Function1 _function_1 = it -> {
                boolean _isEmpty = it.getConditions().isEmpty();
                return !_isEmpty;
            };
            Iterable _filter = IterableExtensions.filter(path_1.getSynonymGroups(), (Functions.Function1)_function_1);
            for (SynonymGroup group : _filter) {
                List<SynonymCondition> _conditions = group.getConditions();
                for (SynonymCondition cond : _conditions) {
                    Integer perPathCounter = (Integer)counterPerAttribute.get(StringExtensions.toFirstUpper((String)this.toAttPathName(path_1)));
                    String _firstUpper = StringExtensions.toFirstUpper((String)this.toAttPathName(path_1));
                    String _plus = "evaluate" + _firstUpper;
                    String methodName = _plus + perPathCounter;
                    counterPerAttribute.put(StringExtensions.toFirstUpper((String)this.toAttPathName(path_1)), perPathCounter + 1);
                    SynonymTest.TestPriority _xifexpression = null;
                    boolean _isEmpty = cond.getCondition().isEmpty();
                    if (_isEmpty) {
                        _xifexpression = SynonymTest.TestPriority.Last;
                    } else {
                        Functions.Function1 _function_2 = it -> it.priority();
                        _xifexpression = ((SynonymTest)IterableExtensions.minBy(cond.getCondition(), (Functions.Function1)_function_2)).priority();
                    }
                    SynonymTest.TestPriority priority = _xifexpression;
                    methodOrder.put((Object)priority, (Object)methodName);
                    Functions.Function1 _function_3 = it -> {
                        Functions.Function1 _function_4 = it_1 -> {
                            Functions.Function1 _function_5 = it_2 -> it_2.getCardinality() == null || Objects.equals((Object)it_2.getCardinality(), (Object)Cardinality.SINGLE);
                            return IterableExtensions.forall(it_1.getSynonymPath(), (Functions.Function1)_function_5);
                        };
                        return IterableExtensions.forall(it.getPaths(), (Functions.Function1)_function_4);
                    };
                    boolean _forall = IterableExtensions.forall(cond.getCondition(), (Functions.Function1)_function_3);
                    if (_forall) {
                        methods.put((CallSite)((Object)methodName), this.evalSingleCardinality(cond, mapping, path_1.getAttributePath(), this.toPathList(group), perPathCounter));
                        continue;
                    }
                    if (!IterableExtensions.isEmpty((Iterable)Iterables.filter(cond.getCondition(), SynonymPathTest.class)) && !IterableExtensions.isEmpty((Iterable)Iterables.filter(cond.getCondition(), SynonymBinaryTest.class))) {
                        methods.put((CallSite)((Object)methodName), this.evalPathAndTest(cond, path_1.getAttributePath(), this.toPathList(group), perPathCounter));
                        continue;
                    }
                    methods.put((CallSite)((Object)methodName), this.evalMultiCardinality(mapping, cond, path_1));
                }
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        Set _entrySet = methods.entrySet();
        for (Map.Entry e : _entrySet) {
            _builder.append("private void ");
            String _key = (String)e.getKey();
            _builder.append(_key);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _value = (CharSequence)e.getValue();
            _builder.append((Object)_value, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("private void evaluateConditions() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (evaluatedConditions.compareAndSet(false, true)) {");
        _builder.newLine();
        Set _entries = methodOrder.entries();
        for (Map.Entry e_1 : _entries) {
            _builder.append("\t\t");
            String _value_1 = (String)e_1.getValue();
            _builder.append(_value_1, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence evalMultiCardinality(SynonymMap mapping, SynonymCondition cond, AttributeGroup group) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _exists = IterableUtil.exists(cond.getCondition(), SynonymRosettaPathTest.class);
        if (_exists) {
            _builder.append("Path rosettaPath = getRosettaPath()");
            List<ExpandedAttribute> _dropMeta = this.dropMeta(group.getAttributePath());
            for (ExpandedAttribute att : _dropMeta) {
                _builder.append(".addElement(new PathElement(\"");
                String _name = att.getName();
                _builder.append(_name);
                _builder.append("\"))");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("if (");
            Iterable _filter = Iterables.filter(cond.getCondition(), SynonymRosettaPathTest.class);
            boolean _hasElements = false;
            for (SynonymRosettaPathTest test : _filter) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" && ", "");
                }
                _builder.append("GeneratorPathUtil.matches(rosettaPath, \"");
                CharSequence _dotSep = this.toDotSep((RosettaAttributeReferenceSegment)test.getPath());
                _builder.append((Object)_dotSep);
                _builder.append("\")");
            }
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _evalPathFiltering = this.evalPathFiltering(cond, group, mapping);
            _builder.append((Object)_evalPathFiltering, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            CharSequence _evalPathFiltering_1 = this.evalPathFiltering(cond, group, mapping);
            _builder.append((Object)_evalPathFiltering_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public List<ExpandedAttribute> dropMeta(List<ExpandedAttribute> attributes) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        for (int i = 0; i < ((Object[])Conversions.unwrapArray(attributes, Object.class)).length; ++i) {
            if (attributes.size() > 0 && AttributeGroup.attributeName(attributes.get(i)).equals("value") && this.isMeta(attributes.get(i - 1))) continue;
            boolean _equals = AttributeGroup.attributeName(attributes.get(i)).equals("meta");
            if (_equals) {
                ++i;
                continue;
            }
            result.add(attributes.get(i));
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected boolean synonymPathHasMultipleCard(SynonymExistsTest synonymExistsTest) {
        Functions.Function1 _function = it -> {
            Cardinality _cardinality = it.getCardinality();
            return _cardinality == Cardinality.MULTIPLE;
        };
        return IterableExtensions.exists(synonymExistsTest.getPath().getSynonymPath(), (Functions.Function1)_function);
    }

    protected CharSequence evalPathFiltering(SynonymCondition cond, AttributeGroup group, SynonymMap mapping) {
        Object test2;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// evaluate path filtering");
        _builder.newLine();
        _builder.append("Set<Path> paths = null;");
        _builder.newLine();
        boolean initialSet = false;
        _builder.newLineIfNotEmpty();
        Iterable _filter = Iterables.filter(cond.getCondition(), SynonymBinaryTest.class);
        for (Object test2 : _filter) {
            _builder.append("// SynonymBinaryTest");
            _builder.newLine();
            _builder.append("// This next line hard codes a lot of stuff that probably needs to depend on the input");
            _builder.newLine();
            if (!initialSet) {
                _builder.append("paths = (");
                String _xblockexpression = null;
                initialSet = true;
                _xblockexpression = "";
                _builder.append(_xblockexpression);
            } else {
                _builder.append(" paths.retainAll(");
            }
            String _pathName = this.toPathName(((SynonymBinaryTest)test2).getLeftPath());
            _builder.append(_pathName);
            _builder.append("Values.entrySet()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".stream()");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".filter(e -> areEqual(e.getValue(), ");
            CharSequence _handleWhenRight = this.handleWhenRight(((SynonymBinaryTest)test2).getRightLiteral());
            _builder.append((Object)_handleWhenRight, "\t");
            _builder.append("))");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".map(e -> e.getKey())");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".collect(Collectors.toSet()));");
            _builder.newLine();
        }
        _builder.newLine();
        Functions.Function1 _function = it -> this.synonymPathHasMultipleCard((SynonymExistsTest)it);
        Iterable _filter_1 = IterableExtensions.filter((Iterable)Iterables.filter(cond.getCondition(), SynonymExistsTest.class), (Functions.Function1)_function);
        test2 = _filter_1.iterator();
        while (test2.hasNext()) {
            SynonymExistsTest test_1 = (SynonymExistsTest)test2.next();
            _builder.append("// SynonymExistsTest");
            _builder.newLine();
            if (!initialSet) {
                _builder.append("paths = (");
                String _xblockexpression_1 = null;
                initialSet = true;
                _xblockexpression_1 = "";
                _builder.append(_xblockexpression_1);
            } else {
                _builder.append(" paths.retainAll(");
            }
            String _pathName_1 = this.toPathName(test_1.getPath());
            _builder.append(_pathName_1);
            _builder.append("Values.entrySet()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".stream()");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".filter(e -> areEqual(e.getValue(), \"Exists\"))");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".map(e -> e.getKey())");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".collect(Collectors.toSet()));");
            _builder.newLine();
        }
        Iterable _filter_2 = Iterables.filter(cond.getCondition(), SynonymAbsentTest.class);
        for (SynonymAbsentTest test_2 : _filter_2) {
            _builder.append("// SynonymAbsentTest");
            _builder.newLine();
            if (!initialSet) {
                _builder.append("paths = (");
                String _xblockexpression_2 = null;
                initialSet = true;
                _xblockexpression_2 = "";
                _builder.append(_xblockexpression_2);
            } else {
                _builder.append(" paths.removeAll(");
            }
            String _pathName_2 = this.toPathName(test_2.getPath());
            _builder.append(_pathName_2);
            _builder.append("Values.entrySet()");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(".stream()");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".filter(e -> areEqual(e.getValue(), \"Exists\"))");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".map(e -> e.getKey())");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(".collect(Collectors.toSet()));");
            _builder.newLine();
        }
        Functions.Function1 _function_1 = c -> !(c instanceof SynonymAbsentTest);
        boolean _exists = IterableExtensions.exists(cond.getCondition(), (Functions.Function1)_function_1);
        if (_exists) {
            if (cond.getSetToValue() == null && IterableUtil.exists(cond.getCondition(), SynonymExistsTest.class) && IngesterGeneratorUtils.isConditionalMappingPredicatedOnDifferentPath(IterableExtensions.toList((Iterable)IterableExtensions.flatMap(group.getSynonymGroups(), it -> it.getSynonymValues())), IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter(cond.getCondition(), SynonymExistsTest.class), it -> it.getPath())))) {
                _builder.append("// (a) ");
                Functions.Function1 _function_2 = it -> it.getClass().getSimpleName();
                String _join = IterableExtensions.join((Iterable)ListExtensions.map(cond.getCondition(), (Functions.Function1)_function_2), (CharSequence)",");
                _builder.append(_join);
                _builder.newLineIfNotEmpty();
                _builder.append("if (!paths.isEmpty()) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("int index = 0;");
                _builder.newLine();
                _builder.append("\t");
                String _attPathName = this.toAttPathName(group.getAttributePath());
                _builder.append(_attPathName, "\t");
                _builder.append("Values.values().forEach(v -> ");
                CharSequence _setterChain = this.setterChain(group.getAttributePath());
                _builder.append((Object)_setterChain, "\t");
                _builder.append("(v));");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            } else {
                _builder.append("for (Path p : paths) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("// in evalPathFiltering");
                _builder.newLine();
                boolean _multipleCardinality = this.multipleCardinality(group.getAttributePath());
                if (_multipleCardinality) {
                    _builder.append("\t");
                    _builder.append("int index = p.cardinality();");
                    _builder.newLine();
                }
                if (cond.getSetToValue() != null && IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(cond.getCondition(), it -> {
                    SynonymTest.TestPriority _priority = it.priority();
                    return _priority == SynonymTest.TestPriority.Last;
                }))) {
                    _builder.append("\t");
                    CharSequence _generateAnonHandler = this.generateAnonHandler(group, mapping, (ExpandedAttribute)IterableExtensions.lastOrNull(group.getAttributePath()), "p", "p");
                    _builder.append((Object)_generateAnonHandler, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("builder.");
                    CharSequence _setter = this.setter(group.getAttributePath());
                    _builder.append((Object)_setter, "\t");
                    _builder.append("(");
                    CharSequence _evaluate = this.evaluate(cond.getSetToValue());
                    _builder.append((Object)_evaluate, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _tripleNotEquals;
                    RosettaMapTestExpression _setToValue = cond.getSetToValue();
                    boolean bl = _tripleNotEquals = _setToValue != null;
                    if (_tripleNotEquals) {
                        _builder.append("\t");
                        CharSequence _setterChain_1 = this.setterChain(group.getAttributePath());
                        _builder.append((Object)_setterChain_1, "\t");
                        _builder.append("(");
                        CharSequence _evaluate_1 = this.evaluate(cond.getSetToValue());
                        _builder.append((Object)_evaluate_1, "\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    } else if (((ExpandedAttribute)IterableExtensions.lastOrNull(group.getAttributePath())).builtInType() || !this.multipleCardinality(group.getAttributePath())) {
                        _builder.append("\t");
                        String _attPathName_1 = this.toAttPathName(group.getAttributePath());
                        _builder.append(_attPathName_1, "\t");
                        _builder.append("Values.entrySet()");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".stream()");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".filter(e -> e.getKey().fullStartMatches(p))");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".map(e -> e.getValue())");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".forEach(v -> ");
                        CharSequence _mergeAttribute = this.mergeAttribute(group.getAttributePath());
                        _builder.append((Object)_mergeAttribute, "\t\t");
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("\t");
                        String _attPathName_2 = this.toAttPathName(group.getAttributePath());
                        _builder.append(_attPathName_2, "\t");
                        _builder.append("Handlers.getAllHandlers()");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".stream()");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".filter(h -> h.getXmlPathsToHere().stream().anyMatch(k -> k.fullStartMatches(p)))");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append(".forEach(v -> ");
                        CharSequence _setterChain_2 = this.setterChain(group.getAttributePath());
                        _builder.append((Object)_setterChain_2, "\t\t");
                        _builder.append("(v.getUnderlying()));");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            _builder.append("// (b) ");
            Functions.Function1 _function_3 = it -> it.getClass().getSimpleName();
            String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(cond.getCondition(), (Functions.Function1)_function_3), (CharSequence)",");
            _builder.append(_join_1);
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_4 = it -> it.getSynonymValues();
            Functions.Function1 _function_5 = it -> it.getPath();
            boolean _isConditionalMappingPredicatedOnDifferentPath = IngesterGeneratorUtils.isConditionalMappingPredicatedOnDifferentPath(IterableExtensions.toList((Iterable)IterableExtensions.flatMap(group.getSynonymGroups(), (Functions.Function1)_function_4)), IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter(cond.getCondition(), SynonymAbsentTest.class), (Functions.Function1)_function_5)));
            if (_isConditionalMappingPredicatedOnDifferentPath) {
                boolean _terMultipleCardinality = this.getterMultipleCardinality(group.getAttributePath());
                if (_terMultipleCardinality) {
                    _builder.append("// getOrCreateFoo(MAX_VALUE) creates new list item at next available index");
                    _builder.newLine();
                    _builder.append("int index = Integer.MAX_VALUE;");
                    _builder.newLine();
                }
                _builder.append("if (paths.isEmpty()) {");
                _builder.newLine();
                _builder.append("\t");
                String _attPathName_3 = this.toAttPathName(group.getAttributePath());
                _builder.append(_attPathName_3, "\t");
                _builder.append("Values.values().forEach(v -> ");
                CharSequence _setterChain_3 = this.setterChain(group.getAttributePath());
                _builder.append((Object)_setterChain_3, "\t");
                _builder.append("(v));");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            } else {
                boolean _terMultipleCardinality_1 = this.getterMultipleCardinality(group.getAttributePath());
                if (_terMultipleCardinality_1) {
                    _builder.append("// getOrCreateFoo(MAX_VALUE) creates new list item at next available index");
                    _builder.newLine();
                    _builder.append("int index = Integer.MAX_VALUE;");
                    _builder.newLine();
                }
                _builder.append("for (Map.Entry<Path, ");
                CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(group.getAttributePath())).getType());
                _builder.append((Object)_expandedTypeToBuilder);
                _builder.append("> entry : ");
                String _attPathName_4 = this.toAttPathName(group.getAttributePath());
                _builder.append(_attPathName_4);
                _builder.append("Values.entrySet()) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (!paths.stream().anyMatch(p -> entry.getKey().fullStartMatches(p))) {");
                _builder.newLine();
                _builder.append("\t\t");
                CharSequence _setterChain_4 = this.setterChain(group.getAttributePath());
                _builder.append((Object)_setterChain_4, "\t\t");
                _builder.append("(entry.getValue());");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence mergeAttribute(List<ExpandedAttribute> attributePath) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isDataType = ((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).isDataType();
        if (_isDataType) {
            String _attributeGetters = this.attributeGetters(attributePath);
            _builder.append(_attributeGetters);
            _builder.append("merge(v, new IngestMerger())");
        } else {
            CharSequence _setterChain = this.setterChain(attributePath);
            _builder.append((Object)_setterChain);
            _builder.append("(v)");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence evalSingleCardinality(SynonymCondition cond, SynonymMap mapping, List<ExpandedAttribute> attributePath, String pathList, int attributeConditionIndex) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// evaluate xml path that has single cardinality");
        _builder.newLine();
        _builder.append("if (");
        CharSequence _handleWhen = this.handleWhen(cond, pathList, attributePath);
        _builder.append((Object)_handleWhen);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _conditionTrue = this.conditionTrue(cond, attributePath, pathList, attributeConditionIndex);
        _builder.append((Object)_conditionTrue, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence handleWhen(SynonymCondition cond, String pathList, List<ExpandedAttribute> attributePath) {
        StringConcatenation _xifexpression = null;
        if (cond.getSetToValue() != null && cond.getCondition().isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("!");
            CharSequence _supplier = this.supplier(attributePath);
            _builder.append((Object)_supplier);
            _builder.append(".isPresent()");
            _xifexpression = _builder;
        } else {
            boolean _not;
            StringConcatenation _xifexpression_1 = null;
            boolean _isEmpty = cond.getCondition().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                List<SynonymTest> _condition = cond.getCondition();
                boolean _hasElements = false;
                for (SynonymTest test : _condition) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)" && ", "");
                    }
                    CharSequence _handleTest = this.handleTest(test, pathList, attributePath);
                    _builder_1.append((Object)_handleTest);
                }
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("/* no `set to` and `set when` condition */ true");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence evalPathAndTest(SynonymCondition cond, List<ExpandedAttribute> attributePath, String pathList, int attributeConditionIndex) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// evaluate path and test");
        _builder.newLine();
        CharSequence _conditionTrue = this.conditionTrue(cond, attributePath, pathList, attributeConditionIndex);
        _builder.append((Object)_conditionTrue);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence conditionTrue(SynonymCondition cond, List<ExpandedAttribute> attributePath, String pathList, int attributeConditionIndex) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        RosettaMapTestExpression _setToValue = cond.getSetToValue();
        boolean bl = _tripleNotEquals = _setToValue != null;
        if (_tripleNotEquals) {
            _builder.append("// `set to` conditional mapping");
            _builder.newLine();
            boolean _exists = IterableUtil.exists(cond.getCondition(), SynonymPathTest.class);
            if (_exists) {
                boolean _greaterThan;
                _builder.append("// (c) ");
                Functions.Function1 _function = it -> it.getClass().getSimpleName();
                String _join = IterableExtensions.join((Iterable)ListExtensions.map(cond.getCondition(), (Functions.Function1)_function), (CharSequence)",");
                _builder.append(_join);
                _builder.newLineIfNotEmpty();
                ArrayList<ExpandedAttribute> underlying = this.toFirstMultiple(attributePath);
                _builder.newLineIfNotEmpty();
                int _size = underlying.size();
                boolean bl2 = _greaterThan = _size > 0;
                if (_greaterThan) {
                    _builder.append("// nested set to (synonym path predicate)");
                    _builder.newLine();
                    boolean _terMultipleCardinality = this.getterMultipleCardinality(this.postFirstMultiple(attributePath));
                    if (_terMultipleCardinality) {
                        _builder.append("int index=Integer.MAX_VALUE;");
                        _builder.newLine();
                    }
                    _builder.append("evaluateConditionalPaths(");
                    _builder.newLine();
                    _builder.append("\t");
                    boolean _multipleCardinality = this.multipleCardinality(attributePath);
                    if (_multipleCardinality) {
                        Functions.Function1 _function_1 = it -> it.getName();
                        String _firstLower = StringExtensions.toFirstLower((String)IterableExtensions.join((Iterable)ListExtensions.map(underlying, (Functions.Function1)_function_1), (CharSequence)""));
                        _builder.append(_firstLower, "\t");
                        _builder.append("Underlyers,");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                    } else {
                        _builder.append("get");
                        Functions.Function1 _function_2 = it -> it.getName();
                        String _firstUpper = StringExtensions.toFirstUpper((String)IterableExtensions.join((Iterable)ListExtensions.map(underlying, (Functions.Function1)_function_2), (CharSequence)""));
                        _builder.append(_firstUpper, "\t");
                        _builder.append("UnderlyerB(),");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("getXmlPathsToHere(),");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("handler -> handler.getUnderlying().");
                    String _parentGetters = this.parentGetters(this.postFirstMultiple(attributePath));
                    _builder.append(_parentGetters, "\t");
                    _builder.append("set");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getName());
                    _builder.append(_firstUpper_1, "\t");
                    _builder.append("(");
                    CharSequence _evaluate = this.evaluate(cond.getSetToValue());
                    _builder.append((Object)_evaluate, "\t");
                    _builder.append("),");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("ImmutableList.of(\"");
                    Functions.Function1 _function_3 = it -> it.getPathWithDots();
                    String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter(cond.getCondition(), SynonymPathTest.class), (Functions.Function1)_function_3), (CharSequence)"\",\"");
                    _builder.append(_join_1, "\t");
                    _builder.append("\")");
                    boolean _exists_1 = IterableUtil.exists(cond.getCondition(), SynonymBinaryTest.class);
                    if (_exists_1) {
                        _builder.append(",");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        CharSequence _pathMatchBinary = this.toPathMatchBinary(Iterables.filter(cond.getCondition(), SynonymBinaryTest.class));
                        _builder.append((Object)_pathMatchBinary, "\t");
                    }
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("// set to (synonym path predicate)");
                    _builder.newLine();
                    _builder.append("Set<Path> paths = getXmlPathsToHere();");
                    _builder.newLine();
                    _builder.append("if (paths.stream().anyMatch(p -> ");
                    Iterable _filter = Iterables.filter(cond.getCondition(), SynonymPathTest.class);
                    boolean _hasElements = false;
                    for (SynonymPathTest test : _filter) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" || ", "");
                        }
                        _builder.append("p.endsWith(Path.parse(\"");
                        String _pathWithDots = test.getPathWithDots();
                        _builder.append(_pathWithDots);
                        _builder.append("\").getPathNames())");
                    }
                    _builder.append(")) {\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("set");
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getName());
                    _builder.append(_firstUpper_2, "\t");
                    _builder.append("(");
                    CharSequence _evaluate_1 = this.evaluate(cond.getSetToValue());
                    _builder.append((Object)_evaluate_1, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("return;");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                }
            } else {
                _builder.append("// (d) ");
                Functions.Function1 _function_4 = it -> it.getClass().getSimpleName();
                String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(cond.getCondition(), (Functions.Function1)_function_4), (CharSequence)",");
                _builder.append(_join_2);
                _builder.newLineIfNotEmpty();
                boolean _multipleCardinality_1 = this.multipleCardinality(attributePath);
                if (_multipleCardinality_1) {
                    _builder.append("// set to (rosetta path predicate) that has multiple cardinality");
                    _builder.newLine();
                    boolean _terMultipleCardinality_1 = this.getterMultipleCardinality(attributePath);
                    if (_terMultipleCardinality_1) {
                        _builder.append("int relativeIndex = ");
                        _builder.append((Object)attributeConditionIndex);
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("// TODO This line needs further explanation");
                        _builder.newLine();
                        _builder.append("int index = (relativeIndex == 0 || relativeIndex == 1) ? 0 : 1;");
                        _builder.newLine();
                    }
                    CharSequence _setterChain = this.setterChain(attributePath);
                    _builder.append((Object)_setterChain);
                    _builder.append("(");
                    CharSequence _evaluate_2 = this.evaluate(cond.getSetToValue());
                    _builder.append((Object)_evaluate_2);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("// set to (rosetta path predicate) that has single cardinality");
                    _builder.newLine();
                    CharSequence _setterChain_1 = this.setterChain(attributePath);
                    _builder.append((Object)_setterChain_1);
                    _builder.append("(");
                    CharSequence _evaluate_3 = this.evaluate(cond.getSetToValue());
                    _builder.append((Object)_evaluate_3);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
            }
        } else {
            boolean _notEquals;
            boolean bl3 = _notEquals = !Objects.equals(pathList, "");
            if (_notEquals) {
                _builder.append("// `set when` conditional mapping");
                _builder.newLine();
                boolean _exists_2 = IterableUtil.exists(cond.getCondition(), SynonymPathTest.class);
                if (_exists_2) {
                    _builder.append("// (e) ");
                    Functions.Function1 _function_5 = it -> it.getClass().getSimpleName();
                    String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(cond.getCondition(), (Functions.Function1)_function_5), (CharSequence)",");
                    _builder.append(_join_3);
                    _builder.newLineIfNotEmpty();
                    _builder.append("// set rosetta path that has single cardinality");
                    _builder.newLine();
                    _builder.append("Set<Path> paths = getXmlPathsToHere();");
                    _builder.newLine();
                    _builder.append("if (paths.stream().anyMatch(p -> ");
                    Iterable _filter_1 = Iterables.filter(cond.getCondition(), SynonymPathTest.class);
                    boolean _hasElements_1 = false;
                    for (SynonymPathTest test_1 : _filter_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)" || ", "");
                        }
                        _builder.append("p.endsWith(Path.parse(\"");
                        String _pathWithDots_1 = test_1.getPathWithDots();
                        _builder.append(_pathWithDots_1);
                        _builder.append("\").getPathNames())");
                    }
                    _builder.append(")) {\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    CharSequence _conditionSetterSingleCardinality = this.conditionSetterSingleCardinality(attributePath, pathList);
                    _builder.append((Object)_conditionSetterSingleCardinality, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    _builder.append("// (f) ");
                    Functions.Function1 _function_6 = it -> it.getClass().getSimpleName();
                    String _join_4 = IterableExtensions.join((Iterable)ListExtensions.map(cond.getCondition(), (Functions.Function1)_function_6), (CharSequence)",");
                    _builder.append(_join_4);
                    _builder.newLineIfNotEmpty();
                    boolean _multipleCardinality_2 = this.multipleCardinality(attributePath);
                    if (_multipleCardinality_2) {
                        _builder.append("// set rosetta path that has multiple cardinality");
                        _builder.newLine();
                        boolean _terMultipleCardinality_2 = this.getterMultipleCardinality(attributePath);
                        if (_terMultipleCardinality_2) {
                            _builder.append("// getOrCreateFoo(MAX_VALUE) creates new list item at next available index");
                            _builder.newLine();
                            _builder.append("int index = Integer.MAX_VALUE;");
                            _builder.newLine();
                        }
                        _builder.append("for (");
                        CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getType());
                        _builder.append((Object)_expandedTypeToBuilder);
                        _builder.append(" b : GeneratorPathUtil.getValuesForPathEnding(");
                        String _attPathName = this.toAttPathName(attributePath);
                        _builder.append(_attPathName);
                        _builder.append("Values, ImmutableList.of(\"");
                        _builder.append(pathList);
                        _builder.append("\"))) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        CharSequence _setterChain_2 = this.setterChain(attributePath);
                        _builder.append((Object)_setterChain_2, "\t");
                        _builder.append("(b);");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        CharSequence _conditionSetterSingleCardinality_1 = this.conditionSetterSingleCardinality(attributePath, pathList);
                        _builder.append((Object)_conditionSetterSingleCardinality_1);
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence conditionSetterSingleCardinality(List<ExpandedAttribute> attributePath, String pathList) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// set rosetta path that has single cardinality");
        _builder.newLine();
        _builder.append("Optional<");
        CharSequence _expandedTypeToBuilder = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getType());
        _builder.append((Object)_expandedTypeToBuilder);
        _builder.append("> val = GeneratorPathUtil.getValueForPath(");
        String _attPathName = this.toAttPathName(attributePath);
        _builder.append(_attPathName);
        _builder.append("Values, ImmutableList.of(\"");
        _builder.append(pathList);
        _builder.append("\"));");
        _builder.newLineIfNotEmpty();
        _builder.append("if (val.isPresent()) {");
        _builder.newLine();
        boolean _isType = ((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getType().isType();
        if (_isType) {
            _builder.append("\t");
            CharSequence _expandedTypeToBuilder_1 = this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(attributePath)).getType());
            _builder.append((Object)_expandedTypeToBuilder_1, "\t");
            _builder.append(" builder = val.get();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("new IngestMerger().run(builder, ");
            CharSequence _terChain = this.getterChain(attributePath);
            _builder.append((Object)_terChain, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _setterChain = this.setterChain(attributePath);
            _builder.append((Object)_setterChain, "\t");
            _builder.append("(builder);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            CharSequence _setterChain_1 = this.setterChain(attributePath);
            _builder.append((Object)_setterChain_1, "\t");
            _builder.append("(val.get());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence toPathMatchBinary(Iterable<SynonymBinaryTest> tests) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ps -> ");
        boolean _hasElements = false;
        for (SynonymBinaryTest test : tests) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" && ", "");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("GeneratorPathUtil.getPathMatchingValues(ps, ");
            String _pathName = this.toPathName((SynonymValue)IterableExtensions.lastOrNull(test.getPaths()));
            _builder.append(_pathName);
            _builder.append("Values).stream().anyMatch(s -> ");
            String _java = this.toJava(test.getOperator());
            _builder.append(_java);
            _builder.append("(s,");
            CharSequence _java_1 = this.toJava(test.getRightPath(), test.getRightLiteral());
            _builder.append((Object)_java_1);
            _builder.append("))");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String toPathList(SynonymGroup group) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getName();
            return IterableExtensions.join((Iterable)ListExtensions.map(it.getSynonymPath(), (Functions.Function1)_function_1), (CharSequence)".");
        };
        List _map = ListExtensions.map(group.getSynonymValues(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\", \"");
        return IterableExtensions.join((Iterable)_map, (CharSequence)_builder);
    }

    private CharSequence setterChain(List<ExpandedAttribute> path) {
        StringConcatenation _builder = new StringConcatenation();
        String _parentGetters = this.parentGetters(path);
        _builder.append(_parentGetters);
        CharSequence _setter = this.setter(path);
        _builder.append((Object)_setter);
        return _builder;
    }

    private CharSequence getterChain(List<ExpandedAttribute> path) {
        StringConcatenation _builder = new StringConcatenation();
        String _parentGetters = this.parentGetters(path);
        _builder.append(_parentGetters);
        String _ter = this.getter((ExpandedAttribute)IterableExtensions.lastOrNull(path));
        _builder.append(_ter);
        return _builder;
    }

    private String parentGetters(List<ExpandedAttribute> path) {
        Functions.Function1 _function = a -> this.getter((ExpandedAttribute)a);
        return IterableExtensions.join(this.removeLast(path), (CharSequence)"", (CharSequence)".", (CharSequence)".", (Functions.Function1)_function);
    }

    private String attributeGetters(List<ExpandedAttribute> path) {
        Functions.Function1 _function = a -> this.getter((ExpandedAttribute)a);
        return IterableExtensions.join(path, (CharSequence)"", (CharSequence)".", (CharSequence)".", (Functions.Function1)_function);
    }

    private String getter(ExpandedAttribute att) {
        String _xifexpression = null;
        boolean _isMultiple = att.isMultiple();
        if (_isMultiple) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("getOrCreate");
            String _firstUpper = StringExtensions.toFirstUpper((String)att.getName());
            _builder.append(_firstUpper);
            _builder.append("(index)");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("getOrCreate");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)att.getName());
            _builder_1.append(_firstUpper_1);
            _builder_1.append("()");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    private CharSequence setter(List<ExpandedAttribute> path) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _cardinalityIsSingleValue = RosettaAttributeExtensions.cardinalityIsSingleValue((ExpandedAttribute)((ExpandedAttribute)IterableExtensions.lastOrNull(path)));
        if (_cardinalityIsSingleValue) {
            _builder.append("set");
        } else {
            _builder.append("add");
        }
        String _firstUpper = StringExtensions.toFirstUpper((String)((ExpandedAttribute)IterableExtensions.lastOrNull(path)).getName());
        _builder.append(_firstUpper);
        return _builder;
    }

    private CharSequence _evaluate(RosettaMapTestExpression expression) {
        Class _class = expression.getClass();
        String _plus = "Don't know how to evaluate expression " + String.valueOf(_class);
        throw new UnsupportedOperationException(_plus);
    }

    private CharSequence _evaluate(RosettaLiteral expression) {
        return expression.stringValue();
    }

    private CharSequence _evaluate(RosettaEnumValueReference ref) {
        StringConcatenation _builder = new StringConcatenation();
        String _trim = IterableUtil.fullname((RosettaType)ref.getEnumeration()).trim();
        _builder.append(_trim);
        _builder.append(".");
        String _formatEnumName = EnumHelper.formatEnumName((String)ref.getValue().getName());
        _builder.append(_formatEnumName);
        return _builder;
    }

    private CharSequence _handleTest(SynonymTest test, String pathList, List<ExpandedAttribute> attributePath) {
        Class<?> _class = test.getClass();
        String _plus = "Don't know how to generate test for " + String.valueOf(_class);
        throw new UnsupportedOperationException(_plus);
    }

    private CharSequence _handleTest(SynonymExistsTest test, String pathList, List<ExpandedAttribute> attributePath) {
        StringConcatenation _builder = new StringConcatenation();
        String _pathName = this.toPathName(test.getPath());
        _builder.append(_pathName);
        _builder.append("Value != null");
        return _builder;
    }

    private CharSequence _handleTest(SynonymAbsentTest test, String pathList, List<ExpandedAttribute> attributePath) {
        StringConcatenation _builder = new StringConcatenation();
        String _pathName = this.toPathName(test.getPath());
        _builder.append(_pathName);
        _builder.append("Value == null");
        return _builder;
    }

    private CharSequence _handleTest(@Extension SynonymBinaryTest test, String pathList, List<ExpandedAttribute> attributePath) {
        StringConcatenation _builder = new StringConcatenation();
        String _java = this.toJava(test.getOperator());
        _builder.append(_java);
        _builder.append("(");
        CharSequence _java_1 = this.toJava(test.getLeftPath(), test.getLeftLiteral());
        _builder.append((Object)_java_1);
        _builder.append(",");
        CharSequence _java_2 = this.toJava(test.getRightPath(), test.getRightLiteral());
        _builder.append((Object)_java_2);
        _builder.append(")");
        return _builder;
    }

    private CharSequence _handleTest(SynonymPathTest test, String pathList, List<ExpandedAttribute> attributePath) {
        return "true";
    }

    private CharSequence _handleTest(SynonymRosettaPathTest test, String pathList, List<ExpandedAttribute> attributePath) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GeneratorPathUtil.endsWith(getRosettaPath().");
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> "addElement(\"" + it + "\")";
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)ListExtensions.map(attributePath, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)".");
        _builder.append(_join);
        _builder.append(".getParent(), \"");
        CharSequence _dotSepDropFirst = this.toDotSepDropFirst((RosettaAttributeReferenceSegment)test.getPath());
        _builder.append((Object)_dotSepDropFirst);
        _builder.append("\")");
        return _builder;
    }

    private CharSequence _handleTest(SynonymConditionFuncTest test, String pathList, List<ExpandedAttribute> attributePath) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("injector.getInstance(");
        String _funcClassName = test.getFuncClassName();
        _builder.append(_funcClassName);
        _builder.append(".class)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(".evaluate(getSynonymPathForConditionFunc(getXmlPathsToHere(), \"");
        _builder.append(pathList, "\t\t");
        _builder.append("\"), ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("formatPathWithNoIndexesAndSeparators(getRosettaPath()), ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        List<String> _predicatePathEndsWith = test.getPredicatePathEndsWith();
        boolean bl = _tripleNotEquals = _predicatePathEndsWith != null;
        if (_tripleNotEquals) {
            _builder.append("getValuesFromConditionPath(");
            Functions.Function1 _function = it -> "\"" + it + "\"";
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(test.getPredicatePathEndsWith(), (Functions.Function1)_function), (CharSequence)", ");
            _builder.append(_join, "\t\t\t\t");
            _builder.append(")");
        } else {
            _builder.append("null");
        }
        _builder.append(")");
        return _builder;
    }

    private CharSequence toJava(SynonymValue path, RosettaMapTestExpression literal) {
        Object _xifexpression = null;
        if (path != null) {
            String _pathName = this.toPathName(path);
            _xifexpression = _pathName + "Value";
        } else {
            _xifexpression = this.handleWhenRight(literal);
        }
        return _xifexpression;
    }

    private String toJava(String op) {
        String _switchResult = null;
        if (op != null) {
            switch (op) {
                case "=": {
                    _switchResult = "areEqual";
                    break;
                }
                case "<>": {
                    _switchResult = "!areEqual";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("test operator " + op + " not currently supported");
                }
            }
        } else {
            throw new UnsupportedOperationException("test operator " + op + " not currently supported");
        }
        return _switchResult;
    }

    private CharSequence _toDotSep(RosettaAttributeReference call) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _dotSep = this.toDotSep(call.getReceiver());
        _builder.append((Object)_dotSep);
        _builder.append(".");
        String _name = call.getAttribute().getName();
        _builder.append(_name);
        return _builder;
    }

    private CharSequence _toDotSep(RosettaDataReference call) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = call.getData().getName();
        _builder.append(_name);
        return _builder;
    }

    private CharSequence _toDotSepDropFirst(RosettaAttributeReference call) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _dotSepDropFirst = this.toDotSepDropFirst(call.getReceiver());
        _builder.append((Object)_dotSepDropFirst);
        String _name = call.getAttribute().getName();
        _builder.append(_name);
        _builder.append(".");
        return _builder;
    }

    private CharSequence _toDotSepDropFirst(RosettaDataReference call) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    private CharSequence _handleWhenRight(RosettaMapTestExpression right) {
        String _simpleName = right.getClass().getSimpleName();
        String _plus = "Unsupported expression type " + _simpleName;
        throw new UnsupportedOperationException(_plus);
    }

    private CharSequence _handleWhenRight(RosettaStringLiteral right) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _value = right.getValue();
        _builder.append(_value);
        _builder.append("\"");
        return _builder;
    }

    private CharSequence _handleWhenRight(RosettaBooleanLiteral right) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Boolean.valueOf(");
        boolean _isValue = right.isValue();
        _builder.append((Object)_isValue);
        _builder.append(")");
        return _builder;
    }

    private CharSequence _handleWhenRight(RosettaIntLiteral right) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Integer.valueOf(");
        BigInteger _value = right.getValue();
        _builder.append((Object)_value);
        _builder.append(")");
        return _builder;
    }

    private CharSequence _handleWhenRight(RosettaNumberLiteral right) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("BigDecimal.valueOf(");
        BigDecimal _value = right.getValue();
        _builder.append((Object)_value);
        _builder.append(")");
        return _builder;
    }

    private void generateEnumParsers(SynonymMap mapping, Map<String, GenerationResult> generated, String childName, Map<String, Long> synHashCache) {
        boolean _containsKey = generated.containsKey(IterableUtil.fullname((RosettaType)mapping.getRosetta()));
        if (_containsKey) {
            return;
        }
        Long prevHash = synHashCache.get(IterableUtil.fullname((RosettaType)mapping.getRosetta()));
        long newHash = mapping.hashForGeneration();
        if (prevHash == null || newHash != prevHash) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("package ");
            _builder.append(childName);
            _builder.append(".");
            String _packageName = IterableUtil.packageName((RosettaType)mapping.getRosetta());
            _builder.append(_packageName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("import java.util.Map;");
            _builder.newLine();
            _builder.newLine();
            String _basicEnumParserImports = this.basicEnumParserImports(mapping);
            _builder.append(_basicEnumParserImports);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("public class ");
            CharSequence _pNameW = this.pNameW(mapping);
            _builder.append((Object)_pNameW);
            _builder.append(" extends EnumParseHandler<");
            String _rosettaName = mapping.rosettaName();
            _builder.append(_rosettaName);
            _builder.append("> {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private final Map<String, ");
            String _rosettaName_1 = mapping.rosettaName();
            _builder.append(_rosettaName_1, "\t");
            _builder.append("> lookup;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _enumConstructor = this.enumConstructor(mapping);
            _builder.append((Object)_enumConstructor, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("protected ");
            String _rosettaName_2 = mapping.rosettaName();
            _builder.append(_rosettaName_2, "\t");
            _builder.append(" convert(String value) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _rosettaName_3 = mapping.rosettaName();
            _builder.append(_rosettaName_3, "\t\t");
            _builder.append(" enumValue = lookup.get(value);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if (enumValue!=null) return enumValue;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("throw new RuntimeException(\"Could not find matching ");
            String _name = mapping.getRosetta().getName();
            _builder.append(_name, "\t\t");
            _builder.append(" for [\" + value + \"]\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            String parser = _builder.toString();
            String _fullname = IterableUtil.fullname((RosettaType)mapping.getRosetta());
            GenerationResult _generationResult = new GenerationResult(false, parser);
            generated.put(_fullname, _generationResult);
            synHashCache.put(IterableUtil.fullname((RosettaType)mapping.getRosetta()), newHash);
        } else {
            String _fullname_1 = IterableUtil.fullname((RosettaType)mapping.getRosetta());
            GenerationResult _generationResult_1 = new GenerationResult(true, null);
            generated.put(_fullname_1, _generationResult_1);
        }
    }

    private CharSequence enumConstructor(SynonymMap mapping) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _name = mapping.getRosetta().getName();
        _builder.append(_name);
        _builder.append("ParseHandler(boolean allowsMultiple, boolean condition, boolean removeHtml) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this(allowsMultiple, condition, removeHtml, null, null);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public ");
        String _name_1 = mapping.getRosetta().getName();
        _builder.append(_name_1);
        _builder.append("ParseHandler(boolean allowsMultiple, boolean condition, boolean removeHtml, String patternMatch, String patternReplace) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super(allowsMultiple, condition, removeHtml, patternMatch, patternReplace);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ImmutableMap.Builder<String, ");
        String _rosettaName = mapping.rosettaName();
        _builder.append(_rosettaName, "\t");
        _builder.append("> builder = ImmutableMap.builder();");
        _builder.newLineIfNotEmpty();
        List _sort = IterableExtensions.sort(mapping.attributeGroups());
        for (AttributeGroup attrPathSynGroup : _sort) {
            Functions.Function1 _function = sp -> sp.getSynonymValues();
            Functions.Function1 _function_1 = it -> {
                Functions.Function1 _function_2 = it_1 -> it_1.getName();
                return IterableExtensions.join((Iterable)ListExtensions.map(it.getSynonymPath(), (Functions.Function1)_function_2));
            };
            List _sortBy = IterableExtensions.sortBy((Iterable)IterableExtensions.flatMap(attrPathSynGroup.getSynonymGroups(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            for (SynonymValue synonymValue : _sortBy) {
                _builder.append("\t\t\t");
                _builder.append("builder.put(\"");
                Functions.Function1 _function_2 = it -> it.getName();
                String _join = IterableExtensions.join((Iterable)ListExtensions.map(synonymValue.getSynonymPath(), (Functions.Function1)_function_2));
                _builder.append(_join, "\t\t\t");
                _builder.append("\", ");
                String _rosettaName_1 = mapping.rosettaName();
                _builder.append(_rosettaName_1, "\t\t\t");
                _builder.append(".");
                String _formatEnumName = EnumHelper.formatEnumName((String)((ExpandedAttribute)IterableExtensions.lastOrNull(attrPathSynGroup.getAttributePath())).getName());
                _builder.append(_formatEnumName, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("lookup = builder.build();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private <T extends RosettaModelObject> String basicEnumParserImports(SynonymMap mapping) {
        EObject _eContainer = mapping.getRosetta().eContainer();
        RosettaModel rosettaModel = (RosettaModel)_eContainer;
        ArrayList imports = CollectionLiterals.newArrayList();
        CollectionExtensions.addAll((Collection)imports, (Object[])new String[]{"import com.google.common.collect.ImmutableMap", "import com.regnosys.rosetta.translate.basic.EnumParseHandler", "import com.regnosys.rosetta.common.translation.Path"});
        String _name = rosettaModel.getName();
        String _plus = "import " + _name;
        String _plus_1 = _plus + ".";
        String _name_1 = mapping.getRosetta().getName();
        String _plus_2 = _plus_1 + _name_1;
        imports.add(_plus_2);
        return imports.stream().sorted().distinct().collect(Collectors.joining(";\n", "", ";"));
    }

    public String generateXmlFactory(String packageName, String factoryName, List<GeneratorParams> generatorParamsList) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.net.MalformedURLException;");
        _builder.newLine();
        _builder.append("import java.net.URL;");
        _builder.newLine();
        _builder.append("import java.nio.file.Files;");
        _builder.newLine();
        _builder.append("import java.nio.file.Path;");
        _builder.newLine();
        _builder.append("import java.nio.file.Paths;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import javax.xml.validation.Schema;");
        _builder.newLine();
        _builder.append("import javax.xml.validation.SchemaFactory;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.common.translation.MappingContext;");
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.common.util.UrlUtils;");
        _builder.newLine();
        _builder.append("import org.xml.sax.SAXException;");
        _builder.newLine();
        _builder.append("import com.google.inject.Injector;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import com.rosetta.model.lib.RosettaModelObject;");
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.translate.*;");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getTopLevelTags();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.concat((Iterable)ListExtensions.map(generatorParamsList, (Functions.Function1)_function)));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("import java.util.Arrays;");
            _builder.newLine();
        }
        _builder.append("import java.util.function.Function;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(factoryName);
        _builder.append(" implements XmlHandlerFactory {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Function<MappingContext, Map<Class<? extends RosettaModelObject>, HandlerSupplier>> factory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Map<Class<? extends RosettaModelObject>, Schema> schemas = new HashMap<>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance(\"http://www.w3.org/2001/XMLSchema\");");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getSchema();
        List _map = ListExtensions.map(generatorParamsList, (Functions.Function1)_function_1);
        for (URL xsdUrl : _map) {
            _builder.append("\t");
            _builder.append("private static Schema ");
            String _urlToStaticVar = this.urlToStaticVar(xsdUrl);
            _builder.append(_urlToStaticVar, "\t");
            _builder.append(" = newSchema(\"");
            String _protocol = xsdUrl.getProtocol();
            boolean _equals = Objects.equals(_protocol, "jar");
            if (_equals) {
                String _lastOrNull = (String)IterableExtensions.lastOrNull((Iterable)Splitter.on((String)"!/").split((CharSequence)xsdUrl.getPath()));
                _builder.append(_lastOrNull, "\t");
            } else {
                String _escapeJava = StringEscapeUtils.escapeJava((String)UrlUtils.toPath((URL)xsdUrl).toString());
                _builder.append(_escapeJava, "\t");
            }
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Injector injector;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@jakarta.inject.Inject");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(factoryName, "\t");
        _builder.append("(Injector injector) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this.injector = injector;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.factory = (mappingContext) -> {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Map<Class<? extends RosettaModelObject>, HandlerSupplier> handlerMap = new HashMap<>();");
        _builder.newLine();
        for (GeneratorParams params : generatorParamsList) {
            Collection<RosettaType> _rosettaEntities = params.getRosettaEntities();
            for (RosettaType rmo : _rosettaEntities) {
                boolean _isEmpty_1 = params.getTopLevelTags().isEmpty();
                if (_isEmpty_1) {
                    _builder.append("\t\t\t\t");
                    _builder.append("handlerMap.put(");
                    String _fullname = IterableUtil.fullname((RosettaType)rmo);
                    _builder.append(_fullname, "\t\t\t\t");
                    _builder.append(".class, (a, b) -> new ");
                    CharSequence _pFullNameT = this.pFullNameT(rmo, params.getChildPackageName());
                    _builder.append((Object)_pFullNameT, "\t\t\t\t");
                    _builder.append("(injector, mappingContext));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t\t\t\t");
                _builder.append("handlerMap.put(");
                String _fullname_1 = IterableUtil.fullname((RosettaType)rmo);
                _builder.append(_fullname_1, "\t\t\t\t");
                _builder.append(".class, (a, b) -> new RootHandler<>(\"");
                String _name = rmo.getName();
                _builder.append(_name, "\t\t\t\t");
                _builder.append("\", new ");
                CharSequence _pFullNameT_1 = this.pFullNameT(rmo, params.getChildPackageName());
                _builder.append((Object)_pFullNameT_1, "\t\t\t\t");
                _builder.append("(injector, mappingContext), Arrays.asList(");
                Functions.Function1 _function_2 = it -> "\"" + it + "\"";
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map(params.getTopLevelTags(), (Functions.Function1)_function_2), (CharSequence)", ");
                _builder.append(_join, "\t\t\t\t");
                _builder.append(")));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t\t");
        _builder.append("return handlerMap;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        for (GeneratorParams params_1 : generatorParamsList) {
            Collection<RosettaType> _rosettaEntities_1 = params_1.getRosettaEntities();
            for (RosettaType rmo_1 : _rosettaEntities_1) {
                _builder.append("\t\t");
                _builder.append("schemas.put(");
                String _fullname_2 = IterableUtil.fullname((RosettaType)rmo_1);
                _builder.append(_fullname_2, "\t\t");
                _builder.append(".class, ");
                String _urlToStaticVar_1 = this.urlToStaticVar(params_1.getSchema());
                _builder.append(_urlToStaticVar_1, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Map<Class<? extends RosettaModelObject>, HandlerSupplier> getHandlerSuppliers(MappingContext mappingContext) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return factory.apply(mappingContext);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Map<Class<? extends RosettaModelObject>, Schema> getSchemas() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return schemas;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static Path getXsdPath(String xsdFilePath) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Path path = Paths.get(xsdFilePath);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (Files.exists(path)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return path;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("URL resource = ");
        _builder.append(factoryName, "\t\t");
        _builder.append(".class.getClassLoader().getResource(xsdFilePath);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (resource != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return UrlUtils.toPath(resource);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new IngestException(\"Error reading xsd file - \" + xsdFilePath + \" could not be found\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static Schema newSchema(String schemaUrl) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return SCHEMA_FACTORY.newSchema(getXsdPath(schemaUrl).toUri().toURL());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (SAXException | MalformedURLException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw new IngestException(\"Failed to create Schema URL for \" + schemaUrl, e);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Injector getInjector() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return injector;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public String generateJsonFactory(String packageName, String factoryName, List<GeneratorParams> generatorParamsList) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.net.MalformedURLException;");
        _builder.newLine();
        _builder.append("import java.net.URL;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import com.google.inject.Injector;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.common.translation.MappingContext;");
        _builder.newLine();
        _builder.append("import com.rosetta.model.lib.RosettaModelObject;");
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.translate.*;");
        _builder.newLine();
        _builder.append("import com.regnosys.rosetta.translate.basic.*;");
        _builder.newLine();
        Functions.Function1 _function = it -> it.getTopLevelTags();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.concat((Iterable)ListExtensions.map(generatorParamsList, (Functions.Function1)_function)));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("import java.util.Arrays;");
            _builder.newLine();
        }
        _builder.append("import java.util.function.Function;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class ");
        _builder.append(factoryName);
        _builder.append(" implements JsonHandlerFactory {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Function<MappingContext, Map<Class<? extends RosettaModelObject>, HandlerSupplier>> factory;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Injector injector;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@jakarta.inject.Inject");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(factoryName, "\t");
        _builder.append("(Injector injector) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this.injector = injector;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.factory = (mappingContext) -> {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Map<Class<? extends RosettaModelObject>, HandlerSupplier> handlerMap = new HashMap<>();");
        _builder.newLine();
        for (GeneratorParams params : generatorParamsList) {
            Collection<RosettaType> _rosettaEntities = params.getRosettaEntities();
            for (RosettaType rmo : _rosettaEntities) {
                boolean _isEmpty_1 = params.getTopLevelTags().isEmpty();
                if (_isEmpty_1) {
                    _builder.append("\t\t\t\t");
                    _builder.append("handlerMap.put(");
                    String _fullname = IterableUtil.fullname((RosettaType)rmo);
                    _builder.append(_fullname, "\t\t\t\t");
                    _builder.append(".class, (a, b) -> new ");
                    CharSequence _pFullNameT = this.pFullNameT(rmo, params.getChildPackageName());
                    _builder.append((Object)_pFullNameT, "\t\t\t\t");
                    _builder.append("(injector, mappingContext));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t\t\t\t");
                _builder.append("handlerMap.put(");
                String _fullname_1 = IterableUtil.fullname((RosettaType)rmo);
                _builder.append(_fullname_1, "\t\t\t\t");
                _builder.append(".class, (a, b) -> new RootHandler<>(\"");
                String _name = rmo.getName();
                _builder.append(_name, "\t\t\t\t");
                _builder.append("\", new ");
                CharSequence _pFullNameT_1 = this.pFullNameT(rmo, params.getChildPackageName());
                _builder.append((Object)_pFullNameT_1, "\t\t\t\t");
                _builder.append("(injector, mappingContext), Arrays.asList(");
                Functions.Function1 _function_1 = it -> "\"" + it + "\"";
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map(params.getTopLevelTags(), (Functions.Function1)_function_1), (CharSequence)", ");
                _builder.append(_join, "\t\t\t\t");
                _builder.append(")));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t\t");
        _builder.append("return handlerMap;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Map<Class<? extends RosettaModelObject>, HandlerSupplier> getHandlerSuppliers(MappingContext mappingContext) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return factory.apply(mappingContext);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Injector getInjector() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return injector;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String urlToStaticVar(URL u) {
        return UrlUtils.getFileName((URL)u).replaceAll("[-,.]", "_").toUpperCase();
    }

    private SynonymValue removeLast(SynonymValue synonymValue) {
        List<Element> _removeLast = this.removeLast(synonymValue.getSynonymPath());
        int _mapsTo = synonymValue.getMapsTo();
        boolean _isMeta = synonymValue.isMeta();
        return new SynonymValue(_removeLast, _mapsTo, _isMeta);
    }

    private AttributeGroup removeLast(AttributeGroup group) {
        Functions.Function1 _function = it -> this.removeLast((SynonymGroup)it);
        List _map = ListExtensions.map(group.getSynonymGroups(), (Functions.Function1)_function);
        List<ExpandedAttribute> _removeLast = this.removeLast(group.getAttributePath());
        return new AttributeGroup(_map, _removeLast);
    }

    private SynonymGroup removeLast(SynonymGroup group) {
        Functions.Function1 _function = it -> this.removeLast((SynonymValue)it);
        List _map = ListExtensions.map(group.getSynonymValues(), (Functions.Function1)_function);
        List<SynonymCondition> _conditions = group.getConditions();
        String _mapperName = group.getMapperName();
        String _formatString = group.getFormatString();
        String _patternMatcher = group.getPatternMatcher();
        String _patternReplace = group.getPatternReplace();
        boolean _isRemoveHtml = group.isRemoveHtml();
        return new SynonymGroup(_map, _conditions, _mapperName, _formatString, _patternMatcher, _patternReplace, _isRemoveHtml);
    }

    private <T> List<T> removeLast(List<T> list) {
        int _size = list.size();
        int _minus = _size - 1;
        return list.subList(0, _minus);
    }

    private Object penultimateBuilder(List<ExpandedAttribute> attributes, SynonymMap mapping) {
        boolean _greaterEqualsThan;
        int _size = attributes.size();
        boolean bl = _greaterEqualsThan = _size >= 2;
        if (_greaterEqualsThan) {
            int _size_1 = attributes.size();
            int _minus = _size_1 - 2;
            return this.expandedTypeToBuilder(attributes.get(_minus).getType());
        }
        return this.toBuilder((EObject)mapping.getRosetta());
    }

    private Object firstMultipleBuilder(List<ExpandedAttribute> attributes, SynonymMap mapping) {
        boolean _greaterEqualsThan;
        ArrayList<ExpandedAttribute> resAt = this.toFirstMultiple(attributes);
        int _size = resAt.size();
        boolean bl = _greaterEqualsThan = _size >= 1;
        if (_greaterEqualsThan) {
            return this.expandedTypeToBuilder(((ExpandedAttribute)IterableExtensions.lastOrNull(resAt)).getType());
        }
        return this.toBuilder((EObject)mapping.getRosetta());
    }

    @XbaseGenerated
    public boolean isAbstract(RosettaType type) {
        if (type instanceof Data) {
            return this._isAbstract((Data)type);
        }
        if (type != null) {
            return this._isAbstract(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    @XbaseGenerated
    private StringConcatenationClient toBuilder(EObject type) {
        if (type instanceof RosettaTypeAlias) {
            return this._toBuilder((RosettaTypeAlias)type);
        }
        if (type instanceof Data) {
            return this._toBuilder((Data)type);
        }
        if (type instanceof RosettaBuiltinType) {
            return this._toBuilder((RosettaBuiltinType)type);
        }
        if (type instanceof RosettaEnumeration) {
            return this._toBuilder((RosettaEnumeration)type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    @XbaseGenerated
    private CharSequence evaluate(RosettaMapTestExpression ref) {
        if (ref instanceof RosettaEnumValueReference) {
            return this._evaluate((RosettaEnumValueReference)ref);
        }
        if (ref instanceof RosettaLiteral) {
            return this._evaluate((RosettaLiteral)ref);
        }
        if (ref != null) {
            return this._evaluate(ref);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ref).toString());
    }

    @XbaseGenerated
    private CharSequence handleTest(SynonymTest test, String pathList, List<ExpandedAttribute> attributePath) {
        if (test instanceof SynonymAbsentTest) {
            return this._handleTest((SynonymAbsentTest)test, pathList, attributePath);
        }
        if (test instanceof SynonymBinaryTest) {
            return this._handleTest((SynonymBinaryTest)test, pathList, attributePath);
        }
        if (test instanceof SynonymConditionFuncTest) {
            return this._handleTest((SynonymConditionFuncTest)test, pathList, attributePath);
        }
        if (test instanceof SynonymExistsTest) {
            return this._handleTest((SynonymExistsTest)test, pathList, attributePath);
        }
        if (test instanceof SynonymPathTest) {
            return this._handleTest((SynonymPathTest)test, pathList, attributePath);
        }
        if (test instanceof SynonymRosettaPathTest) {
            return this._handleTest((SynonymRosettaPathTest)test, pathList, attributePath);
        }
        if (test != null) {
            return this._handleTest(test, pathList, attributePath);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(test, pathList, attributePath).toString());
    }

    @XbaseGenerated
    private CharSequence toDotSep(RosettaAttributeReferenceSegment call) {
        if (call instanceof RosettaAttributeReference) {
            return this._toDotSep((RosettaAttributeReference)call);
        }
        if (call instanceof RosettaDataReference) {
            return this._toDotSep((RosettaDataReference)call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(call).toString());
    }

    @XbaseGenerated
    private CharSequence toDotSepDropFirst(RosettaAttributeReferenceSegment call) {
        if (call instanceof RosettaAttributeReference) {
            return this._toDotSepDropFirst((RosettaAttributeReference)call);
        }
        if (call instanceof RosettaDataReference) {
            return this._toDotSepDropFirst((RosettaDataReference)call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(call).toString());
    }

    @XbaseGenerated
    private CharSequence handleWhenRight(RosettaMapTestExpression right) {
        if (right instanceof RosettaBooleanLiteral) {
            return this._handleWhenRight((RosettaBooleanLiteral)right);
        }
        if (right instanceof RosettaIntLiteral) {
            return this._handleWhenRight((RosettaIntLiteral)right);
        }
        if (right instanceof RosettaNumberLiteral) {
            return this._handleWhenRight((RosettaNumberLiteral)right);
        }
        if (right instanceof RosettaStringLiteral) {
            return this._handleWhenRight((RosettaStringLiteral)right);
        }
        if (right != null) {
            return this._handleWhenRight(right);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(right).toString());
    }

    @org.eclipse.xtend.lib.annotations.Data
    public static class ParseHandlersAndMappingErrors {
        private final List<GeneratedNameAndSource> parseHandlers;
        private final List<MappingError> errors;

        public ParseHandlersAndMappingErrors(List<GeneratedNameAndSource> parseHandlers, List<MappingError> errors) {
            this.parseHandlers = parseHandlers;
            this.errors = errors;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parseHandlers == null ? 0 : this.parseHandlers.hashCode());
            return 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParseHandlersAndMappingErrors other = (ParseHandlersAndMappingErrors)obj;
            if (this.parseHandlers == null ? other.parseHandlers != null : !this.parseHandlers.equals(other.parseHandlers)) {
                return false;
            }
            return !(this.errors == null ? other.errors != null : !this.errors.equals(other.errors));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("parseHandlers", this.parseHandlers);
            b.add("errors", this.errors);
            return b.toString();
        }

        @Pure
        public List<GeneratedNameAndSource> getParseHandlers() {
            return this.parseHandlers;
        }

        @Pure
        public List<MappingError> getErrors() {
            return this.errors;
        }
    }

    @org.eclipse.xtend.lib.annotations.Data
    public static class GeneratedIngesters {
        private final GeneratedNameAndSource generatedFactory;
        private final List<GeneratedNameAndSource> generatedHandlers;
        private final List<MappingError> errors;

        public Map<String, GenerationResult> classNameToDef() {
            HashMap classes = CollectionLiterals.newHashMap();
            classes.put(this.generatedFactory.getClassName(), this.generatedFactory.getSource());
            Consumer<GeneratedNameAndSource> _function = it -> classes.put(it.getClassName(), it.getSource());
            this.generatedHandlers.forEach(_function);
            return classes;
        }

        public GeneratedIngesters(GeneratedNameAndSource generatedFactory, List<GeneratedNameAndSource> generatedHandlers, List<MappingError> errors) {
            this.generatedFactory = generatedFactory;
            this.generatedHandlers = generatedHandlers;
            this.errors = errors;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.generatedFactory == null ? 0 : this.generatedFactory.hashCode());
            result = 31 * result + (this.generatedHandlers == null ? 0 : this.generatedHandlers.hashCode());
            return 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedIngesters other = (GeneratedIngesters)obj;
            if (this.generatedFactory == null ? other.generatedFactory != null : !this.generatedFactory.equals(other.generatedFactory)) {
                return false;
            }
            if (this.generatedHandlers == null ? other.generatedHandlers != null : !this.generatedHandlers.equals(other.generatedHandlers)) {
                return false;
            }
            return !(this.errors == null ? other.errors != null : !this.errors.equals(other.errors));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("generatedFactory", (Object)this.generatedFactory);
            b.add("generatedHandlers", this.generatedHandlers);
            b.add("errors", this.errors);
            return b.toString();
        }

        @Pure
        public GeneratedNameAndSource getGeneratedFactory() {
            return this.generatedFactory;
        }

        @Pure
        public List<GeneratedNameAndSource> getGeneratedHandlers() {
            return this.generatedHandlers;
        }

        @Pure
        public List<MappingError> getErrors() {
            return this.errors;
        }
    }

    public static class UniqueFilter<T, O>
    implements Predicate<T> {
        private Set<O> seen = CollectionLiterals.newHashSet();
        private Function<T, O> propExtract;

        public UniqueFilter(Function<T, O> propExt) {
            this.propExtract = propExt;
        }

        @Override
        public boolean test(T t) {
            return this.seen.add(this.propExtract.apply(t));
        }
    }
}

