/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.ROMParseHandler;
import com.regnosys.rosetta.translate.SynonymValueGroup;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerCache<A extends RosettaModelObjectBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerCache.class);
    private final Multimap<String, SynonymValueGroup> synonyms;
    private final Map<String, Integer> handlersPerAttributeCount;
    private final List<ROMParseHandler<A>> masterHandlerList;
    private final Table<String, SynonymValueGroup, List<ROMParseHandler<A>>> handlerCache;

    public HandlerCache(Multimap<String, SynonymValueGroup> synonyms) {
        this.synonyms = synonyms;
        this.handlersPerAttributeCount = new HashMap<String, Integer>();
        this.masterHandlerList = new ArrayList<ROMParseHandler<A>>();
        this.handlerCache = HashBasedTable.create();
    }

    public ROMParseHandler<A> getOrCreateHandler(String attribute, Path xmlPath, Supplier<? extends ROMParseHandler<A>> supplier) {
        Collection groups = this.synonyms.get((Object)attribute);
        SynonymValueGroup group = groups.stream().filter(g -> g.startMatches(xmlPath)).findFirst().orElse(null);
        if (group == null) {
            LOGGER.debug("SynonymValueGroup not found for {}", (Object)xmlPath);
            group = new SynonymValueGroup(new String[0]);
        }
        int cardinality = xmlPath.cardinality();
        ArrayList<ROMParseHandler<A>> handlers = (ArrayList<ROMParseHandler<A>>)this.handlerCache.get((Object)attribute, (Object)group);
        if (handlers == null) {
            handlers = new ArrayList<ROMParseHandler<A>>();
            this.handlerCache.put((Object)attribute, (Object)group, handlers);
        }
        if (handlers.size() > cardinality) {
            ROMParseHandler result = (ROMParseHandler)handlers.get(cardinality);
            result.addXmlPath(xmlPath);
            return result;
        }
        Integer handlerCount = this.handlersPerAttributeCount.merge(attribute, 0, (k, i) -> k + 1);
        ROMParseHandler<A> result = null;
        if (handlerCount < this.masterHandlerList.size()) {
            result = this.masterHandlerList.get(handlerCount);
        } else {
            result = supplier.get();
            this.masterHandlerList.add(result);
        }
        handlers.add(result);
        result.addXmlPath(xmlPath);
        return result;
    }

    public List<ROMParseHandler<A>> getAllHandlers() {
        return this.masterHandlerList;
    }
}

