/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.service;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.translate.TranslatorOptions;
import com.regnosys.rosetta.translate.TranslatorOptionsGroup;
import com.regnosys.rosetta.translate.TranslatorOptionsImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TranslatorOptionsFactory {
    public static final String INGESTION_DIR = "ingestions";
    public static final String INGESTION_JSON_REGEX = ".*ingestions\\.json";
    private final Map<String, TranslatorOptionsImpl> environments;

    public static Collection<URL> getDefaultIngestionResource(ClassLoader classLoader) {
        return ClassPathUtils.findPathsFromClassPath(List.of(INGESTION_DIR), (String)INGESTION_JSON_REGEX, Optional.empty(), (ClassLoader)classLoader).stream().map(UrlUtils::toUrl).collect(Collectors.toList());
    }

    public TranslatorOptionsFactory(Collection<URL> ingestionEnvs) {
        ObjectMapper mapper = TranslatorOptionsFactory.getMapper();
        try {
            TranslatorOptionsGroup resultGroup = new TranslatorOptionsGroup();
            resultGroup.setOptions(new HashMap<String, TranslatorOptionsImpl>());
            for (URL u : ingestionEnvs) {
                Reader reader = UrlUtils.openURL((URL)u);
                TranslatorOptionsGroup readEnv = (TranslatorOptionsGroup)mapper.readValue(reader, TranslatorOptionsGroup.class);
                resultGroup = resultGroup.mergeGroups(readEnv);
            }
            this.environments = resultGroup.getOptions();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TranslatorOptions getTranslatorOptions(String envName) {
        return Optional.ofNullable(this.environments.get(envName)).orElseThrow(() -> new IllegalArgumentException("Could not find translate options for " + envName + ". Available options are " + String.valueOf(this.environments.keySet())));
    }

    private static ObjectMapper getMapper() {
        return new ObjectMapper().registerModule((Module)new GuavaModule()).registerModule((Module)new Jdk8Module());
    }
}

