/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.service;

import com.google.inject.Injector;
import com.regnosys.ingest.test.framework.ingestor.service.TranslatorOptionsFactory;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.SynonymToEnumMapGenerator;
import com.regnosys.rosetta.translate.Translator;
import com.regnosys.rosetta.translate.TranslatorOptions;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;

public class IngestionCodeGeneratorMain {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Incorrect number of args " + Arrays.toString(args));
        } else {
            String ingestionEnv = args[0];
            String outputPath = args[1];
            Collection<URL> ingestionResources = TranslatorOptionsFactory.getDefaultIngestionResource(IngestionCodeGeneratorMain.class.getClassLoader());
            Injector injector = new RosettaStandaloneSetup().createInjectorAndDoEMFRegistration();
            IngesterGenerator generator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
            SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
            TranslatorOptionsFactory translatorOptionsFactory = new TranslatorOptionsFactory(ingestionResources);
            TranslatorOptions translatorOptions = translatorOptionsFactory.getTranslatorOptions(ingestionEnv);
            Translator translator = new Translator(translatorOptions, IngestionCodeGeneratorMain.class.getClassLoader(), generator, synonymToEnumMapGenerator);
            translator.generateJava(Path.of(outputPath, new String[0]), false);
        }
    }
}

