/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.postprocess;

import com.codahale.metrics.Timer;
import com.regnosys.ingest.test.framework.ingestor.generic.GenericErrorReport;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.PostProcessor;
import com.rosetta.model.lib.process.ProcessingException;
import com.rosetta.model.lib.validation.ValidationResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessorRunner
implements PostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostProcessorRunner.class);
    private final List<PostProcessStep> postProcessors;
    private final Map<Class<?>, PostProcessorReport> reportsMap;
    private static final String GENERIC_ERROR_TITLE = "Error occurred as part of post processing of ingested document";

    public PostProcessorRunner(PostProcessStep ... postProcessors) {
        this(Arrays.asList(postProcessors));
    }

    public PostProcessorRunner(List<PostProcessStep> postProcessors) {
        this.postProcessors = postProcessors.stream().sorted(Comparator.comparingInt(PostProcessStep::getPriority)).toList();
        this.reportsMap = new HashMap();
    }

    public <T extends RosettaModelObject> RosettaModelObjectBuilder postProcess(Class<T> rosettaType, RosettaModelObjectBuilder instance) {
        return this.postProcess(rosettaType, instance, new ArrayList(), new ArrayList<GenericErrorReport.ErrorMessage>());
    }

    public <T extends RosettaModelObject> RosettaModelObjectBuilder postProcess(Class<T> rosettaType, RosettaModelObjectBuilder instance, List<ValidationResult<?>> postProcessorErrors, List<GenericErrorReport.ErrorMessage> genericErrors) {
        RosettaModelObjectBuilder obj = instance.prune();
        for (PostProcessStep postProcessor : this.postProcessors) {
            LOGGER.debug("Running post processor {}", (Object)postProcessor.getName());
            Timer timer = IngestionService.INGESTION_METRICS.timer(postProcessor.getName());
            Timer.Context time = timer.time();
            try {
                PostProcessorReport report = postProcessor.runProcessStep(rosettaType, (RosettaModelObject)obj);
                this.reportsMap.put(postProcessor.getClass(), report);
            }
            catch (ProcessingException e) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
                postProcessorErrors.add((ValidationResult<?>)new ValidationResult.ProcessValidationResult(e.getMessage(), e.getObjectName(), e.getProcessorName(), e.getPath()));
            }
            catch (Exception e) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
                RosettaPath path = RosettaPath.valueOf((String)rosettaType.getCanonicalName());
                String value = String.format("The failing Processor \"%s\" in Rosetta Model \"%s\" returned with  error \"%s\"", postProcessor.getName(), path, e.getLocalizedMessage());
                String stackTrace = this.getStackTraceAsString(e);
                genericErrors.add(new GenericErrorReport.ErrorMessage(GENERIC_ERROR_TITLE, value, stackTrace));
            }
            time.stop();
        }
        return obj;
    }

    public Optional<PostProcessorReport> reportFor(Class<?> processor) {
        Optional<Class> subClazz;
        PostProcessorReport report = this.reportsMap.get(processor);
        if (report == null && (subClazz = this.reportsMap.keySet().stream().filter(clazz -> processor.isAssignableFrom((Class<?>)clazz)).findFirst()).isPresent()) {
            return this.reportFor(subClazz.get());
        }
        return Optional.ofNullable(report);
    }

    private String getStackTraceAsString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

