/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.regnosys.granite.ingestor.parser.InputValidationReport;
import com.regnosys.ingest.test.framework.ingestor.IngestionParserMapper;
import com.regnosys.ingest.test.framework.ingestor.service.IngestionService;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReport;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReportBuilder;
import com.regnosys.ingest.test.framework.util.PathUtils;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.translate.HandlerFactory;
import com.regnosys.rosetta.translate.JsonHandlerFactory;
import com.regnosys.rosetta.translate.OurJsonParser;
import com.regnosys.rosetta.translate.ParserResult;
import com.regnosys.rosetta.translate.SynonymToEnumMapBuilder;
import com.regnosys.rosetta.translate.XMLParser;
import com.regnosys.rosetta.translate.XmlHandlerFactory;
import com.regnosys.rosetta.translate.util.JsonProcessor;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import javax.xml.validation.Schema;

public class GeneratedIngestionParserMapper
implements IngestionParserMapper {
    private final Class<? extends HandlerFactory> factoryClass;
    private final Class<SynonymToEnumMapBuilder> synonymToEnumMapBuilder;
    private final String excludedPathsFileLocation;
    private final boolean isJson;
    private final boolean preProcess;
    private final Injector injector;

    public GeneratedIngestionParserMapper(Class<? extends HandlerFactory> factoryClass, Class<SynonymToEnumMapBuilder> synonymToEnumMapBuilder, String excludedPathsFileLocation, boolean isJson, boolean preProcess, Injector injector) {
        this.factoryClass = factoryClass;
        this.synonymToEnumMapBuilder = synonymToEnumMapBuilder;
        this.excludedPathsFileLocation = excludedPathsFileLocation;
        this.isJson = isJson;
        this.preProcess = preProcess;
        this.injector = injector;
    }

    @Override
    public <T extends RosettaModelObject> IngestionParserMapper.ParserMapperResult<T> parseAndMapXml(Reader reader, Class<T> rosettaModelClass) {
        Timer createFactory = IngestionService.INGESTION_METRICS.timer("createFactory");
        Timer.Context createFac = createFactory.time();
        ReferenceConfig referenceConfig = (ReferenceConfig)this.injector.getInstance(ReferenceConfig.class);
        XmlHandlerFactory factory = (XmlHandlerFactory)this.newFactoryInstance(this.factoryClass, this.injector);
        SynonymToEnumMapBuilder mapBuilder = this.newInstance(this.synonymToEnumMapBuilder);
        XMLParser xmlParser = new XMLParser(factory, mapBuilder, referenceConfig);
        createFac.stop();
        Schema xsd = factory.getSchemas().get(rosettaModelClass);
        Timer parseDocTimer = IngestionService.INGESTION_METRICS.timer("parseDocument");
        Timer.Context parseDoc = parseDocTimer.time();
        ParserResult parserResult = xmlParser.parseDocument(reader, xsd, rosettaModelClass);
        parseDoc.stop();
        RosettaModelObjectBuilder rosettaObject = parserResult.getRosettaInstance();
        Timer mappingreportTimer = IngestionService.INGESTION_METRICS.timer("mappingReport");
        Timer.Context mappingReportT = mappingreportTimer.time();
        MappingReportBuilder mappingReportBuilder = new MappingReportBuilder();
        ParserResult.Context context = parserResult.getContext();
        MappingReport mappingReport = mappingReportBuilder.toMappingReport(context.getMappingContext().getMappings(), PathUtils.getExcludedPaths(this.excludedPathsFileLocation), this.isJson);
        mappingReportT.stop();
        return new IngestionParserMapper.ParserMapperResult(rosettaObject, mappingReport, new InputValidationReport(context.getXmlValidationErrors()));
    }

    @Override
    public <T extends RosettaModelObject> IngestionParserMapper.ParserMapperResult<T> parseAndMapJSON(Reader reader, Class<T> rosettaModelClass) {
        Reader processedJson;
        JsonHandlerFactory factory = (JsonHandlerFactory)this.newFactoryInstance(this.factoryClass, this.injector);
        SynonymToEnumMapBuilder mapBuilder = this.newInstance(this.synonymToEnumMapBuilder);
        if (this.preProcess) {
            JsonProcessor jsonProcessor = new JsonProcessor("answers", new ObjectMapper());
            processedJson = this.preProcessJson(jsonProcessor, reader);
        } else {
            processedJson = reader;
        }
        ReferenceConfig referenceConfig = (ReferenceConfig)this.injector.getInstance(ReferenceConfig.class);
        OurJsonParser parser = new OurJsonParser(factory, mapBuilder, referenceConfig);
        ParserResult parserResult = parser.parseDocument(processedJson, null, rosettaModelClass);
        RosettaModelObjectBuilder rosettaObject = parserResult.getRosettaInstance();
        MappingReportBuilder mappingReportBuilder = new MappingReportBuilder();
        ParserResult.Context context = parserResult.getContext();
        MappingReport mappingReport = mappingReportBuilder.toMappingReport(context.getMappingContext().getMappings(), PathUtils.getExcludedPaths(this.excludedPathsFileLocation), this.isJson);
        return new IngestionParserMapper.ParserMapperResult(rosettaObject, mappingReport, new InputValidationReport(Collections.emptyList()));
    }

    private <T> T newFactoryInstance(Class<T> clazz, Injector injector) {
        try {
            return clazz.getConstructor(Injector.class).newInstance(injector);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Reader preProcessJson(JsonProcessor jsonProcessor, Reader input) {
        try {
            return jsonProcessor.process(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

